/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.collections;

public class FloatArrayList {
    private transient float[] elements;
    private int size;

    public FloatArrayList() {
        this(100);
    }

    public FloatArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elements = new float[initialCapacity];
    }

    public FloatArrayList(float[] elements) {
        this.elements = elements;
        this.size = elements.length;
    }

    public void add(float e2) {
        if (this.size + 1 >= this.elements.length) {
            this.grow();
        }
        this.elements[this.size++] = e2;
    }

    public void addAll(float[] args) {
        float[] newElements = new float[this.size + args.length];
        System.arraycopy(this.elements, 0, newElements, 0, this.size);
        System.arraycopy(args, 0, newElements, this.size, args.length);
        this.elements = newElements;
        this.size += args.length;
    }

    public void addAll(FloatArrayList aList) {
        this.addAll(aList.toArray());
    }

    public float get(int idx) {
        return this.elements[idx];
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.size = 0;
    }

    private void grow() {
        int oldCapacity = this.elements.length;
        int newCapacity = oldCapacity < 10000000 ? oldCapacity * 2 : oldCapacity * 3 / 2 + 1;
        float[] tmp = new float[newCapacity];
        System.arraycopy(this.elements, 0, tmp, 0, this.elements.length);
        this.elements = tmp;
    }

    public float[] toArray() {
        this.trimToSize();
        return this.elements;
    }

    private void trimToSize() {
        int oldCapacity = this.elements.length;
        if (this.size < oldCapacity) {
            float[] tmp = new float[this.size];
            System.arraycopy(this.elements, 0, tmp, 0, this.size);
            this.elements = tmp;
        }
    }
}

