/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import com.google.common.primitives.Primitives;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JavaAgent {
    private static Map<Class, Long> primitiveMemMap = new HashMap<Class, Long>(9);
    private static Instrumentation instrumentation;

    public static void premain(String args, Instrumentation inst) {
        instrumentation = inst;
    }

    public static long getObjectSize(Object o2) {
        if (instrumentation == null) {
            throw new IllegalStateException("No instrumentation available. Need to launch width -javaagent:path/to/RuntimeUtils.jar");
        }
        if (o2 == null) {
            return 4L;
        }
        return instrumentation.getObjectSize(o2);
    }

    public static long getObjectSizeRecursive(Object o2, Set<Object> completedObjs) {
        try {
            if (o2 != null && completedObjs.contains(o2)) {
                return 0L;
            }
        }
        catch (Exception e2) {
            System.out.println("Error on " + o2.getClass() + " skipping");
            return 0L;
        }
        long fullSize = JavaAgent.getObjectSize(o2);
        if (o2 == null) {
            return fullSize;
        }
        completedObjs.add(o2);
        if (JavaAgent.isPrimitiveOrWrapper(o2)) {
            return fullSize;
        }
        if (o2.getClass().isArray()) {
            for (int ii = 0; ii < Array.getLength(o2); ++ii) {
                Object el = Array.get(o2, ii);
                fullSize += JavaAgent.getObjectSizeRecursive(el, completedObjs);
            }
        }
        HashSet<Field> fields = new HashSet<Field>();
        JavaAgent.getAllFields(o2.getClass(), fields);
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                Object fieldValue = field.get(o2);
                Class<?> fieldType = field.getType();
                fullSize = fieldType.isPrimitive() ? (fullSize += primitiveMemMap.get(fieldType).longValue()) : (fullSize += JavaAgent.getObjectSizeRecursive(fieldValue, completedObjs));
                completedObjs.add(fieldValue);
            }
            catch (IllegalAccessException e3) {
                throw new RuntimeException(e3);
            }
            catch (NullPointerException e4) {
                System.out.println("Error on " + o2.getClass() + " skipping");
            }
        }
        return fullSize;
    }

    static boolean isPrimitiveOrWrapper(Object o2) {
        return o2.getClass().isPrimitive() || Primitives.isWrapperType(o2.getClass());
    }

    static void getAllFields(Class clazz, Set<Field> fields) {
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        Class supClass = clazz.getSuperclass();
        if (supClass != null) {
            JavaAgent.getAllFields(supClass, fields);
        }
    }

    static {
        primitiveMemMap.put(Byte.TYPE, 8L);
        primitiveMemMap.put(Short.TYPE, 16L);
        primitiveMemMap.put(Integer.TYPE, 32L);
        primitiveMemMap.put(Long.TYPE, 64L);
        primitiveMemMap.put(Float.TYPE, 32L);
        primitiveMemMap.put(Double.TYPE, 64L);
        primitiveMemMap.put(Boolean.TYPE, 1L);
        primitiveMemMap.put(Character.TYPE, 16L);
        primitiveMemMap.put(Void.TYPE, 0L);
        assert (primitiveMemMap.size() == Primitives.allPrimitiveTypes().size());
    }
}

