/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.broad.igv.Globals;
import org.broad.igv.util.ParsingUtils;

public class FileTransformUtils {
    static Set<String> types = new HashSet<String>(Arrays.asList("SINE", "LINE", "LTR", "DNA", "Simple_repeat", "Low_complexity", "Satellite", "RNA", "Other", "Unknown", "Uncategorized"));

    public static void main(String[] args) throws IOException {
        String ifile = "/Users/jrobinso/projects/IGV/humanv3_hg18Pos.csv";
        String output = "/Users/jrobinso/projects/IGV/humanv3Pos_hg18.bed";
        FileTransformUtils.probeToBed(ifile, output, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void probeToBed(String iFile, String oFile, boolean includeMultiMappings) throws IOException {
        BufferedReader br = null;
        PrintWriter pw = null;
        try {
            String nextLine;
            br = ParsingUtils.openBufferedReader(iFile);
            pw = new PrintWriter(new FileWriter(oFile));
            br.readLine();
            while ((nextLine = br.readLine()) != null) {
                String[] tokens = Globals.commaPattern.split(nextLine);
                String probe = tokens[0];
                if (tokens.length < 1 || tokens.length > 2 && !includeMultiMappings) continue;
                for (int i2 = 1; i2 < tokens.length; ++i2) {
                    String loc = tokens[i2];
                    String[] locParts = Globals.colonPattern.split(loc);
                    String chr = locParts[0];
                    int start = Integer.parseInt(locParts[1]) - 1;
                    int end = Integer.parseInt(locParts[2]);
                    String strand = locParts[3];
                    pw.println(chr + "\t" + start + "\t" + end + "\t" + probe + "\t1000\t" + strand);
                }
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (pw != null) {
                pw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splitRepeatMasker(String iFile, String outputDirectory, String prefix) throws IOException {
        BufferedReader br = null;
        HashMap<String, PrintWriter> pws = new HashMap<String, PrintWriter>();
        try {
            String nextLine;
            br = new BufferedReader(new FileReader(iFile));
            File dir = new File(outputDirectory);
            for (String type : types) {
                File f2 = new File(dir, prefix + type + ".bed");
                pws.put(type, new PrintWriter(new BufferedWriter(new FileWriter(f2))));
            }
            while ((nextLine = br.readLine()) != null) {
                if (nextLine.startsWith("#")) continue;
                String[] tokens = nextLine.split("\t");
                String type = FileTransformUtils.getType(tokens[5]);
                ((PrintWriter)pws.get(type)).println(tokens[0] + "\t" + tokens[1] + "\t" + tokens[2] + "\t" + tokens[4] + "\t" + tokens[3]);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            for (PrintWriter pw : pws.values()) {
                pw.close();
            }
        }
    }

    public static String getType(String s2) {
        if ((s2 = s2.replace("?", "")).contains("RNA")) {
            return "RNA";
        }
        if (s2.equals("RC")) {
            return "Other";
        }
        if (s2.equals("repClass")) {
            return "Other";
        }
        if (types.contains(s2)) {
            return s2;
        }
        return "Uncategorized";
    }
}

