/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.AminoAcidManager;
import org.broad.igv.feature.Strand;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.renderer.SequenceRenderer;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;

public class SequenceTrack
extends AbstractTrack {
    private static Logger log = Logger.getLogger(SequenceTrack.class);
    private static final int SEQUENCE_HEIGHT = 14;
    private static String NAME = "Sequence";
    private SequenceRenderer sequenceRenderer = new SequenceRenderer();
    private boolean shouldShowTranslation = true;
    private boolean sequenceVisible = false;
    Strand strand = Strand.POSITIVE;
    private boolean showColorSpace = false;
    private Rectangle arrowRect;

    public SequenceTrack(String name) {
        super(name);
        this.setSortable(false);
        this.shouldShowTranslation = PreferenceManager.getInstance().getAsBoolean("SHOW_SEQUENCE_TRANSLATION");
    }

    @Override
    public void renderName(Graphics2D graphics, Rectangle trackRectangle, Rectangle visibleRectangle) {
        Font font = FontManager.getFont(this.fontSize);
        if (this.sequenceVisible) {
            graphics.setFont(font);
            int textBaseline = trackRectangle.y + 12;
            if (PreferenceManager.getInstance().getAsBoolean("ENABLE_ANTIALIASING")) {
                graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            graphics.drawString(NAME, trackRectangle.x + 5, textBaseline);
            int rx = trackRectangle.x + trackRectangle.width - 20;
            this.arrowRect = new Rectangle(rx, trackRectangle.y + 2, 15, 10);
            this.drawArrow(graphics);
            if (AminoAcidManager.getInstance().getCodonTable().getId() != 1) {
                Font labFont = font.deriveFont(1);
                graphics.setFont(labFont);
                graphics.drawString("A", rx - 20, textBaseline);
                graphics.setFont(font);
            }
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        }
    }

    private void drawArrow(Graphics2D graphics) {
        GraphicUtils.drawHorizontalArrow(graphics, this.arrowRect, this.strand == Strand.POSITIVE);
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        boolean visible;
        int resolutionThreshold = PreferenceManager.getInstance().getAsInt("MAX_SEQUENCE_RESOLUTION");
        boolean bl = visible = FrameManager.getMinimumScale() < (double)resolutionThreshold && !context.getChr().equals("All");
        if (visible != this.sequenceVisible) {
            this.sequenceVisible = visible;
            IGV.getInstance().doRefresh();
        }
        if (this.sequenceVisible) {
            this.sequenceRenderer.setStrand(this.strand);
            this.sequenceRenderer.draw(context, rect, this.showColorSpace, this.shouldShowTranslation, resolutionThreshold);
        }
    }

    @Override
    public int getHeight() {
        return this.sequenceVisible ? 14 + (this.showColorSpace ? 14 : 0) + (this.shouldShowTranslation ? 42 : 0) : 0;
    }

    @Override
    public boolean handleDataClick(TrackClickEvent e2) {
        this.setShouldShowTranslation(!this.shouldShowTranslation);
        Object source = e2.getMouseEvent().getSource();
        if (source instanceof JComponent) {
            this.repaint();
        }
        return true;
    }

    @Override
    public void handleNameClick(MouseEvent e2) {
        if (this.arrowRect != null && this.arrowRect.contains(e2.getPoint())) {
            this.flipStrand();
        }
    }

    private void flipStrand() {
        this.strand = this.strand == Strand.POSITIVE ? Strand.NEGATIVE : Strand.POSITIVE;
        this.repaint();
        IGV.getInstance().clearSelections();
    }

    public void setShouldShowTranslation(boolean shouldShowTranslation) {
        this.shouldShowTranslation = shouldShowTranslation;
        PreferenceManager.getInstance().put("SHOW_SEQUENCE_TRANSLATION", shouldShowTranslation);
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        IGVPopupMenu menu = new IGVPopupMenu();
        JMenuItem m1 = new JMenuItem("Flip strand");
        m1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SequenceTrack.this.flipStrand();
            }
        });
        final JCheckBoxMenuItem m2 = new JCheckBoxMenuItem("Show translation");
        m2.setSelected(this.shouldShowTranslation);
        m2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SequenceTrack.this.setShouldShowTranslation(m2.isSelected());
                SequenceTrack.this.repaint();
                IGV.getInstance().clearSelections();
            }
        });
        menu.add(m1);
        menu.add(m2);
        JMenu transTableMenu = new JMenu("Translation Table");
        for (AminoAcidManager.CodonTable codonTable : AminoAcidManager.getInstance().getAllCodonTables()) {
            JCheckBoxMenuItem item = this.getCodonTableMenuItem(codonTable);
            transTableMenu.add(item);
        }
        menu.add(transTableMenu);
        return menu;
    }

    private JCheckBoxMenuItem getCodonTableMenuItem(AminoAcidManager.CodonTable codonTable) {
        String fullName;
        JCheckBoxMenuItem item = new JCheckBoxMenuItem();
        String shortName = fullName = codonTable.getDisplayName();
        if (fullName.length() > 40) {
            shortName = fullName.substring(0, 37) + "...";
            item.setToolTipText(fullName);
        }
        item.setText(shortName);
        final AminoAcidManager.CodonTableKey curKey = codonTable.getKey();
        item.setSelected(curKey.equals(AminoAcidManager.getInstance().getCodonTable().getKey()));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                AminoAcidManager.getInstance().setCodonTable(curKey);
                SequenceTrack.this.repaint();
            }
        });
        return item;
    }

    private void repaint() {
        IGV.getMainFrame().repaint();
    }

    @Override
    public Renderer getRenderer() {
        return null;
    }

    @Override
    public String getNameValueString(int y) {
        String nvs = "<html>" + super.getNameValueString(y);
        nvs = nvs + "<br>Translation Table: ";
        nvs = nvs + AminoAcidManager.getInstance().getCodonTable().getDisplayName();
        return nvs;
    }

    @Override
    public String getValueStringAt(String chr, double position, int y, ReferenceFrame frame) {
        if (this.sequenceVisible && !this.sequenceRenderer.hasSequence()) {
            return "Sequence info not found. Make sure the server in question supports byte-range requests, and that there are no firewalls which remove this information";
        }
        return null;
    }

    public Strand getStrand() {
        return this.strand;
    }
}

