/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.sort;

import htsjdk.tribble.readers.AsciiLineReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.broad.igv.feature.tribble.MUTCodec;
import org.broad.igv.tools.sort.Parser;
import org.broad.igv.tools.sort.Sorter;

public class MUTSorter
extends Sorter {
    int chrCol;
    int startCol;

    public MUTSorter(File inputFile, File outputFile) {
        super(inputFile, outputFile);
        MUTCodec codec = new MUTCodec(inputFile.getAbsolutePath(), null);
        this.chrCol = codec.getChrColumn();
        this.startCol = codec.getStartColumn();
    }

    @Override
    Parser getParser() throws IOException {
        return new Parser(this.chrCol, this.startCol);
    }

    @Override
    String writeHeader(AsciiLineReader reader, PrintWriter writer) throws IOException {
        String nextLine;
        while ((nextLine = reader.readLine()).startsWith("#")) {
            writer.println(nextLine);
        }
        writer.println(nextLine);
        nextLine = reader.readLine();
        return nextLine;
    }
}

