/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.BaseAlignmentCounts;
import org.broad.igv.util.ParsingUtils;

public abstract class AbstractConsensusCalculator {
    private static Table<Character, Character, Character> degeneracyTable;

    public char calculateConsensusBase(AlignmentCounts counts, int pos) {
        List<BaseFraction> baseFractions = this.calculateBaseFractions(counts, pos);
        return this.calculateConsensusBase(baseFractions);
    }

    protected abstract char calculateConsensusBase(List<BaseFraction> var1);

    protected final List<BaseFraction> calculateBaseFractions(AlignmentCounts counts, int pos) {
        ArrayList<BaseFraction> results = new ArrayList<BaseFraction>(5);
        int totalCount = counts.getTotalCount(pos);
        for (char c2 : BaseAlignmentCounts.nucleotides) {
            int negCount = counts.getNegCount(pos, (byte)c2);
            int posCount = counts.getPosCount(pos, (byte)c2);
            int count = negCount + posCount;
            float fraction = (float)count / (float)totalCount;
            results.add(new BaseFraction(c2, fraction));
        }
        Collections.sort(results, Collections.reverseOrder());
        return results;
    }

    protected final char getDegenerateCode(char base0, char base1) {
        Table<Character, Character, Character> degenTable = AbstractConsensusCalculator.getDegeneracyTable();
        return degenTable.get(Character.valueOf(base0), Character.valueOf(base1)).charValue();
    }

    protected static Table<Character, Character, Character> getDegeneracyTable() {
        if (degeneracyTable == null) {
            degeneracyTable = HashBasedTable.create(5, 5);
            Map<String, String> iupacMap = ParsingUtils.loadIUPACMap();
            for (String s2 : iupacMap.values()) {
                String[] tokens = (s2 = s2.replace("[", "").replace("]", "").toLowerCase()).split(",");
                if (tokens.length != 3) continue;
                char a2 = tokens[1].trim().charAt(0);
                char b2 = tokens[2].trim().charAt(0);
                char c2 = tokens[0].trim().charAt(0);
                degeneracyTable.put(Character.valueOf(a2), Character.valueOf(b2), Character.valueOf(c2));
                degeneracyTable.put(Character.valueOf(b2), Character.valueOf(a2), Character.valueOf(c2));
            }
        }
        return degeneracyTable;
    }

    public static class BaseFraction
    implements Comparable {
        public final char base;
        public final float fraction;

        public BaseFraction(char base, float fraction) {
            this.base = base;
            this.fraction = fraction;
        }

        public int compareTo(Object o2) {
            return (int)Math.signum(this.fraction - ((BaseFraction)o2).fraction);
        }
    }
}

