/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import com.google.common.eventbus.EventBus;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Range;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentPacker;
import org.broad.igv.sam.AlignmentTileLoader;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.CoverageTrack;
import org.broad.igv.sam.DownsampledInterval;
import org.broad.igv.sam.IAlignmentDataManager;
import org.broad.igv.sam.PEStats;
import org.broad.igv.sam.PackedAlignments;
import org.broad.igv.sam.PositionCache;
import org.broad.igv.sam.Row;
import org.broad.igv.sam.SpliceJunctionHelper;
import org.broad.igv.sam.reader.AlignmentReaderFactory;
import org.broad.igv.track.RenderContext;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.event.DataLoadedEvent;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.ProgressMonitor;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.ResourceLocator;

public class AlignmentDataManager
implements IAlignmentDataManager {
    private static Logger log = Logger.getLogger(AlignmentDataManager.class);
    private PositionCache<AlignmentInterval> loadedIntervalCache = new PositionCache();
    private PositionCache<PackedAlignments> packedAlignmentsCache = new PositionCache();
    private HashMap<String, String> chrMappings = new HashMap();
    private volatile boolean isLoading = false;
    private AlignmentTileLoader reader;
    private CoverageTrack coverageTrack;
    private Map<String, PEStats> peStats;
    private AlignmentTrack.ExperimentType experimentType;
    private SpliceJunctionHelper.LoadOptions loadOptions;
    private Object loadLock = new Object();
    private EventBus eventBus = new EventBus();
    private ResourceLocator locator;

    public AlignmentDataManager(ResourceLocator locator, Genome genome) throws IOException {
        this.locator = locator;
        this.reader = new AlignmentTileLoader(AlignmentReaderFactory.getReader(locator));
        this.peStats = new HashMap<String, PEStats>();
        this.initLoadOptions();
        this.initChrMap(genome);
    }

    void initLoadOptions() {
        this.loadOptions = new SpliceJunctionHelper.LoadOptions();
    }

    private void initChrMap(Genome genome) {
        List<String> seqNames;
        if (genome != null && (seqNames = this.reader.getSequenceNames()) != null) {
            for (String chr : seqNames) {
                String alias = genome.getChromosomeAlias(chr);
                this.chrMappings.put(alias, chr);
            }
        }
    }

    public void setExperimentType(AlignmentTrack.ExperimentType experimentType) {
        this.experimentType = experimentType;
    }

    public AlignmentTrack.ExperimentType getExperimentType() {
        return this.experimentType;
    }

    public AlignmentTileLoader getReader() {
        return this.reader;
    }

    public ResourceLocator getLocator() {
        return this.locator;
    }

    public Map<String, PEStats> getPEStats() {
        return this.peStats;
    }

    public boolean isPairedEnd() {
        return this.reader.isPairedEnd();
    }

    public boolean hasIndex() {
        return this.reader.hasIndex();
    }

    public void setCoverageTrack(CoverageTrack coverageTrack) {
        this.coverageTrack = coverageTrack;
    }

    public CoverageTrack getCoverageTrack() {
        return this.coverageTrack;
    }

    public List<String> getSequenceNames() {
        return this.reader.getSequenceNames();
    }

    public boolean isIonTorrent() {
        Set<String> platforms = this.reader.getPlatforms();
        if (platforms != null) {
            return platforms.contains("IONTORRENT");
        }
        return false;
    }

    @Override
    public Collection<AlignmentInterval> getLoadedIntervals() {
        return this.loadedIntervalCache.values();
    }

    @Override
    public AlignmentInterval getLoadedInterval(Range range) {
        return this.loadedIntervalCache.getForRange(range);
    }

    public boolean sortRows(AlignmentTrack.SortOption option, ReferenceFrame frame, double location, String tag) {
        PackedAlignments packedAlignments = this.packedAlignmentsCache.getForRange(frame.getCurrentRange());
        AlignmentInterval interval = this.loadedIntervalCache.getForRange(frame.getCurrentRange());
        if (packedAlignments == null || interval == null) {
            return false;
        }
        for (List alignmentRows : packedAlignments.values()) {
            for (Row row : alignmentRows) {
                row.updateScore(option, location, interval, tag);
            }
            Collections.sort(alignmentRows);
        }
        return true;
    }

    public void setViewAsPairs(boolean option, AlignmentTrack.RenderOptions renderOptions) {
        if (option == renderOptions.isViewPairs()) {
            return;
        }
        renderOptions.setViewPairs(option);
        this.packAlignments(renderOptions);
    }

    boolean packAlignments(AlignmentTrack.RenderOptions renderOptions) {
        List<ReferenceFrame> frameList = FrameManager.getFrames();
        ArrayList intervalList = new ArrayList(frameList.size());
        this.packedAlignmentsCache.clear();
        this.packedAlignmentsCache.setMaxEntries(2 * intervalList.size());
        for (ReferenceFrame frame : frameList) {
            AlignmentInterval interval = this.loadedIntervalCache.getForRange(frame.getCurrentRange());
            if (interval == null) {
                return false;
            }
            AlignmentPacker alignmentPacker = new AlignmentPacker();
            PackedAlignments packedAlignments = alignmentPacker.packAlignments(interval, renderOptions);
            this.packedAlignmentsCache.put(interval.getRange(), packedAlignments);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(RenderContext context, AlignmentTrack.RenderOptions renderOptions, boolean expandEnds) {
        Object object = this.loadLock;
        synchronized (object) {
            String chr = context.getChr();
            int start = (int)context.getOrigin();
            int end = (int)context.getEndLocation();
            AlignmentInterval loadedInterval = this.loadedIntervalCache.getForRange(context.getReferenceFrame().getCurrentRange());
            int adjustedStart = start;
            int adjustedEnd = end;
            int windowSize = Math.min(4 * (end - start), PreferenceManager.getInstance().getAsInt("SAM.MAX_VISIBLE_RANGE") * 1000);
            int center = (end + start) / 2;
            int expand = Math.max(end - start, windowSize / 2);
            if (loadedInterval != null && loadedInterval.contains(chr, start, end)) {
                return;
            }
            if (expandEnds) {
                adjustedStart = Math.max(0, Math.min(start, center - expand));
                adjustedEnd = Math.max(end, center + expand);
            }
            this.loadAlignments(chr, adjustedStart, adjustedEnd, renderOptions, context);
        }
    }

    public synchronized PackedAlignments getGroups(RenderContext context, AlignmentTrack.RenderOptions renderOptions) {
        this.load(context, renderOptions, false);
        Range range = context.getReferenceFrame().getCurrentRange();
        if (!this.packedAlignmentsCache.containsRange(range)) {
            this.packAlignments(renderOptions);
        }
        return this.packedAlignmentsCache.getForRange(context.getReferenceFrame().getCurrentRange());
    }

    public void clear() {
        this.loadedIntervalCache.clear();
        this.packedAlignmentsCache.clear();
    }

    public synchronized void loadAlignments(final String chr, final int start, final int end, final AlignmentTrack.RenderOptions renderOptions, final RenderContext context) {
        if (this.isLoading || chr.equals("All")) {
            return;
        }
        this.loadedIntervalCache.setMaxEntries(2 * FrameManager.getFrames().size());
        this.isLoading = true;
        NamedRunnable runnable = new NamedRunnable(){

            @Override
            public String getName() {
                return "loadAlignments";
            }

            @Override
            public void run() {
                log.debug("Loading alignments: " + chr + ":" + start + "-" + end + " for " + AlignmentDataManager.this);
                AlignmentInterval loadedInterval = AlignmentDataManager.this.loadInterval(chr, start, end, renderOptions);
                AlignmentDataManager.this.loadedIntervalCache.put(loadedInterval.getRange(), loadedInterval);
                List<ReferenceFrame> frameList = context != null ? Arrays.asList(context.getReferenceFrame()) : null;
                AlignmentDataManager.this.packAlignments(renderOptions);
                AlignmentDataManager.this.getEventBus().post(new DataLoadedEvent(context));
                AlignmentDataManager.this.isLoading = false;
            }
        };
        LongRunningTask.submit(runnable);
    }

    AlignmentInterval loadInterval(String chr, int start, int end, AlignmentTrack.RenderOptions renderOptions) {
        String sequence = this.chrMappings.containsKey(chr) ? this.chrMappings.get(chr) : chr;
        DownsampleOptions downsampleOptions = new DownsampleOptions();
        AlignmentTrack.BisulfiteContext bisulfiteContext = renderOptions != null ? renderOptions.bisulfiteContext : null;
        ProgressMonitor monitor = null;
        if (IGV.hasInstance() && !Globals.isBatch() && !Globals.isHeadless()) {
            ActionListener cancelListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    AlignmentTileLoader.cancelReaders();
                }
            };
            IGV.getInstance().getContentPane().getStatusBar().activateCancelButton(cancelListener);
        }
        SpliceJunctionHelper spliceJunctionHelper = new SpliceJunctionHelper(this.loadOptions);
        AlignmentTileLoader.AlignmentTile t2 = this.reader.loadTile(sequence, start, end, spliceJunctionHelper, downsampleOptions, this.peStats, bisulfiteContext, monitor);
        List<Alignment> alignments = t2.getAlignments();
        List<DownsampledInterval> downsampledIntervals = t2.getDownsampledIntervals();
        return new AlignmentInterval(chr, start, end, alignments, t2.getCounts(), spliceJunctionHelper, downsampledIntervals);
    }

    public PackedAlignments getGroupedAlignmentsContaining(double position, ReferenceFrame referenceFrame) {
        String chr = referenceFrame.getChrName();
        int start = (int)position;
        int end = start + 1;
        PackedAlignments packedAlignments = this.packedAlignmentsCache.getForRange(referenceFrame.getCurrentRange());
        if (packedAlignments != null && packedAlignments.contains(chr, start, end)) {
            return packedAlignments;
        }
        return null;
    }

    public int getNLevels() {
        int nLevels = 0;
        for (PackedAlignments packedAlignments : this.packedAlignmentsCache.values()) {
            int intervalNLevels = packedAlignments.getNLevels();
            nLevels = Math.max(nLevels, intervalNLevels);
        }
        return nLevels;
    }

    public int getMaxGroupCount() {
        int groupCount = 0;
        for (PackedAlignments packedAlignments : this.packedAlignmentsCache.values()) {
            groupCount = Math.max(groupCount, packedAlignments.size());
        }
        return groupCount;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException ex) {
                log.error("Error closing AlignmentQueryReader. ", ex);
            }
        }
    }

    public void updatePEStats(AlignmentTrack.RenderOptions renderOptions) {
        if (this.peStats != null) {
            for (PEStats stats : this.peStats.values()) {
                stats.compute(renderOptions.getMinInsertSizePercentile(), renderOptions.getMaxInsertSizePercentile());
            }
        }
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    @Override
    public SpliceJunctionHelper.LoadOptions getSpliceJunctionLoadOptions() {
        return this.loadOptions;
    }

    @Override
    public void setMinJunctionCoverage(int minJunctionCoverage) {
        this.loadOptions = new SpliceJunctionHelper.LoadOptions(minJunctionCoverage, this.loadOptions.minReadFlankingWidth);
        for (AlignmentInterval interval : this.getLoadedIntervals()) {
            interval.getSpliceJunctionHelper().setLoadOptions(this.loadOptions);
        }
    }

    PositionCache getCache() {
        return this.loadedIntervalCache;
    }

    public void alleleThresholdChanged() {
        this.coverageTrack.setSnpThreshold(PreferenceManager.getInstance().getAsFloat("SAM.ALLELE_THRESHOLD"));
    }

    public static class DownsampleOptions {
        private boolean downsample;
        private int sampleWindowSize;
        private int maxReadCount;

        public DownsampleOptions() {
            PreferenceManager prefs = PreferenceManager.getInstance();
            this.init(prefs.getAsBoolean("SAM.DOWNSAMPLE_READS"), prefs.getAsInt("SAM.SAMPLING_WINDOW"), prefs.getAsInt("SAM.MAX_LEVELS"));
        }

        DownsampleOptions(boolean downsample, int sampleWindowSize, int maxReadCount) {
            this.init(downsample, sampleWindowSize, maxReadCount);
        }

        private void init(boolean downsample, int sampleWindowSize, int maxReadCount) {
            this.downsample = downsample;
            this.sampleWindowSize = sampleWindowSize;
            this.maxReadCount = maxReadCount;
        }

        public boolean isDownsample() {
            return this.downsample;
        }

        public int getSampleWindowSize() {
            return this.sampleWindowSize;
        }

        public int getMaxReadCount() {
            return this.maxReadCount;
        }
    }
}

