/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.maf;

import htsjdk.tribble.readers.AsciiLineReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broad.igv.Globals;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.index.Interval;
import org.broad.igv.util.index.IntervalTree;

public class MAFIndex {
    private List<String> species;
    private Map<String, IntervalTree> intervalTrees = new HashMap<String, IntervalTree>();
    public static int blockSize = 50;

    public List<String> getSpecies() {
        return this.species;
    }

    public void setSpecies(List<String> species) {
        this.species = species;
    }

    public String getRefId() {
        return this.species == null || this.species.isEmpty() ? null : this.species.get(0);
    }

    public Collection<String> getChromosomes() {
        return this.intervalTrees.keySet();
    }

    public IntervalTree getIntervalTree(String chr) {
        IntervalTree iv = this.intervalTrees.get(chr);
        if (iv == null) {
            iv = this.intervalTrees.get("*");
        }
        return iv;
    }

    public void putIntervalTree(String s2, IntervalTree iv) {
        this.intervalTrees.put(s2, iv);
    }

    public void insertInterval(String lastChr, int intervalStart, int intervalEnd, long value) {
        IntervalTree iv = this.intervalTrees.get(lastChr);
        if (iv == null) {
            iv = new IntervalTree();
            this.intervalTrees.put(lastChr, iv);
        }
        iv.insert(new Interval(intervalStart, intervalEnd, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MAFIndex loadIndex(String idxFile) throws IOException {
        MAFIndex index = new MAFIndex();
        index.species = new ArrayList<String>();
        BufferedReader br = null;
        try {
            br = ParsingUtils.openBufferedReader(idxFile);
            String line = br.readLine();
            if (line.startsWith("#species")) {
                while ((line = br.readLine()) != null && !line.startsWith("#end")) {
                    index.species.add(line.trim());
                }
                IntervalTree iv = null;
                while ((line = br.readLine()) != null) {
                    if (line.trim().length() == 0) continue;
                    if (line.startsWith("#chr=")) {
                        String chr = ParsingUtils.EQ_PATTERN.split(line)[1];
                        iv = new IntervalTree();
                        index.putIntervalTree(chr, iv);
                        continue;
                    }
                    if (iv == null) continue;
                    String[] info = Globals.tabPattern.split(line);
                    int start = Integer.parseInt(info[0]);
                    int end = Integer.parseInt(info[1]) + start;
                    long offset = Long.parseLong(info[2]);
                    iv.insert(new Interval(start, end, offset));
                }
            } else {
                IntervalTree iv = new IntervalTree();
                int l2 = 0;
                int intervalStart = 0;
                int intervalEnd = 0;
                long lastOffset = 0L;
                while ((line = br.readLine()) != null) {
                    String[] info = Globals.tabPattern.split(line);
                    int start = Integer.parseInt(info[0]);
                    intervalEnd = Integer.parseInt(info[1]) + start;
                    if (l2 % 50 == 0) {
                        iv.insert(new Interval(intervalStart, intervalEnd, lastOffset));
                        intervalStart = intervalEnd;
                        lastOffset = Long.parseLong(info[2]);
                    }
                    ++l2;
                }
                if (intervalEnd > intervalStart) {
                    iv.insert(new Interval(intervalStart, intervalEnd, lastOffset));
                }
                index.putIntervalTree("*", iv);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MAFIndex createIndex(String alignmentFile) throws IOException {
        MAFIndex index = new MAFIndex();
        AsciiLineReader reader = ParsingUtils.openAsciiReader(new ResourceLocator(alignmentFile));
        try {
            String line;
            String lastChr = null;
            int intervalStart = 0;
            int intervalEnd = 0;
            int blockCount = 0;
            long lastOffset = 0L;
            boolean newBlock = false;
            HashSet<String> allSpecies = new HashSet<String>();
            ArrayList<String> blockSpecies = new ArrayList<String>();
            HashMap<String, RunningAverage> speciesRanks = new HashMap<String, RunningAverage>();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || line.trim().length() == 0) continue;
                if (line.startsWith("a ")) {
                    newBlock = true;
                    ++blockCount;
                    MAFIndex.mergeSpecies(blockSpecies, allSpecies, speciesRanks);
                    blockSpecies.clear();
                    continue;
                }
                if (line.startsWith("s ")) {
                    String src;
                    String[] tokens = Globals.whitespacePattern.split(line);
                    String species = src = tokens[1];
                    String chr = src;
                    if (src.contains(".")) {
                        String[] srcTokens = ParsingUtils.PERIOD_PATTERN.split(src);
                        species = srcTokens[0];
                        chr = srcTokens[1];
                    }
                    if (lastChr == null) {
                        lastChr = chr;
                    }
                    blockSpecies.add(species);
                    if (!newBlock) continue;
                    int start = Integer.parseInt(tokens[2]);
                    int end = Integer.parseInt(tokens[3]) + start;
                    if (!chr.equals(lastChr) && blockCount > 0 || blockCount > blockSize) {
                        index.insertInterval(lastChr, intervalStart, intervalEnd, lastOffset);
                        blockCount = 1;
                        lastOffset = reader.getPosition();
                        intervalStart = start;
                    }
                    lastChr = chr;
                    intervalEnd = end;
                    newBlock = false;
                    continue;
                }
                if (line.startsWith("i ") || !line.startsWith("q ")) continue;
            }
            if (blockCount > 0) {
                index.insertInterval(lastChr, intervalStart, intervalEnd, lastOffset);
            }
            MAFIndex.mergeSpecies(blockSpecies, allSpecies, speciesRanks);
            index.setSpecies(MAFIndex.sortSpecies(allSpecies, speciesRanks));
            MAFIndex mAFIndex = index;
            return mAFIndex;
        }
        finally {
            reader.close();
        }
    }

    private static void mergeSpecies(List<String> blockSpecies, Set<String> allSpecies, Map<String, RunningAverage> speciesRank) {
        allSpecies.addAll(blockSpecies);
        for (int i2 = 0; i2 < blockSpecies.size(); ++i2) {
            String sp = blockSpecies.get(i2);
            RunningAverage rank = speciesRank.get(sp);
            if (rank == null) {
                rank = new RunningAverage();
                speciesRank.put(sp, rank);
            }
            rank.addValue(i2);
            speciesRank.put(sp, rank);
        }
    }

    private static List<String> sortSpecies(Collection<String> allSpecies, final Map<String, RunningAverage> speciesRank) {
        ArrayList<String> speciesList = new ArrayList<String>(allSpecies);
        Collections.sort(speciesList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                double v2 = ((RunningAverage)speciesRank.get((Object)o1)).average - ((RunningAverage)speciesRank.get((Object)o2)).average;
                return v2 > 0.0 ? 1 : (v2 < 0.0 ? -1 : 0);
            }
        });
        return speciesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeIndex(MAFIndex index, String indexFileName) throws IOException {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(indexFileName)));
            pw.println("#species");
            List<String> species = index.species;
            for (String sp : species) {
                pw.println(sp);
            }
            pw.println("#endSpecies");
            Collection<String> chrList = index.getChromosomes();
            for (String chr : chrList) {
                pw.println("#chr=" + chr);
                IntervalTree tree = index.getIntervalTree(chr);
                List<Interval> intervals = tree.getIntervals();
                for (Interval node : intervals) {
                    pw.print(String.valueOf(node.getLow()));
                    pw.print("\t");
                    pw.print(String.valueOf(node.getHigh() - node.getLow()));
                    pw.print("\t");
                    pw.println(String.valueOf(node.getValue()));
                }
            }
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    private static class RunningAverage {
        int nPts = 1;
        double average = 0.0;

        private RunningAverage() {
        }

        void addValue(double value) {
            this.average = ((double)this.nPts * this.average + value) / (double)this.nPts++;
        }
    }
}

