/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cursor;

import java.util.ArrayList;
import java.util.List;
import org.broad.igv.cursor.CursorModel;
import org.broad.igv.cursor.CursorRegion;
import org.broad.igv.cursor.CursorTrack;
import org.broad.igv.feature.BasicFeature;

public class RegionFilter {
    Pred pred;
    List<Clause> clauses;

    public List<Clause> getClauses() {
        return this.clauses;
    }

    public RegionFilter() {
        this(Pred.AND);
    }

    public RegionFilter(Pred pred) {
        this.pred = pred;
        this.clauses = new ArrayList<Clause>();
    }

    public boolean pass(CursorRegion region) {
        if (this.clauses.isEmpty()) {
            return true;
        }
        if (this.pred == Pred.AND) {
            for (Clause c2 : this.clauses) {
                if (c2.pass(region)) continue;
                return false;
            }
            return true;
        }
        for (Clause c3 : this.clauses) {
            if (!c3.pass(region)) continue;
            return true;
        }
        return false;
    }

    public static class Clause {
        Condition condition;
        double threshold;
        CursorTrack track;

        boolean pass(CursorRegion region) {
            List<BasicFeature> features = this.track.getFeatures(region.getChr());
            int lf = this.track.getLongestFeatureLength(region.getChr());
            double score = region.getScore(this.track, CursorModel.frameBPWidth);
            if (score < 0.0) {
                return false;
            }
            if (this.condition == Condition.GT) {
                return score > this.threshold;
            }
            if (this.condition == Condition.LT) {
                return score < this.threshold;
            }
            return true;
        }
    }

    public static enum Condition {
        exists,
        GT,
        LT;

    }

    public static enum Pred {
        AND,
        OR;

    }
}

