/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cli_plugin.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.broad.igv.PreferenceManager;
import org.broad.igv.cli_plugin.Argument;
import org.broad.igv.cli_plugin.PluginDataSource;
import org.broad.igv.cli_plugin.PluginFeatureSource;
import org.broad.igv.cli_plugin.PluginSpecReader;
import org.broad.igv.cli_plugin.ui.ArgumentPanel;
import org.broad.igv.cli_plugin.ui.TextArgument;
import org.broad.igv.feature.CachingFeatureSource;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.DataSourceTrack;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.BrowserLauncher;
import org.broad.igv.util.FileUtils;
import org.broad.igv.variant.VariantTrack;

public class RunPlugin
extends JDialog {
    private List<Argument> argumentList;
    private List<String> cmdList = new ArrayList<String>();
    private Map<Argument, ArgumentPanel> argumentComponents;
    private List<PluginSpecReader.Output> outputAttrs;
    private Map<PluginSpecReader.Output, ArgumentPanel> outputComponents;
    private String specPath;
    private String pluginId;
    private String toolName;
    private String commandName;
    private boolean forbidEmptyOutput;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JPanel vSpacer1;
    private JPanel buttonBar;
    private JButton helpButton;
    private JPanel hSpacer1;
    private JButton okButton;
    private JButton cancelButton;

    public RunPlugin(Frame owner, PluginSpecReader pluginSpecReader, final PluginSpecReader.Tool tool, PluginSpecReader.Command command) {
        super(owner);
        this.initComponents();
        this.specPath = pluginSpecReader.getSpecPath();
        this.argumentList = command.argumentList;
        this.outputAttrs = command.outputList;
        this.initArgumentComponents(pluginSpecReader, tool, command);
        if (tool.helpUrl != null) {
            this.helpButton.setEnabled(true);
            this.helpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    try {
                        BrowserLauncher.openURL(tool.helpUrl);
                    }
                    catch (IOException e1) {
                        MessageUtils.showErrorMessage(e1.getMessage(), e1);
                    }
                }
            });
        }
    }

    private void initArgumentComponents(PluginSpecReader pluginSpecReader, PluginSpecReader.Tool tool, PluginSpecReader.Command command) {
        ArgumentPanel panel;
        String toolPath = pluginSpecReader.getToolPath(tool);
        this.pluginId = pluginSpecReader.getId();
        this.toolName = tool.name;
        this.forbidEmptyOutput = tool.forbidEmptyOutput;
        this.commandName = command.name;
        String[] cmdEls = new String[]{toolPath, command.cmd};
        if (tool.msgList != null && tool.msgList.size() > 0) {
            this.cmdList.addAll(tool.msgList);
        }
        for (String cmdEl : cmdEls) {
            if (cmdEl == null || cmdEl.length() <= 0) continue;
            this.cmdList.add(cmdEl);
        }
        this.argumentComponents = new LinkedHashMap<Argument, ArgumentPanel>(this.argumentList.size());
        this.outputComponents = new LinkedHashMap<PluginSpecReader.Output, ArgumentPanel>(this.outputAttrs.size());
        String titleText = tool.name;
        if (this.commandName.length() > 0) {
            titleText = titleText + ": " + this.commandName;
        }
        this.setTitle(titleText);
        Dimension minSize = this.getMinimumSize();
        for (Argument argument : this.argumentList) {
            if (argument.getType() == Argument.InputType.TEXT || argument.getType() == Argument.InputType.LONGTEXT) {
                String defValue = argument.getDefaultValue();
                if (argument.isRemembered()) {
                    String lastValue = PreferenceManager.getInstance().getArgumentValue(this.pluginId, this.toolName, this.commandName, argument.getId());
                    String string = defValue = lastValue != null ? lastValue : defValue;
                }
                if (defValue != null && defValue.contains(Argument.TOOL_DIR_KEY)) {
                    String toolDir = FileUtils.getParent(toolPath);
                    defValue = defValue.replace(Argument.TOOL_DIR_KEY, toolDir);
                }
                argument.setDefaultValue(defValue);
            }
            if ((panel = ArgumentPanel.create(argument)) == null) continue;
            this.argumentComponents.put(argument, panel);
            if (!argument.isVisible()) continue;
            this.contentPanel.add(panel);
        }
        for (PluginSpecReader.Output output : this.outputAttrs) {
            panel = new TextArgument();
            panel.setArgName(output.name);
            String defValue = output.defaultValue != null ? output.defaultValue : tool.name + " " + this.commandName;
            ((TextArgument)panel).setValue(defValue);
            this.contentPanel.add(panel);
            this.outputComponents.put(output, panel);
        }
        this.validate();
        ArrayList<ArgumentPanel> components = new ArrayList<ArgumentPanel>(this.argumentComponents.values());
        components.addAll(this.outputComponents.values());
        double minWidth = minSize.getWidth();
        for (ArgumentPanel panel2 : components) {
            minWidth = Math.max(minWidth, panel2.getMinimumSize().getWidth());
            minSize.setSize(minWidth, minSize.getHeight() + (double)panel2.getHeight());
            this.setMinimumSize(minSize);
        }
        this.validate();
    }

    LinkedHashMap<Argument, Object> getArgumentValues() {
        LinkedHashMap<Argument, Object> argumentValues = new LinkedHashMap<Argument, Object>(this.argumentComponents.size());
        for (Map.Entry<Argument, ArgumentPanel> argComp : this.argumentComponents.entrySet()) {
            Object value = argComp.getValue().getValue();
            argumentValues.put(argComp.getKey(), value);
            if (!(value instanceof String) || !argComp.getKey().isRemembered()) continue;
            PreferenceManager.getInstance().putArgumentValue(this.pluginId, this.toolName, this.commandName, argComp.getKey().getId(), (String)value);
        }
        return argumentValues;
    }

    private List<Track> genNewTracks() {
        LinkedHashMap<Argument, Object> argumentValues = this.getArgumentValues();
        ArrayList<Track> newTracks = new ArrayList<Track>(this.outputAttrs.size());
        for (PluginSpecReader.Output outputAttr : this.outputAttrs) {
            String name = (String)this.outputComponents.get(outputAttr).getValue();
            AbstractTrack newTrack = null;
            switch (outputAttr.type) {
                case FEATURE_TRACK: {
                    PluginFeatureSource featSource1 = new PluginFeatureSource(this.cmdList, argumentValues, outputAttr, this.specPath, this.forbidEmptyOutput);
                    CachingFeatureSource featSource = new CachingFeatureSource(featSource1);
                    newTrack = new FeatureTrack(UUID.randomUUID().toString(), name, (FeatureSource)featSource);
                    break;
                }
                case DATA_SOURCE_TRACK: {
                    PluginDataSource dataSource = new PluginDataSource(GenomeManager.getInstance().getCurrentGenome(), this.cmdList, argumentValues, outputAttr, this.specPath);
                    newTrack = new DataSourceTrack(null, UUID.randomUUID().toString(), name, dataSource);
                    break;
                }
                case VARIANT_TRACK: {
                    PluginFeatureSource VfeatSource1 = new PluginFeatureSource(this.cmdList, argumentValues, outputAttr, this.specPath, this.forbidEmptyOutput);
                    CachingFeatureSource VfeatSource = new CachingFeatureSource(VfeatSource1);
                    newTrack = new VariantTrack(name, (FeatureSource)VfeatSource);
                }
            }
            newTracks.add(newTrack);
        }
        return newTracks;
    }

    private void cancelButtonActionPerformed(ActionEvent e2) {
        this.setVisible(false);
    }

    void okButtonActionPerformed(ActionEvent e2) {
        List<Track> newTrack = this.genNewTracks();
        IGV.getInstance().getTrackPanel("FeaturePanel").addTracks(newTrack);
        this.setVisible(false);
        IGV.getInstance().repaint();
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.vSpacer1 = new JPanel(null);
        this.buttonBar = new JPanel();
        this.helpButton = new JButton();
        this.hSpacer1 = new JPanel(null);
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setPreferredSize(new Dimension(300, 100));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setMaximumSize(new Dimension(2000000, 16));
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.dialogPane.add((Component)this.contentPanel, "North");
        this.dialogPane.add((Component)this.vSpacer1, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{0.0, 1.0, 0.0, 0.0};
        this.helpButton.setText("Help");
        this.helpButton.setEnabled(false);
        this.buttonBar.add((Component)this.helpButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.buttonBar.add((Component)this.hSpacer1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                RunPlugin.this.okButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                RunPlugin.this.cancelButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

