/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.commons.math.Field;
import org.apache.commons.math.FieldElement;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.fraction.BigFraction;
import org.apache.commons.math.fraction.Fraction;
import org.apache.commons.math.linear.AnyMatrix;
import org.apache.commons.math.linear.Array2DRowFieldMatrix;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.ArrayFieldVector;
import org.apache.commons.math.linear.ArrayRealVector;
import org.apache.commons.math.linear.BigMatrix;
import org.apache.commons.math.linear.BigMatrixImpl;
import org.apache.commons.math.linear.BlockFieldMatrix;
import org.apache.commons.math.linear.BlockRealMatrix;
import org.apache.commons.math.linear.DefaultFieldMatrixPreservingVisitor;
import org.apache.commons.math.linear.FieldMatrix;
import org.apache.commons.math.linear.FieldVector;
import org.apache.commons.math.linear.MatrixIndexException;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixUtils {
    private MatrixUtils() {
    }

    public static RealMatrix createRealMatrix(int rows, int columns) {
        return rows * columns <= 4096 ? new Array2DRowRealMatrix(rows, columns) : new BlockRealMatrix(rows, columns);
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createFieldMatrix(Field<T> field, int rows, int columns) {
        return rows * columns <= 4096 ? new Array2DRowFieldMatrix<T>(field, rows, columns) : new BlockFieldMatrix<T>(field, rows, columns);
    }

    public static RealMatrix createRealMatrix(double[][] data) {
        return data.length * data[0].length <= 4096 ? new Array2DRowRealMatrix(data) : new BlockRealMatrix(data);
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createFieldMatrix(T[][] data) {
        return data.length * data[0].length <= 4096 ? new Array2DRowFieldMatrix(data) : new BlockFieldMatrix(data);
    }

    public static RealMatrix createRealIdentityMatrix(int dimension) {
        RealMatrix m2 = MatrixUtils.createRealMatrix(dimension, dimension);
        for (int i2 = 0; i2 < dimension; ++i2) {
            m2.setEntry(i2, i2, 1.0);
        }
        return m2;
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createFieldIdentityMatrix(Field<T> field, int dimension) {
        FieldElement zero = (FieldElement)field.getZero();
        FieldElement one = (FieldElement)field.getOne();
        FieldElement[][] d2 = (FieldElement[][])Array.newInstance(zero.getClass(), dimension, dimension);
        for (int row = 0; row < dimension; ++row) {
            Object[] dRow = d2[row];
            Arrays.fill(dRow, zero);
            dRow[row] = one;
        }
        return new Array2DRowFieldMatrix(d2, false);
    }

    @Deprecated
    public static BigMatrix createBigIdentityMatrix(int dimension) {
        BigDecimal[][] d2 = new BigDecimal[dimension][dimension];
        for (int row = 0; row < dimension; ++row) {
            Object[] dRow = d2[row];
            Arrays.fill(dRow, BigMatrixImpl.ZERO);
            dRow[row] = BigMatrixImpl.ONE;
        }
        return new BigMatrixImpl(d2, false);
    }

    public static RealMatrix createRealDiagonalMatrix(double[] diagonal) {
        RealMatrix m2 = MatrixUtils.createRealMatrix(diagonal.length, diagonal.length);
        for (int i2 = 0; i2 < diagonal.length; ++i2) {
            m2.setEntry(i2, i2, diagonal[i2]);
        }
        return m2;
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createFieldDiagonalMatrix(T[] diagonal) {
        FieldMatrix<T> m2 = MatrixUtils.createFieldMatrix(diagonal[0].getField(), diagonal.length, diagonal.length);
        for (int i2 = 0; i2 < diagonal.length; ++i2) {
            m2.setEntry(i2, i2, diagonal[i2]);
        }
        return m2;
    }

    @Deprecated
    public static BigMatrix createBigMatrix(double[][] data) {
        return new BigMatrixImpl(data);
    }

    @Deprecated
    public static BigMatrix createBigMatrix(BigDecimal[][] data) {
        return new BigMatrixImpl(data);
    }

    @Deprecated
    public static BigMatrix createBigMatrix(BigDecimal[][] data, boolean copyArray) {
        return new BigMatrixImpl(data, copyArray);
    }

    @Deprecated
    public static BigMatrix createBigMatrix(String[][] data) {
        return new BigMatrixImpl(data);
    }

    public static RealVector createRealVector(double[] data) {
        return new ArrayRealVector(data, true);
    }

    public static <T extends FieldElement<T>> FieldVector<T> createFieldVector(T[] data) {
        return new ArrayFieldVector(data, true);
    }

    public static RealMatrix createRowRealMatrix(double[] rowData) {
        int nCols = rowData.length;
        RealMatrix m2 = MatrixUtils.createRealMatrix(1, nCols);
        for (int i2 = 0; i2 < nCols; ++i2) {
            m2.setEntry(0, i2, rowData[i2]);
        }
        return m2;
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createRowFieldMatrix(T[] rowData) {
        int nCols = rowData.length;
        if (nCols == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_COLUMN, new Object[0]);
        }
        FieldMatrix<T> m2 = MatrixUtils.createFieldMatrix(rowData[0].getField(), 1, nCols);
        for (int i2 = 0; i2 < nCols; ++i2) {
            m2.setEntry(0, i2, rowData[i2]);
        }
        return m2;
    }

    @Deprecated
    public static BigMatrix createRowBigMatrix(double[] rowData) {
        int nCols = rowData.length;
        BigDecimal[][] data = new BigDecimal[1][nCols];
        for (int i2 = 0; i2 < nCols; ++i2) {
            data[0][i2] = new BigDecimal(rowData[i2]);
        }
        return new BigMatrixImpl(data, false);
    }

    @Deprecated
    public static BigMatrix createRowBigMatrix(BigDecimal[] rowData) {
        int nCols = rowData.length;
        BigDecimal[][] data = new BigDecimal[1][nCols];
        System.arraycopy(rowData, 0, data[0], 0, nCols);
        return new BigMatrixImpl(data, false);
    }

    @Deprecated
    public static BigMatrix createRowBigMatrix(String[] rowData) {
        int nCols = rowData.length;
        BigDecimal[][] data = new BigDecimal[1][nCols];
        for (int i2 = 0; i2 < nCols; ++i2) {
            data[0][i2] = new BigDecimal(rowData[i2]);
        }
        return new BigMatrixImpl(data, false);
    }

    public static RealMatrix createColumnRealMatrix(double[] columnData) {
        int nRows = columnData.length;
        RealMatrix m2 = MatrixUtils.createRealMatrix(nRows, 1);
        for (int i2 = 0; i2 < nRows; ++i2) {
            m2.setEntry(i2, 0, columnData[i2]);
        }
        return m2;
    }

    public static <T extends FieldElement<T>> FieldMatrix<T> createColumnFieldMatrix(T[] columnData) {
        int nRows = columnData.length;
        if (nRows == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_ROW, new Object[0]);
        }
        FieldMatrix<T> m2 = MatrixUtils.createFieldMatrix(columnData[0].getField(), nRows, 1);
        for (int i2 = 0; i2 < nRows; ++i2) {
            m2.setEntry(i2, 0, columnData[i2]);
        }
        return m2;
    }

    @Deprecated
    public static BigMatrix createColumnBigMatrix(double[] columnData) {
        int nRows = columnData.length;
        BigDecimal[][] data = new BigDecimal[nRows][1];
        for (int row = 0; row < nRows; ++row) {
            data[row][0] = new BigDecimal(columnData[row]);
        }
        return new BigMatrixImpl(data, false);
    }

    @Deprecated
    public static BigMatrix createColumnBigMatrix(BigDecimal[] columnData) {
        int nRows = columnData.length;
        BigDecimal[][] data = new BigDecimal[nRows][1];
        for (int row = 0; row < nRows; ++row) {
            data[row][0] = columnData[row];
        }
        return new BigMatrixImpl(data, false);
    }

    @Deprecated
    public static BigMatrix createColumnBigMatrix(String[] columnData) {
        int nRows = columnData.length;
        BigDecimal[][] data = new BigDecimal[nRows][1];
        for (int row = 0; row < nRows; ++row) {
            data[row][0] = new BigDecimal(columnData[row]);
        }
        return new BigMatrixImpl(data, false);
    }

    public static void checkRowIndex(AnyMatrix m2, int row) {
        if (row < 0 || row >= m2.getRowDimension()) {
            throw new MatrixIndexException(LocalizedFormats.ROW_INDEX_OUT_OF_RANGE, row, 0, m2.getRowDimension() - 1);
        }
    }

    public static void checkColumnIndex(AnyMatrix m2, int column) throws MatrixIndexException {
        if (column < 0 || column >= m2.getColumnDimension()) {
            throw new MatrixIndexException(LocalizedFormats.COLUMN_INDEX_OUT_OF_RANGE, column, 0, m2.getColumnDimension() - 1);
        }
    }

    public static void checkSubMatrixIndex(AnyMatrix m2, int startRow, int endRow, int startColumn, int endColumn) {
        MatrixUtils.checkRowIndex(m2, startRow);
        MatrixUtils.checkRowIndex(m2, endRow);
        if (startRow > endRow) {
            throw new MatrixIndexException(LocalizedFormats.INITIAL_ROW_AFTER_FINAL_ROW, startRow, endRow);
        }
        MatrixUtils.checkColumnIndex(m2, startColumn);
        MatrixUtils.checkColumnIndex(m2, endColumn);
        if (startColumn > endColumn) {
            throw new MatrixIndexException(LocalizedFormats.INITIAL_COLUMN_AFTER_FINAL_COLUMN, startColumn, endColumn);
        }
    }

    public static void checkSubMatrixIndex(AnyMatrix m2, int[] selectedRows, int[] selectedColumns) throws MatrixIndexException {
        if (selectedRows.length * selectedColumns.length == 0) {
            if (selectedRows.length == 0) {
                throw new MatrixIndexException(LocalizedFormats.EMPTY_SELECTED_ROW_INDEX_ARRAY, new Object[0]);
            }
            throw new MatrixIndexException(LocalizedFormats.EMPTY_SELECTED_COLUMN_INDEX_ARRAY, new Object[0]);
        }
        for (int row : selectedRows) {
            MatrixUtils.checkRowIndex(m2, row);
        }
        for (int column : selectedColumns) {
            MatrixUtils.checkColumnIndex(m2, column);
        }
    }

    public static void checkAdditionCompatible(AnyMatrix left, AnyMatrix right) throws IllegalArgumentException {
        if (left.getRowDimension() != right.getRowDimension() || left.getColumnDimension() != right.getColumnDimension()) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_ADDITION_COMPATIBLE_MATRICES, left.getRowDimension(), left.getColumnDimension(), right.getRowDimension(), right.getColumnDimension());
        }
    }

    public static void checkSubtractionCompatible(AnyMatrix left, AnyMatrix right) throws IllegalArgumentException {
        if (left.getRowDimension() != right.getRowDimension() || left.getColumnDimension() != right.getColumnDimension()) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_SUBTRACTION_COMPATIBLE_MATRICES, left.getRowDimension(), left.getColumnDimension(), right.getRowDimension(), right.getColumnDimension());
        }
    }

    public static void checkMultiplicationCompatible(AnyMatrix left, AnyMatrix right) throws IllegalArgumentException {
        if (left.getColumnDimension() != right.getRowDimension()) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_MULTIPLICATION_COMPATIBLE_MATRICES, left.getRowDimension(), left.getColumnDimension(), right.getRowDimension(), right.getColumnDimension());
        }
    }

    public static Array2DRowRealMatrix fractionMatrixToRealMatrix(FieldMatrix<Fraction> m2) {
        FractionMatrixConverter converter = new FractionMatrixConverter();
        m2.walkInOptimizedOrder(converter);
        return converter.getConvertedMatrix();
    }

    public static Array2DRowRealMatrix bigFractionMatrixToRealMatrix(FieldMatrix<BigFraction> m2) {
        BigFractionMatrixConverter converter = new BigFractionMatrixConverter();
        m2.walkInOptimizedOrder(converter);
        return converter.getConvertedMatrix();
    }

    public static void serializeRealVector(RealVector vector, ObjectOutputStream oos) throws IOException {
        int n2 = vector.getDimension();
        oos.writeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            oos.writeDouble(vector.getEntry(i2));
        }
    }

    public static void deserializeRealVector(Object instance, String fieldName, ObjectInputStream ois) throws ClassNotFoundException, IOException {
        try {
            int n2 = ois.readInt();
            double[] data = new double[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                data[i2] = ois.readDouble();
            }
            ArrayRealVector vector = new ArrayRealVector(data, false);
            java.lang.reflect.Field f2 = instance.getClass().getDeclaredField(fieldName);
            f2.setAccessible(true);
            f2.set(instance, vector);
        }
        catch (NoSuchFieldException nsfe) {
            IOException ioe = new IOException();
            ioe.initCause(nsfe);
            throw ioe;
        }
        catch (IllegalAccessException iae) {
            IOException ioe = new IOException();
            ioe.initCause(iae);
            throw ioe;
        }
    }

    public static void serializeRealMatrix(RealMatrix matrix, ObjectOutputStream oos) throws IOException {
        int n2 = matrix.getRowDimension();
        int m2 = matrix.getColumnDimension();
        oos.writeInt(n2);
        oos.writeInt(m2);
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int j2 = 0; j2 < m2; ++j2) {
                oos.writeDouble(matrix.getEntry(i2, j2));
            }
        }
    }

    public static void deserializeRealMatrix(Object instance, String fieldName, ObjectInputStream ois) throws ClassNotFoundException, IOException {
        try {
            int n2 = ois.readInt();
            int m2 = ois.readInt();
            double[][] data = new double[n2][m2];
            for (int i2 = 0; i2 < n2; ++i2) {
                double[] dataI = data[i2];
                for (int j2 = 0; j2 < m2; ++j2) {
                    dataI[j2] = ois.readDouble();
                }
            }
            Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(data, false);
            java.lang.reflect.Field f2 = instance.getClass().getDeclaredField(fieldName);
            f2.setAccessible(true);
            f2.set(instance, matrix);
        }
        catch (NoSuchFieldException nsfe) {
            IOException ioe = new IOException();
            ioe.initCause(nsfe);
            throw ioe;
        }
        catch (IllegalAccessException iae) {
            IOException ioe = new IOException();
            ioe.initCause(iae);
            throw ioe;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BigFractionMatrixConverter
    extends DefaultFieldMatrixPreservingVisitor<BigFraction> {
        private double[][] data;

        public BigFractionMatrixConverter() {
            super(BigFraction.ZERO);
        }

        @Override
        public void start(int rows, int columns, int startRow, int endRow, int startColumn, int endColumn) {
            this.data = new double[rows][columns];
        }

        @Override
        public void visit(int row, int column, BigFraction value) {
            this.data[row][column] = value.doubleValue();
        }

        Array2DRowRealMatrix getConvertedMatrix() {
            return new Array2DRowRealMatrix(this.data, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FractionMatrixConverter
    extends DefaultFieldMatrixPreservingVisitor<Fraction> {
        private double[][] data;

        public FractionMatrixConverter() {
            super(Fraction.ZERO);
        }

        @Override
        public void start(int rows, int columns, int startRow, int endRow, int startColumn, int endColumn) {
            this.data = new double[rows][columns];
        }

        @Override
        public void visit(int row, int column, Fraction value) {
            this.data[row][column] = value.doubleValue();
        }

        Array2DRowRealMatrix getConvertedMatrix() {
            return new Array2DRowRealMatrix(this.data, false);
        }
    }
}

