/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CommonInfo
implements Serializable {
    public static final long serialVersionUID = 1L;
    public static final double NO_LOG10_PERROR = 1.0;
    private static Set<String> NO_FILTERS = Collections.emptySet();
    private static Map<String, Object> NO_ATTRIBUTES = Collections.unmodifiableMap(new HashMap());
    private double log10PError = 1.0;
    private String name = null;
    private Set<String> filters = null;
    private Map<String, Object> attributes = NO_ATTRIBUTES;

    public CommonInfo(String name, double log10PError, Set<String> filters, Map<String, Object> attributes) {
        this.name = name;
        this.setLog10PError(log10PError);
        this.filters = filters;
        if (attributes != null && !attributes.isEmpty()) {
            this.attributes = attributes;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null " + this);
        }
        this.name = name;
    }

    public Set<String> getFiltersMaybeNull() {
        return this.filters;
    }

    public Set<String> getFilters() {
        return this.filters == null ? NO_FILTERS : Collections.unmodifiableSet(this.filters);
    }

    public boolean filtersWereApplied() {
        return this.filters != null;
    }

    public boolean isFiltered() {
        return this.filters == null ? false : this.filters.size() > 0;
    }

    public boolean isNotFiltered() {
        return !this.isFiltered();
    }

    public void addFilter(String filter) {
        if (this.filters == null) {
            this.filters = new HashSet<String>();
        }
        if (filter == null) {
            throw new IllegalArgumentException("BUG: Attempting to add null filter " + this);
        }
        if (this.getFilters().contains(filter)) {
            throw new IllegalArgumentException("BUG: Attempting to add duplicate filter " + filter + " at " + this);
        }
        this.filters.add(filter);
    }

    public void addFilters(Collection<String> filters) {
        if (filters == null) {
            throw new IllegalArgumentException("BUG: Attempting to add null filters at" + this);
        }
        for (String f2 : filters) {
            this.addFilter(f2);
        }
    }

    public boolean hasLog10PError() {
        return this.getLog10PError() != 1.0;
    }

    public double getLog10PError() {
        return this.log10PError;
    }

    public double getPhredScaledQual() {
        return this.getLog10PError() * -10.0 + 0.0;
    }

    public void setLog10PError(double log10PError) {
        if (log10PError > 0.0 && log10PError != 1.0) {
            throw new IllegalArgumentException("BUG: log10PError cannot be > 0 : " + this.log10PError);
        }
        if (Double.isInfinite(this.log10PError)) {
            throw new IllegalArgumentException("BUG: log10PError should not be Infinity");
        }
        if (Double.isNaN(this.log10PError)) {
            throw new IllegalArgumentException("BUG: log10PError should not be NaN");
        }
        this.log10PError = log10PError;
    }

    public void clearAttributes() {
        this.attributes = new HashMap<String, Object>();
    }

    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public void setAttributes(Map<String, ?> map) {
        this.clearAttributes();
        this.putAttributes(map);
    }

    public void putAttribute(String key, Object value) {
        this.putAttribute(key, value, false);
    }

    public void putAttribute(String key, Object value, boolean allowOverwrites) {
        if (!allowOverwrites && this.hasAttribute(key)) {
            throw new IllegalStateException("Attempting to overwrite key->value binding: key = " + key + " this = " + this);
        }
        if (this.attributes == NO_ATTRIBUTES) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, value);
    }

    public void removeAttribute(String key) {
        if (this.attributes == NO_ATTRIBUTES) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.remove(key);
    }

    public void putAttributes(Map<String, ?> map) {
        if (map != null) {
            if (this.attributes.size() == 0) {
                if (this.attributes == NO_ATTRIBUTES) {
                    this.attributes = new HashMap<String, Object>();
                }
                this.attributes.putAll(map);
            } else {
                for (Map.Entry<String, ?> elt : map.entrySet()) {
                    this.putAttribute(elt.getKey(), elt.getValue(), false);
                }
            }
        }
    }

    public boolean hasAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    public int getNumAttributes() {
        return this.attributes.size();
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Object getAttribute(String key, Object defaultValue) {
        if (this.hasAttribute(key)) {
            return this.attributes.get(key);
        }
        return defaultValue;
    }

    public List<Object> getAttributeAsList(String key) {
        Object o2 = this.getAttribute(key);
        if (o2 == null) {
            return Collections.emptyList();
        }
        if (o2 instanceof List) {
            return (List)o2;
        }
        if (o2.getClass().isArray()) {
            return Arrays.asList((Object[])o2);
        }
        return Collections.singletonList(o2);
    }

    public String getAttributeAsString(String key, String defaultValue) {
        Object x2 = this.getAttribute(key);
        if (x2 == null) {
            return defaultValue;
        }
        if (x2 instanceof String) {
            return (String)x2;
        }
        return String.valueOf(x2);
    }

    public int getAttributeAsInt(String key, int defaultValue) {
        Object x2 = this.getAttribute(key);
        if (x2 == null || x2 == ".") {
            return defaultValue;
        }
        if (x2 instanceof Integer) {
            return (Integer)x2;
        }
        return Integer.valueOf((String)x2);
    }

    public double getAttributeAsDouble(String key, double defaultValue) {
        Object x2 = this.getAttribute(key);
        if (x2 == null) {
            return defaultValue;
        }
        if (x2 instanceof Double) {
            return (Double)x2;
        }
        if (x2 instanceof Integer) {
            return ((Integer)x2).intValue();
        }
        return Double.valueOf((String)x2);
    }

    public boolean getAttributeAsBoolean(String key, boolean defaultValue) {
        Object x2 = this.getAttribute(key);
        if (x2 == null) {
            return defaultValue;
        }
        if (x2 instanceof Boolean) {
            return (Boolean)x2;
        }
        return Boolean.valueOf((String)x2);
    }
}

