/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.structure.Block;
import htsjdk.samtools.cram.structure.BlockCompressionMethod;
import htsjdk.samtools.cram.structure.BlockContentType;
import htsjdk.samtools.cram.structure.CompressionHeader;
import java.io.IOException;
import java.io.InputStream;

public class CompressionHeaderBLock
extends Block {
    private CompressionHeader compressionHeader;

    public CompressionHeader getCompressionHeader() {
        return this.compressionHeader;
    }

    public CompressionHeaderBLock(CompressionHeader header) {
        byte[] bytes;
        this.compressionHeader = header;
        this.contentType = BlockContentType.COMPRESSION_HEADER;
        this.contentId = 0;
        this.method = BlockCompressionMethod.RAW;
        try {
            bytes = header.toByteArray();
        }
        catch (IOException e2) {
            throw new RuntimeException("This should have never happend.");
        }
        this.setRawContent(bytes);
    }

    public CompressionHeaderBLock(InputStream is) throws IOException {
        super(is, true, true);
        if (this.contentType != BlockContentType.COMPRESSION_HEADER) {
            throw new RuntimeException("Content type does not match: " + this.contentType.name());
        }
        this.compressionHeader = new CompressionHeader();
        this.compressionHeader.read(this.getRawContent());
    }
}

