/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.mask;

import htsjdk.samtools.cram.mask.ArrayPositionMask;
import htsjdk.samtools.cram.mask.PositionMask;
import htsjdk.samtools.cram.mask.ReadMaskFactory;
import htsjdk.samtools.cram.mask.ReadMaskFormatException;
import java.nio.IntBuffer;

public class IntegerListMaskFactory
implements ReadMaskFactory<String> {
    public static final String DEFAULT_DEMLIITER = " ";
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    private String delimiter;
    private IntBuffer buf;

    public IntegerListMaskFactory(String delimiter, int bufSize) {
        if (delimiter == null) {
            throw new NullPointerException("Delimiter is null.");
        }
        if (bufSize < 1) {
            throw new IllegalAccessError("Buffer size must be greater then 0.");
        }
        this.delimiter = delimiter;
        this.buf = IntBuffer.allocate(bufSize);
    }

    public IntegerListMaskFactory(String delimiter) {
        this(delimiter, 1024);
    }

    public IntegerListMaskFactory() {
        this(DEFAULT_DEMLIITER, 1024);
    }

    @Override
    public PositionMask createMask(String line) throws ReadMaskFormatException {
        if (line.length() == 0) {
            return ArrayPositionMask.EMPTY_INSTANCE;
        }
        this.buf.clear();
        try {
            for (String chunk : line.split(this.delimiter)) {
                this.buf.put(Integer.valueOf(chunk));
            }
        }
        catch (NumberFormatException e2) {
            throw new ReadMaskFormatException("Expecting integers in " + line.substring(0, Math.min(10, line.length())), e2);
        }
        this.buf.flip();
        int[] array = new int[this.buf.limit()];
        this.buf.get(array);
        ArrayPositionMask mask = new ArrayPositionMask(array);
        return mask;
    }
}

