/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;

public class CRC32OutputStream
extends FilterOutputStream {
    private final CRC32 crc32 = new CRC32();

    public CRC32OutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(byte[] b2, int off, int length) throws IOException {
        this.crc32.update(b2, off, length);
        this.out.write(b2, off, length);
    }

    @Override
    public void write(int b2) throws IOException {
        this.crc32.update(b2);
        this.out.write(b2);
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.crc32.update(b2);
        this.out.write(b2);
    }

    public long getLongCrc32() {
        return this.crc32.getValue();
    }

    public byte[] getCrc32_BigEndian() {
        long value = this.crc32.getValue();
        return new byte[]{(byte)(0xFFL & value >> 24), (byte)(0xFFL & value >> 16), (byte)(0xFFL & value >> 8), (byte)(0xFFL & value)};
    }

    public byte[] getCrc32_LittleEndian() {
        long value = this.crc32.getValue();
        return new byte[]{(byte)(0xFFL & value), (byte)(0xFFL & value >> 8), (byte)(0xFFL & value >> 16), (byte)(0xFFL & value >> 24)};
    }
}

