/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import sun.misc.CRC16;

public class ByteBufferUtils {
    private static ExposedByteArrayOutputStream ltf8TestBAOS = new ExposedByteArrayOutputStream();
    private static ByteArrayInputStream ltf8TestBAIS = new ByteArrayInputStream(ltf8TestBAOS.getBuffer());
    public static int GZIP_COMPRESSION_LEVEL = Integer.valueOf(System.getProperty("gzip.compression.level", "5"));
    private static BigInteger HASH = new BigInteger("811c9dc5", 16);
    private static final BigInteger PRIME32 = new BigInteger("01000193", 16);
    private static final BigInteger MOD32 = new BigInteger("2").pow(32);
    private static long prime32 = PRIME32.longValue();
    private static long mod32 = MOD32.longValue();

    public static final int readUnsignedITF8(InputStream is) throws IOException {
        int b1 = is.read();
        if (b1 == -1) {
            throw new EOFException();
        }
        if ((b1 & 0x80) == 0) {
            return b1;
        }
        if ((b1 & 0x40) == 0) {
            return (b1 & 0x7F) << 8 | is.read();
        }
        if ((b1 & 0x20) == 0) {
            int b2 = is.read();
            int b3 = is.read();
            return (b1 & 0x3F) << 16 | b2 << 8 | b3;
        }
        if ((b1 & 0x10) == 0) {
            return (b1 & 0x1F) << 24 | is.read() << 16 | is.read() << 8 | is.read();
        }
        return (b1 & 0xF) << 28 | is.read() << 20 | is.read() << 12 | is.read() << 4 | 0xF & is.read();
    }

    public static final int writeUnsignedITF8(int value, OutputStream os) throws IOException {
        if (value >>> 7 == 0) {
            os.write(value);
            return 8;
        }
        if (value >>> 14 == 0) {
            os.write(value >> 8 | 0x80);
            os.write(value & 0xFF);
            return 16;
        }
        if (value >>> 21 == 0) {
            os.write(value >> 16 | 0xC0);
            os.write(value >> 8 & 0xFF);
            os.write(value & 0xFF);
            return 24;
        }
        if (value >>> 28 == 0) {
            os.write(value >> 24 | 0xE0);
            os.write(value >> 16 & 0xFF);
            os.write(value >> 8 & 0xFF);
            os.write(value & 0xFF);
            return 32;
        }
        os.write(value >> 28 | 0xF0);
        os.write(value >> 20 & 0xFF);
        os.write(value >> 12 & 0xFF);
        os.write(value >> 4 & 0xFF);
        os.write(value & 0xFF);
        return 40;
    }

    public static final long readUnsignedLTF8(InputStream is) throws IOException {
        int b1 = is.read();
        if (b1 == -1) {
            throw new EOFException();
        }
        if ((b1 & 0x80) == 0) {
            return b1;
        }
        if ((b1 & 0x40) == 0) {
            return (b1 & 0x7F) << 8 | is.read();
        }
        if ((b1 & 0x20) == 0) {
            int b2 = is.read();
            int b3 = is.read();
            return (b1 & 0x3F) << 16 | b2 << 8 | b3;
        }
        if ((b1 & 0x10) == 0) {
            long result = (long)(b1 & 0x1F) << 24;
            result |= (long)(is.read() << 16);
            result |= (long)(is.read() << 8);
            return result |= (long)is.read();
        }
        if ((b1 & 8) == 0) {
            long value = (long)(b1 & 0xF) << 32;
            value |= (0xFFL & (long)is.read()) << 24;
            value |= (long)(is.read() << 16);
            value |= (long)(is.read() << 8);
            return value |= (long)is.read();
        }
        if ((b1 & 4) == 0) {
            long result = (long)(b1 & 7) << 40;
            result |= (0xFFL & (long)is.read()) << 32;
            result |= (0xFFL & (long)is.read()) << 24;
            result |= (long)(is.read() << 16);
            result |= (long)(is.read() << 8);
            return result |= (long)is.read();
        }
        if ((b1 & 2) == 0) {
            long result = (long)(b1 & 3) << 48;
            result |= (0xFFL & (long)is.read()) << 40;
            result |= (0xFFL & (long)is.read()) << 32;
            result |= (0xFFL & (long)is.read()) << 24;
            result |= (long)(is.read() << 16);
            result |= (long)(is.read() << 8);
            return result |= (long)is.read();
        }
        if ((b1 & 1) == 0) {
            long result = (0xFFL & (long)is.read()) << 48;
            result |= (0xFFL & (long)is.read()) << 40;
            result |= (0xFFL & (long)is.read()) << 32;
            result |= (0xFFL & (long)is.read()) << 24;
            result |= (long)(is.read() << 16);
            result |= (long)(is.read() << 8);
            return result |= (long)is.read();
        }
        long result = (0xFFL & (long)is.read()) << 56;
        result |= (0xFFL & (long)is.read()) << 48;
        result |= (0xFFL & (long)is.read()) << 40;
        result |= (0xFFL & (long)is.read()) << 32;
        result |= (0xFFL & (long)is.read()) << 24;
        result |= (long)(is.read() << 16);
        result |= (long)(is.read() << 8);
        return result |= (long)is.read();
    }

    public static final int writeUnsignedLTF8(long value, OutputStream os) throws IOException {
        if (value >>> 7 == 0L) {
            os.write((int)value);
            return 8;
        }
        if (value >>> 14 == 0L) {
            os.write((int)(value >> 8 | 0x80L));
            os.write((int)(value & 0xFFL));
            return 16;
        }
        if (value >>> 21 == 0L) {
            os.write((int)(value >> 16 | 0xC0L));
            os.write((int)(value >> 8 & 0xFFL));
            os.write((int)(value & 0xFFL));
            return 24;
        }
        if (value >>> 28 == 0L) {
            os.write((int)(value >> 24 | 0xE0L));
            os.write((int)(value >> 16 & 0xFFL));
            os.write((int)(value >> 8 & 0xFFL));
            os.write((int)(value & 0xFFL));
            return 32;
        }
        if (value >>> 35 == 0L) {
            os.write((int)(value >> 32 | 0xF0L));
            os.write((int)(value >> 24 & 0xFFL));
            os.write((int)(value >> 16 & 0xFFL));
            os.write((int)(value >> 8 & 0xFFL));
            os.write((int)(value & 0xFFL));
            return 40;
        }
        if (value >>> 42 == 0L) {
            os.write((int)(value >> 40 | 0xF8L));
            os.write((int)(value >> 32 & 0xFFL));
            os.write((int)(value >> 24 & 0xFFL));
            os.write((int)(value >> 16 & 0xFFL));
            os.write((int)(value >> 8 & 0xFFL));
            os.write((int)(value & 0xFFL));
            return 48;
        }
        if (value >>> 49 == 0L) {
            os.write((int)(value >> 48 | 0xFCL));
            os.write((int)(value >> 40 & 0xFFL));
            os.write((int)(value >> 32 & 0xFFL));
            os.write((int)(value >> 24 & 0xFFL));
            os.write((int)(value >> 16 & 0xFFL));
            os.write((int)(value >> 8 & 0xFFL));
            os.write((int)(value & 0xFFL));
            return 56;
        }
        if (value >>> 56 == 0L) {
            os.write(254);
            os.write((int)(value >> 48 & 0xFFL));
            os.write((int)(value >> 40 & 0xFFL));
            os.write((int)(value >> 32 & 0xFFL));
            os.write((int)(value >> 24 & 0xFFL));
            os.write((int)(value >> 16 & 0xFFL));
            os.write((int)(value >> 8 & 0xFFL));
            os.write((int)(value & 0xFFL));
            return 64;
        }
        os.write(255);
        os.write((int)(value >> 56 & 0xFFL));
        os.write((int)(value >> 48 & 0xFFL));
        os.write((int)(value >> 40 & 0xFFL));
        os.write((int)(value >> 32 & 0xFFL));
        os.write((int)(value >> 28 & 0xFFL));
        os.write((int)(value >> 16 & 0xFFL));
        os.write((int)(value >> 8 & 0xFFL));
        os.write((int)(value & 0xFFL));
        return 72;
    }

    public static final int readUnsignedITF8(byte[] data) {
        ByteBuffer buf = ByteBuffer.wrap(data);
        int value = ByteBufferUtils.readUnsignedITF8(buf);
        buf.clear();
        return value;
    }

    public static final byte[] writeUnsignedITF8(int value) {
        ByteBuffer buf = ByteBuffer.allocate(10);
        ByteBufferUtils.writeUnsignedITF8(value, buf);
        buf.flip();
        byte[] array = new byte[buf.limit()];
        buf.get(array);
        buf.clear();
        return array;
    }

    public static final int readUnsignedITF8(ByteBuffer buf) {
        int b1 = 0xFF & buf.get();
        if ((b1 & 0x80) == 0) {
            return b1;
        }
        if ((b1 & 0x40) == 0) {
            return (b1 & 0x7F) << 8 | 0xFF & buf.get();
        }
        if ((b1 & 0x20) == 0) {
            int b2 = 0xFF & buf.get();
            int b3 = 0xFF & buf.get();
            return (b1 & 0x3F) << 16 | b2 << 8 | b3;
        }
        if ((b1 & 0x10) == 0) {
            return (b1 & 0x1F) << 24 | (0xFF & buf.get()) << 16 | (0xFF & buf.get()) << 8 | 0xFF & buf.get();
        }
        return (b1 & 0xF) << 28 | (0xFF & buf.get()) << 20 | (0xFF & buf.get()) << 12 | (0xFF & buf.get()) << 4 | 0xF & buf.get();
    }

    public static final void writeUnsignedITF8(int value, ByteBuffer buf) {
        if (value >>> 7 == 0) {
            buf.put((byte)value);
            return;
        }
        if (value >>> 14 == 0) {
            buf.put((byte)(value >> 8 | 0x80));
            buf.put((byte)(value & 0xFF));
            return;
        }
        if (value >>> 21 == 0) {
            buf.put((byte)(value >> 16 | 0xC0));
            buf.put((byte)(value >> 8 & 0xFF));
            buf.put((byte)(value & 0xFF));
            return;
        }
        if (value >>> 28 == 0) {
            buf.put((byte)(value >> 24 | 0xE0));
            buf.put((byte)(value >> 16 & 0xFF));
            buf.put((byte)(value >> 8 & 0xFF));
            buf.put((byte)(value & 0xFF));
            return;
        }
        buf.put((byte)(value >> 28 | 0xF0));
        buf.put((byte)(value >> 20 & 0xFF));
        buf.put((byte)(value >> 12 & 0xFF));
        buf.put((byte)(value >> 4 & 0xFF));
        buf.put((byte)(value & 0xFF));
    }

    private static boolean testLTF8(long value) throws IOException {
        ltf8TestBAOS.reset();
        int len = ByteBufferUtils.writeUnsignedLTF8(value, ltf8TestBAOS);
        if (len > 72) {
            System.out.println("Written length is too big: " + len);
            return false;
        }
        ltf8TestBAIS.reset();
        long result = ByteBufferUtils.readUnsignedLTF8(ltf8TestBAIS);
        if (value != result) {
            System.out.printf("Value=%d, result=%d\n", value, result);
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws IOException {
        int i2;
        CRC16 crc16 = new CRC16();
        String eof = "00 00 00 00 ff ff ff ff ff e0 45 4f 46 00 00 00 00 01 00";
        eof = "01";
        for (byte b2 : ByteBufferUtils.bytesFromHex(eof)) {
            crc16.update(b2);
        }
        crc16.reset();
        crc16.update((byte)1);
        System.out.println("crc16: " + crc16.value);
        System.out.println("fnv1a_32: " + ByteBufferUtils.fnv1a_32("a".getBytes()));
        System.out.println("FNV_1a: " + ByteBufferUtils.my_fnv1a_32("a".getBytes()));
        System.out.println(2166136261L);
        System.out.println(3826002220L);
        byte[] data = new byte[0x100000];
        new Random().nextBytes(data);
        long hash = 0L;
        Adler32 a2 = new Adler32();
        long aValue = 0L;
        long time1 = System.currentTimeMillis();
        for (int i3 = 0; i3 < 100; ++i3) {
            hash += ByteBufferUtils.my_fnv1a_32(data);
        }
        long time2 = System.currentTimeMillis();
        System.out.println(aValue);
        System.out.printf("FNV_1A: %.2f s\n", Float.valueOf((float)(time2 - time1) / 1000.0f));
        CRC32 crc32 = new CRC32();
        time1 = System.currentTimeMillis();
        for (i2 = 0; i2 < 100; ++i2) {
            crc32.reset();
            crc32.update(data);
            hash += crc32.getValue();
        }
        time2 = System.currentTimeMillis();
        System.out.println(aValue);
        System.out.printf("CRC32: %.2f s\n", Float.valueOf((float)(time2 - time1) / 1000.0f));
        time1 = System.currentTimeMillis();
        for (i2 = 0; i2 < 100; ++i2) {
            a2.reset();
            a2.update(data);
            aValue += a2.getValue();
        }
        time2 = System.currentTimeMillis();
        System.out.println(hash);
        System.out.printf("Adler32: %.2f s\n", Float.valueOf((float)(time2 - time1) / 1000.0f));
    }

    private static String toHex(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (byte t2 : bytes) {
            sb.append(Integer.toHexString(0xFF & t2));
        }
        return sb.toString();
    }

    public static int int32(InputStream is) throws IOException {
        return is.read() | is.read() << 8 | is.read() << 16 | is.read() << 24;
    }

    public static int int32(byte[] data) throws IOException {
        if (data.length != 4) {
            throw new IllegalArgumentException("Expecting a 4-byte integer. ");
        }
        return 0xFF & data[0] | (0xFF & data[1]) << 8 | (0xFF & data[2]) << 16 | (0xFF & data[3]) << 24;
    }

    public static int writeInt32(int value, OutputStream os) throws IOException {
        os.write((byte)value);
        os.write((byte)(value >> 8));
        os.write((byte)(value >> 16));
        os.write((byte)(value >> 24));
        return 4;
    }

    public static int int32(ByteBuffer buf) throws IOException {
        return buf.get() | buf.get() << 8 | buf.get() << 16 | buf.get() << 24;
    }

    public static int[] array(InputStream is) throws IOException {
        int size = ByteBufferUtils.readUnsignedITF8(is);
        int[] array = new int[size];
        for (int i2 = 0; i2 < size; ++i2) {
            array[i2] = ByteBufferUtils.readUnsignedITF8(is);
        }
        return array;
    }

    public static int write(int[] array, OutputStream os) throws IOException {
        int len = ByteBufferUtils.writeUnsignedITF8(array.length, os);
        for (int i2 = 0; i2 < array.length; ++i2) {
            len += ByteBufferUtils.writeUnsignedITF8(array[i2], os);
        }
        return len;
    }

    public static int readFully(byte[] data, InputStream is) throws IOException {
        return ByteBufferUtils.readFully(data, data.length, 0, is);
    }

    public static int readFully(byte[] data, int length, int offset, InputStream inputStream) throws IOException {
        int n2;
        int count;
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (n2 = 0; n2 < length; n2 += count) {
            count = inputStream.read(data, offset + n2, length - n2);
            if (count >= 0) continue;
            throw new EOFException();
        }
        return n2;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n2 = 0;
        while (-1 != (n2 = input.read(buffer))) {
            output.write(buffer, 0, n2);
            count += (long)n2;
        }
        return count;
    }

    public static byte[] readFully(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        long count = ByteBufferUtils.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            throw new RuntimeException("Failed to copy data because the size is over 2g limit. ");
        }
        return output.toByteArray();
    }

    public static byte[] gunzip(byte[] data) throws IOException {
        GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(data));
        return ByteBufferUtils.readFully(gis);
    }

    public static byte[] gzip(byte[] data) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gos = new GZIPOutputStream(baos){
            {
                this.def.setLevel(GZIP_COMPRESSION_LEVEL);
            }
        };
        long count = ByteBufferUtils.copyLarge(new ByteArrayInputStream(data), gos);
        gos.close();
        return baos.toByteArray();
    }

    public static String substring(ByteBuffer buf, int len) {
        byte[] data = new byte[Math.min(len, buf.limit())];
        buf.get(data);
        return new String(data);
    }

    public static final long FNV_1a(byte[] data) {
        int i2;
        long hash = 2166136261L;
        long octet = 0L;
        ByteBuffer b2 = ByteBuffer.wrap(data);
        for (i2 = 0; i2 < data.length / 8; ++i2) {
            hash |= b2.getLong();
            hash *= 1099511628211L;
        }
        for (i2 = 0; i2 < data.length % 8; ++i2) {
            octet |= (long)(data[data.length - data.length % 8 + i2] << 64 - i2 * 8);
        }
        return hash *= 1099511628211L;
    }

    public static final BigInteger fnv1a_32(byte[] data) {
        for (byte b2 : data) {
            HASH = HASH.xor(BigInteger.valueOf(b2 & 0xFF));
            HASH = HASH.multiply(PRIME32).mod(MOD32);
        }
        return HASH;
    }

    public static final long my_fnv1a(byte[] data) {
        long hash = 2166136261L;
        for (byte b2 : data) {
            hash ^= (long)(b2 & 0xFF);
            hash = hash * 16777619L % 0x100000000L;
        }
        return hash;
    }

    public static final long my_fnv1a_32(byte[] data) {
        long hash = 2166136261L;
        for (byte b2 : data) {
            hash ^= (long)(b2 & 0xFF);
            hash *= 16777619L;
        }
        return hash % 0x100000000L;
    }

    public static byte[] bytesFromHex(String s2) {
        String clean = s2.replaceAll("[^0-9a-f]", "");
        if (clean.length() % 2 != 0) {
            throw new RuntimeException("Not a hex string: " + s2);
        }
        byte[] data = new byte[clean.length() / 2];
        for (int i2 = 0; i2 < clean.length(); i2 += 2) {
            data[i2 / 2] = Integer.decode("0x" + clean.charAt(i2) + clean.charAt(i2 + 1)).byteValue();
        }
        return data;
    }

    public static void reverse(byte[] array, int offset, int size) {
        if (array == null) {
            return;
        }
        int i2 = offset;
        for (int j2 = size - 1; j2 > i2; --j2, ++i2) {
            byte tmp = array[j2];
            array[j2] = array[i2];
            array[i2] = tmp;
        }
    }

    public static void reverse(ByteBuffer ptr) {
        byte tmp = 0;
        if (ptr.hasArray()) {
            ByteBufferUtils.reverse(ptr.array(), ptr.arrayOffset(), ptr.limit());
        } else {
            for (int i2 = 0; i2 < ptr.limit(); ++i2) {
                tmp = ptr.get(i2);
                ptr.put(i2, ptr.get(ptr.limit() - i2 - 1));
                ptr.put(ptr.limit() - i2 - 1, tmp);
            }
        }
    }
}

