/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.reader;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.cram.encoding.reader.AbstractReader;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;

class ReadFeatureBuffer {
    private ByteBuffer readFeatureBuffer = ByteBuffer.allocate(0x100000);
    private int readFeatureSize;

    ReadFeatureBuffer() {
    }

    public final void readReadFeatures(AbstractReader reader) throws IOException {
        this.readFeatureBuffer.clear();
        this.readFeatureSize = (Integer)reader.nfc.readData();
        int prevPos = 0;
        block12: for (int i2 = 0; i2 < this.readFeatureSize; ++i2) {
            int pos;
            Byte operator = (Byte)reader.fc.readData();
            prevPos = pos = prevPos + (Integer)reader.fp.readData();
            this.readFeatureBuffer.put(operator);
            this.readFeatureBuffer.putInt(pos);
            switch (operator) {
                case 66: {
                    this.readFeatureBuffer.put((Byte)reader.bc.readData());
                    this.readFeatureBuffer.put((Byte)reader.qc.readData());
                    continue block12;
                }
                case 88: {
                    this.readFeatureBuffer.put((Byte)reader.bsc.readData());
                    continue block12;
                }
                case 73: {
                    byte[] ins = (byte[])reader.inc.readData();
                    this.readFeatureBuffer.putInt(ins.length);
                    this.readFeatureBuffer.put(ins);
                    continue block12;
                }
                case 83: {
                    byte[] softClip = reader.softClipCodec.readData();
                    this.readFeatureBuffer.putInt(softClip.length);
                    this.readFeatureBuffer.put(softClip);
                    continue block12;
                }
                case 68: {
                    this.readFeatureBuffer.putInt((Integer)reader.dlc.readData());
                    continue block12;
                }
                case 78: {
                    this.readFeatureBuffer.putInt(reader.refSkipCodec.readData());
                    continue block12;
                }
                case 105: {
                    this.readFeatureBuffer.put((Byte)reader.bc.readData());
                    continue block12;
                }
                case 81: {
                    this.readFeatureBuffer.put((Byte)reader.qc.readData());
                    continue block12;
                }
                case 72: {
                    this.readFeatureBuffer.putInt(reader.hardClipCodec.readData());
                    continue block12;
                }
                case 80: {
                    this.readFeatureBuffer.putInt(reader.paddingCodec.readData());
                    continue block12;
                }
                default: {
                    throw new RuntimeException("Unknown read feature operator: " + operator);
                }
            }
        }
        this.readFeatureBuffer.flip();
    }

    public final void restoreReadBases(int readLength, int prevAlStart, byte[] ref, SubstitutionMatrix substitutionMatrix, byte[] bases) {
        this.readFeatureBuffer.rewind();
        int posInRead = 1;
        int alignmentStart = prevAlStart - 1;
        int posInSeq = 0;
        if (!this.readFeatureBuffer.hasRemaining()) {
            if (ref.length < alignmentStart + readLength) {
                Arrays.fill(bases, 0, readLength, (byte)78);
                System.arraycopy(ref, alignmentStart, bases, 0, Math.min(readLength, ref.length - alignmentStart));
            } else {
                System.arraycopy(ref, alignmentStart, bases, 0, readLength);
            }
        }
        block12: for (int r2 = 0; r2 < this.readFeatureSize; ++r2) {
            byte op = this.readFeatureBuffer.get();
            int rfPos = this.readFeatureBuffer.getInt();
            while (posInRead < rfPos) {
                bases[posInRead - 1] = ref[alignmentStart + posInSeq++];
                ++posInRead;
            }
            int len = 0;
            switch (op) {
                case 88: {
                    byte base;
                    byte refBase = ref[alignmentStart + posInSeq];
                    bases[posInRead - 1] = base = substitutionMatrix.base(refBase, this.readFeatureBuffer.get());
                    ++posInRead;
                    ++posInSeq;
                    continue block12;
                }
                case 73: {
                    len = this.readFeatureBuffer.getInt();
                    this.readFeatureBuffer.get(bases, posInRead - 1, len);
                    posInRead += len;
                    continue block12;
                }
                case 83: {
                    len = this.readFeatureBuffer.getInt();
                    this.readFeatureBuffer.get(bases, posInRead - 1, len);
                    posInRead += len;
                    continue block12;
                }
                case 72: {
                    this.readFeatureBuffer.getInt();
                    continue block12;
                }
                case 78: {
                    len = this.readFeatureBuffer.getInt();
                    posInSeq += len;
                    continue block12;
                }
                case 80: {
                    posInSeq += this.readFeatureBuffer.getInt();
                    continue block12;
                }
                case 68: {
                    posInSeq += this.readFeatureBuffer.getInt();
                    continue block12;
                }
                case 105: {
                    bases[posInRead++ - 1] = this.readFeatureBuffer.get();
                    continue block12;
                }
                case 66: {
                    bases[posInRead++ - 1] = this.readFeatureBuffer.get();
                    this.readFeatureBuffer.get();
                    continue block12;
                }
                case 81: {
                    this.readFeatureBuffer.get();
                    continue block12;
                }
                default: {
                    throw new RuntimeException("Unkown operator: " + op);
                }
            }
        }
        while (posInRead <= readLength && alignmentStart + posInSeq < ref.length) {
            bases[posInRead - 1] = ref[alignmentStart + posInSeq++];
            ++posInRead;
        }
    }

    public final Cigar getCigar(int readLength) {
        CigarElement ce;
        this.readFeatureBuffer.rewind();
        if (!this.readFeatureBuffer.hasRemaining()) {
            CigarElement ce2 = new CigarElement(readLength, CigarOperator.M);
            return new Cigar(Arrays.asList(ce2));
        }
        ArrayList<CigarElement> list = new ArrayList<CigarElement>();
        int totalOpLen = 1;
        CigarOperator lastOperator = CigarOperator.MATCH_OR_MISMATCH;
        int lastOpLen = 0;
        int lastOpPos = 1;
        CigarOperator co = null;
        int rfLen = 0;
        block11: for (int r2 = 0; r2 < this.readFeatureSize; ++r2) {
            byte op = this.readFeatureBuffer.get();
            int rfPos = this.readFeatureBuffer.getInt();
            int gap = rfPos - (lastOpPos + lastOpLen);
            if (gap > 0) {
                if (lastOperator != CigarOperator.MATCH_OR_MISMATCH) {
                    list.add(new CigarElement(lastOpLen, lastOperator));
                    lastOpPos += lastOpLen;
                    totalOpLen += lastOpLen;
                    lastOpLen = gap;
                } else {
                    lastOpLen += gap;
                }
                lastOperator = CigarOperator.MATCH_OR_MISMATCH;
            }
            switch (op) {
                case 73: {
                    co = CigarOperator.INSERTION;
                    rfLen = this.readFeatureBuffer.getInt();
                    this.readFeatureBuffer.position(this.readFeatureBuffer.position() + rfLen);
                    break;
                }
                case 83: {
                    co = CigarOperator.SOFT_CLIP;
                    rfLen = this.readFeatureBuffer.getInt();
                    this.readFeatureBuffer.position(this.readFeatureBuffer.position() + rfLen);
                    break;
                }
                case 72: {
                    co = CigarOperator.HARD_CLIP;
                    rfLen = this.readFeatureBuffer.getInt();
                    break;
                }
                case 105: {
                    co = CigarOperator.INSERTION;
                    rfLen = 1;
                    this.readFeatureBuffer.get();
                    break;
                }
                case 68: {
                    co = CigarOperator.DELETION;
                    rfLen = this.readFeatureBuffer.getInt();
                    break;
                }
                case 78: {
                    co = CigarOperator.SKIPPED_REGION;
                    rfLen = this.readFeatureBuffer.getInt();
                    break;
                }
                case 80: {
                    co = CigarOperator.PADDING;
                    rfLen = this.readFeatureBuffer.getInt();
                    break;
                }
                case 66: 
                case 88: {
                    co = CigarOperator.MATCH_OR_MISMATCH;
                    rfLen = 1;
                    this.readFeatureBuffer.get();
                    this.readFeatureBuffer.get();
                    break;
                }
                case 81: {
                    this.readFeatureBuffer.get();
                    continue block11;
                }
                default: {
                    continue block11;
                }
            }
            if (lastOperator != co) {
                if (lastOpLen > 0) {
                    list.add(new CigarElement(lastOpLen, lastOperator));
                    totalOpLen += lastOpLen;
                }
                lastOperator = co;
                lastOpLen = rfLen;
                lastOpPos = rfPos;
            } else {
                lastOpLen += rfLen;
            }
            if (co.consumesReadBases()) continue;
            lastOpPos -= rfLen;
        }
        if (lastOperator != null) {
            if (lastOperator != CigarOperator.M) {
                list.add(new CigarElement(lastOpLen, lastOperator));
                if (readLength >= lastOpPos + lastOpLen) {
                    ce = new CigarElement(readLength - (lastOpLen + lastOpPos) + 1, CigarOperator.M);
                    list.add(ce);
                }
            } else if (readLength > lastOpPos - 1) {
                ce = new CigarElement(readLength - lastOpPos + 1, CigarOperator.M);
                list.add(ce);
            }
        }
        if (list.isEmpty()) {
            ce = new CigarElement(readLength, CigarOperator.M);
            return new Cigar(Arrays.asList(ce));
        }
        return new Cigar(list);
    }

    public void restoreQualityScores(int readLength, int prevAlStart, byte[] scores) {
        this.readFeatureBuffer.rewind();
        int posInRead = 1;
        block12: for (int r2 = 0; r2 < this.readFeatureSize; ++r2) {
            byte op = this.readFeatureBuffer.get();
            posInRead = this.readFeatureBuffer.getInt();
            int len = 0;
            switch (op) {
                case 88: {
                    this.readFeatureBuffer.get();
                    continue block12;
                }
                case 73: {
                    int i2;
                    len = this.readFeatureBuffer.getInt();
                    for (i2 = 0; i2 < len; ++i2) {
                        this.readFeatureBuffer.get();
                    }
                    continue block12;
                }
                case 83: {
                    int i2;
                    len = this.readFeatureBuffer.getInt();
                    for (i2 = 0; i2 < len; ++i2) {
                        this.readFeatureBuffer.get();
                    }
                    continue block12;
                }
                case 72: {
                    this.readFeatureBuffer.getInt();
                    continue block12;
                }
                case 78: {
                    len = this.readFeatureBuffer.getInt();
                    continue block12;
                }
                case 80: {
                    this.readFeatureBuffer.getInt();
                    continue block12;
                }
                case 68: {
                    this.readFeatureBuffer.getInt();
                    continue block12;
                }
                case 105: {
                    this.readFeatureBuffer.get();
                    continue block12;
                }
                case 66: {
                    this.readFeatureBuffer.get();
                    scores[posInRead - 1] = this.readFeatureBuffer.get();
                    continue block12;
                }
                case 81: {
                    scores[posInRead - 1] = this.readFeatureBuffer.get();
                    continue block12;
                }
                default: {
                    throw new RuntimeException("Unkown operator: " + op);
                }
            }
        }
    }
}

