/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;

public class SubexpIntegerCodec
extends AbstractBitCodec<Integer> {
    private int offset = 0;
    private int k = 2;
    private boolean unaryBit = true;

    public SubexpIntegerCodec(int offset, int k2) {
        this(offset, k2, true);
    }

    public SubexpIntegerCodec(int offset, int k2, boolean unaryBit) {
        this.offset = offset;
        this.k = k2;
        this.unaryBit = unaryBit;
    }

    public SubexpIntegerCodec(int k2) {
        this.k = k2;
    }

    @Override
    public final Integer read(BitInputStream bis) throws IOException {
        int u2 = 0;
        while (bis.readBit() == this.unaryBit) {
            ++u2;
        }
        int b2 = 0;
        int n2 = 0;
        if (u2 == 0) {
            b2 = this.k;
            n2 = bis.readBits(b2);
        } else {
            b2 = u2 + this.k - 1;
            n2 = 1 << b2 | bis.readBits(b2);
        }
        return n2 - this.offset;
    }

    @Override
    public final long write(BitOutputStream bos, Integer value) throws IOException {
        if (value + this.offset < 0) {
            throw new IllegalArgumentException("Value is less then offset: " + value);
        }
        long newValue = value + this.offset;
        int b2 = 0;
        int u2 = 0;
        if (newValue < 1L << this.k) {
            b2 = this.k;
            u2 = 0;
        } else {
            b2 = (int)(Math.log(newValue) / Math.log(2.0));
            u2 = b2 - this.k + 1;
        }
        bos.write(this.unaryBit, (long)u2);
        bos.write(!this.unaryBit);
        bos.write(newValue, b2);
        return u2 + 1 + b2;
    }

    @Override
    public final long numberOfBits(Integer value) {
        long newValue = value + this.offset;
        long b2 = 0L;
        long u2 = 0L;
        if (newValue < 1L << this.k) {
            b2 = this.k;
            u2 = 0L;
        } else {
            b2 = (long)Math.floor(Math.log(newValue) / Math.log(2.0));
            u2 = b2 - (long)this.k + 1L;
        }
        return u2 + 1L + b2;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k2) {
        this.k = k2;
    }

    public boolean isUnaryBit() {
        return this.unaryBit;
    }

    public void setUnaryBit(boolean unaryBit) {
        this.unaryBit = unaryBit;
    }

    @Override
    public Integer read(BitInputStream bis, int len) throws IOException {
        throw new RuntimeException("Not implemented.");
    }
}

