/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.common.NullOutputStream;
import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.DefaultBitOutputStream;
import htsjdk.samtools.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class ArithCodec
extends AbstractBitCodec<byte[]> {
    private byte curBit = 0;
    private int curByte = 0;
    private double min = 0.0;
    private double max = 1.0;
    private double localMin = 0.0;
    private double localMax = 1.0;
    private final int TERMINATOR = 256;
    private double[] probs;
    private int[] map = new int[257];
    private int[] rev_map;
    private long bitCount;
    private ByteArrayOutputStream baos;
    private ArrayList<Integer> fileData;

    public ArithCodec(int[] freqs, int[] map) {
        Arrays.fill(this.map, -1);
        for (int i2 = 0; i2 < map.length; ++i2) {
            this.map[map[i2]] = i2;
        }
        this.map[this.TERMINATOR] = map.length;
        this.rev_map = new int[map.length + 1];
        System.arraycopy(map, 0, this.rev_map, 0, map.length);
        this.rev_map[map.length] = this.TERMINATOR;
        this.probs = new double[freqs.length + 1];
        int total = 0;
        int endCharCount = 0;
        for (int i3 = 0; i3 < freqs.length; ++i3) {
            total += freqs[i3];
        }
        endCharCount = total / 100 > 0 ? total / 100 : total / 10;
        total += endCharCount;
        int t2 = 0;
        for (int i4 = 0; i4 < freqs.length; ++i4) {
            this.probs[i4] = (double)(t2 += freqs[i4]) / (double)total;
        }
        this.probs[this.probs.length - 1] = 1.0;
        this.baos = new ByteArrayOutputStream(430000000);
        this.fileData = new ArrayList();
    }

    @Override
    public byte[] read(BitInputStream bis) throws IOException {
        this.baos.reset();
        this.fileData.clear();
        this.curBit = 0;
        this.curByte = 0;
        this.min = 0.0;
        this.max = 1.0;
        this.localMin = 0.0;
        this.localMax = 1.0;
        int read = this.decodeCharacter(bis);
        while (read != this.map[this.TERMINATOR]) {
            this.baos.write(this.rev_map[read]);
            read = this.decodeCharacter(bis);
        }
        return this.baos.toByteArray();
    }

    public int decodeCharacter(BitInputStream bis) throws IOException {
        double cur;
        double tempMin = this.min;
        double tempMax = this.max;
        byte tempBit = this.curBit;
        int tempByte = this.curByte;
        int val = 0;
        if (this.fileData.isEmpty()) {
            this.fileData.add(bis.readBits(8));
        }
        while (true) {
            cur = (this.min + this.max) / 2.0;
            val = -1;
            for (int i2 = 0; i2 < this.probs.length; ++i2) {
                if (!(this.probs[i2] > this.min)) continue;
                if (!(this.probs[i2] > this.max)) break;
                val = i2;
                break;
            }
            if (val != -1) break;
            boolean bit = false;
            if ((this.fileData.get(this.curByte) & 128 >> this.curBit) != 0) {
                bit = true;
            }
            if (bit) {
                this.min = cur;
            } else {
                this.max = cur;
            }
            this.curBit = (byte)(this.curBit + 1);
            if (this.curBit != 8) continue;
            this.curBit = 0;
            ++this.curByte;
            if (this.curByte <= this.fileData.size() - 1) continue;
            try {
                this.fileData.add(bis.readBits(8));
            }
            catch (Throwable t2) {
                this.fileData.add(0);
            }
        }
        this.min = tempMin;
        this.max = tempMax;
        this.curBit = tempBit;
        this.curByte = tempByte;
        while (true) {
            int temp;
            cur = (this.min + this.max) / 2.0;
            for (temp = 0; temp < this.probs.length && !(this.probs[temp] > cur); ++temp) {
            }
            if (cur < 0.0 || cur > 1.0) {
                temp = -1;
            }
            if (temp == val) break;
            boolean bit = false;
            if ((this.fileData.get(this.curByte) & 128 >> this.curBit) != 0) {
                bit = true;
            }
            if (bit) {
                this.min = cur;
            } else {
                this.max = cur;
            }
            this.curBit = (byte)(this.curBit + 1);
            if (this.curBit != 8) continue;
            this.curBit = 0;
            ++this.curByte;
            if (this.curByte <= this.fileData.size() - 1) continue;
            try {
                this.fileData.add(bis.readBits(8));
            }
            catch (Throwable t3) {
                this.fileData.add(0);
            }
        }
        tempMin = 0.0;
        if (val > 0) {
            tempMin = this.probs[val - 1];
        }
        double factor = 1.0 / (this.probs[val] - tempMin);
        this.min = factor * (this.min - tempMin);
        this.max = factor * (this.max - tempMin);
        return val;
    }

    @Override
    public long write(BitOutputStream bos, byte[] object) throws IOException {
        this.baos.reset();
        this.curBit = 0;
        this.curByte = 0;
        this.min = 0.0;
        this.max = 1.0;
        this.localMin = 0.0;
        this.localMax = 1.0;
        this.bitCount = 0L;
        try {
            for (int i2 = 0; i2 < object.length; ++i2) {
                this.encodeCharacter(bos, this.map[object[i2] & 0xFF]);
            }
            this.encodeCharacter(bos, this.map[this.TERMINATOR]);
            this.encodeCharacter(bos, this.map[this.TERMINATOR]);
            this.flush(bos);
        }
        catch (Exception ex) {
            Log.getInstance(this.getClass()).error(ex, new Object[0]);
        }
        return this.bitCount;
    }

    private void encodeCharacter(BitOutputStream bos, int character) throws Exception {
        if (this.probs.length < 2 || this.probs[this.probs.length - 1] != 1.0 || character < 0 || character >= this.probs.length) {
            throw new Exception("Invalid input");
        }
        this.localMin = character > 0 ? this.probs[character - 1] : 0.0;
        this.localMax = this.probs[character];
        while (true) {
            double cur;
            if ((cur = (this.min + this.max) / 2.0) < this.localMin) {
                this.curByte |= 128 >> this.curBit;
                this.curBit = (byte)(this.curBit + 1);
                if (this.curBit == 8) {
                    bos.write(this.curByte, 8);
                    this.curByte = 0;
                    this.curBit = 0;
                    this.bitCount += 8L;
                }
                this.min = cur;
                continue;
            }
            if (!(cur >= this.localMax)) break;
            this.curBit = (byte)(this.curBit + 1);
            if (this.curBit == 8) {
                bos.write(this.curByte, 8);
                this.curByte = 0;
                this.curBit = 0;
                this.bitCount += 8L;
            }
            this.max = cur;
        }
        double factor = 1.0 / (this.localMax - this.localMin);
        this.min = factor * (this.min - this.localMin);
        this.max = factor * (this.max - this.localMin);
    }

    private void flush(BitOutputStream bos) throws IOException {
        if (this.curBit != 0) {
            while (true) {
                double mid;
                double cur;
                if ((cur = (this.min + this.max) / 2.0) < (mid = (this.localMin + this.localMax) / 2.0)) {
                    this.curByte |= 128 >> this.curBit;
                    this.min = cur;
                } else {
                    this.max = cur;
                }
                this.curBit = (byte)(this.curBit + 1);
                if (this.curBit != 8) continue;
                bos.write(this.curByte, 8);
                this.curByte = 0;
                this.curBit = 0;
                this.bitCount += 8L;
                cur = (this.min + this.max) / 2.0;
                if (cur >= this.localMin && cur < this.localMax) break;
            }
        }
        bos.close();
    }

    @Override
    public long numberOfBits(byte[] object) {
        NullOutputStream baos = new NullOutputStream();
        DefaultBitOutputStream nBos = new DefaultBitOutputStream(baos);
        this.baos.reset();
        this.curBit = 0;
        this.curByte = 0;
        this.min = 0.0;
        this.max = 1.0;
        this.localMin = 0.0;
        this.localMax = 1.0;
        this.bitCount = 0L;
        try {
            for (int i2 = 0; i2 < object.length; ++i2) {
                this.encodeCharacter(nBos, this.map[object[i2] & 0xFF]);
            }
            this.encodeCharacter(nBos, this.map[this.TERMINATOR]);
            this.encodeCharacter(nBos, this.map[this.TERMINATOR]);
            this.flush(nBos);
        }
        catch (Exception ex) {
            Log.getInstance(ArithCodec.class).error(ex, new Object[0]);
        }
        return this.bitCount;
    }

    @Override
    public byte[] read(BitInputStream bis, int len) throws IOException {
        throw new RuntimeException("Not implemented.");
    }
}

