/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandFailureException;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcernException;

public class CommandResult
extends BasicDBObject {
    private final ServerAddress _host;
    private static final long serialVersionUID = 1L;

    CommandResult(ServerAddress srv) {
        if (srv == null) {
            throw new IllegalArgumentException("server address is null");
        }
        this._host = srv;
        this.put("serverUsed", (Object)srv.toString());
    }

    public boolean ok() {
        Object o2 = this.get("ok");
        if (o2 == null) {
            throw new IllegalArgumentException("'ok' should never be null...");
        }
        if (o2 instanceof Boolean) {
            return (Boolean)o2;
        }
        if (o2 instanceof Number) {
            return ((Number)o2).intValue() == 1;
        }
        throw new IllegalArgumentException("can't figure out what to do with: " + o2.getClass().getName());
    }

    public String getErrorMessage() {
        Object errorMessage = this.get("errmsg");
        if (errorMessage == null) {
            return null;
        }
        return errorMessage.toString();
    }

    public MongoException getException() {
        if (!this.ok()) {
            return new CommandFailureException(this);
        }
        if (this.hasErr()) {
            if (this.getCode() == 11000 || this.getCode() == 11001 || this.getCode() == 12582) {
                return new MongoException.DuplicateKey(this);
            }
            return new WriteConcernException(this);
        }
        return null;
    }

    int getCode() {
        int code = -1;
        if (this.get("code") instanceof Number) {
            code = ((Number)this.get("code")).intValue();
        }
        return code;
    }

    boolean hasErr() {
        Object o2 = this.get("err");
        return o2 != null && ((String)o2).length() > 0;
    }

    public void throwOnError() {
        if (!this.ok() || this.hasErr()) {
            throw this.getException();
        }
    }

    public ServerAddress getServerUsed() {
        return this._host;
    }
}

