/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.dialog.ButtonPanel;
import java.awt.AWTError;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SizeRequirements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ButtonPanelLayout
implements LayoutManager2,
Serializable {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int LINE_AXIS = 2;
    public static final int PAGE_AXIS = 3;
    private Container _target;
    private transient SizeRequirements[] _xChildren;
    private transient SizeRequirements[] _yChildren;
    private transient SizeRequirements _xTotal;
    private transient SizeRequirements _yTotal;
    private List<Component> _affirmativeButtons = new Vector<Component>(13);
    private List<Component> _cancelButtons = new Vector<Component>(13);
    private List<Component> _helpButtons = new Vector<Component>(13);
    private List<Component> _otherButtons = new Vector<Component>(13);
    int _minWidth;
    int _maxWidth;
    int _groupGap = 10;
    int _buttonGap = 6;
    private int _sizeConstraint = 1;
    private String _buttonOrder = "ACO";
    private String _oppositeButtonOrder = "H";
    private int _minButtonWidth = 75;
    private int _axis = 0;
    private int _alignment = 11;
    private static final long serialVersionUID = -738156624351781041L;

    public ButtonPanelLayout(Container target, int axis, int alignment, int sizeConstraint, String buttonOrder, String oppositeButtonOrder, int buttonGap, int groupGap) {
        if (axis != 0 && axis != 1 && axis != 2 && axis != 3) {
            throw new AWTError("Invalid axis");
        }
        this._axis = axis;
        this._target = target;
        this._alignment = alignment;
        this._sizeConstraint = sizeConstraint;
        this._buttonOrder = buttonOrder;
        this._oppositeButtonOrder = oppositeButtonOrder;
        this._buttonGap = buttonGap;
        this._groupGap = groupGap;
    }

    @Override
    public synchronized void invalidateLayout(Container target) {
        this.checkContainer(target);
        this._xChildren = null;
        this._yChildren = null;
        this._xTotal = null;
        this._yTotal = null;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.addLayoutComponent(comp, name);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (this._affirmativeButtons.contains(comp)) {
            this._affirmativeButtons.remove(comp);
        }
        if (this._cancelButtons.contains(comp)) {
            this._cancelButtons.remove(comp);
        }
        if (this._helpButtons.contains(comp)) {
            this._helpButtons.remove(comp);
        }
        if (this._otherButtons.contains(comp)) {
            this._otherButtons.remove(comp);
        }
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if ("AFFIRMATIVE".equals(constraints) && !this._affirmativeButtons.contains(comp)) {
            this._affirmativeButtons.add(comp);
        }
        if ("CANCEL".equals(constraints) && !this._cancelButtons.contains(comp)) {
            this._cancelButtons.add(comp);
        }
        if ("HELP".equals(constraints) && !this._helpButtons.contains(comp)) {
            this._helpButtons.add(comp);
        }
        if ("ALTERNATIVE".equals(constraints) && !this._otherButtons.contains(comp)) {
            this._otherButtons.add(comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Dimension size;
        ButtonPanelLayout buttonPanelLayout = this;
        synchronized (buttonPanelLayout) {
            this.checkContainer(target);
            this.checkRequests();
            size = new Dimension(this._xTotal.preferred, this._yTotal.preferred);
        }
        Insets insets = target.getInsets();
        size.width = (int)Math.min((long)size.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        size.height = (int)Math.min((long)size.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Dimension size;
        ButtonPanelLayout buttonPanelLayout = this;
        synchronized (buttonPanelLayout) {
            this.checkContainer(target);
            this.checkRequests();
            size = new Dimension(this._xTotal.minimum, this._yTotal.minimum);
        }
        Insets insets = target.getInsets();
        size.width = (int)Math.min((long)size.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        size.height = (int)Math.min((long)size.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        Dimension preferredSize = this.preferredLayoutSize(target);
        if (size.width > preferredSize.width) {
            size.width = preferredSize.width;
        }
        if (size.height > preferredSize.height) {
            size.height = preferredSize.height;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension maximumLayoutSize(Container target) {
        Dimension size;
        ButtonPanelLayout buttonPanelLayout = this;
        synchronized (buttonPanelLayout) {
            this.checkContainer(target);
            this.checkRequests();
            size = new Dimension(this._xTotal.maximum, this._yTotal.maximum);
        }
        Insets insets = target.getInsets();
        size.width = (int)Math.min((long)size.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        size.height = (int)Math.min((long)size.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        Dimension preferredSize = this.preferredLayoutSize(target);
        if (size.width < preferredSize.width) {
            size.width = preferredSize.width;
        }
        if (size.height < preferredSize.height) {
            size.height = preferredSize.height;
        }
        return size;
    }

    @Override
    public synchronized float getLayoutAlignmentX(Container target) {
        this.checkContainer(target);
        this.checkRequests();
        return this._xTotal.alignment;
    }

    @Override
    public synchronized float getLayoutAlignmentY(Container target) {
        this.checkContainer(target);
        this.checkRequests();
        return this._yTotal.alignment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        this.checkContainer(target);
        Dimension alloc = target.getSize();
        Insets in = target.getInsets();
        alloc.width -= in.left + in.right;
        alloc.height -= in.top + in.bottom;
        ComponentOrientation o2 = target.getComponentOrientation();
        int absoluteAxis = this.resolveAxis(this._axis, o2);
        boolean ltr = o2.isLeftToRight();
        int alignment = this._alignment;
        if (this._alignment == 10) {
            alignment = ltr ? 2 : 4;
        } else if (this._alignment == 11) {
            alignment = ltr ? 4 : 2;
        }
        ButtonPanelLayout buttonPanelLayout = this;
        synchronized (buttonPanelLayout) {
            this.checkRequests();
            this.resetBounds();
            if (absoluteAxis == 0) {
                int y = in.top;
                if (alignment == 0) {
                    char c2;
                    int i2;
                    Dimension size = this.preferredLayoutSize(target);
                    int x2 = (alloc.width + size.width) / 2;
                    for (i2 = 0; i2 < this.getButtonOrder().length(); ++i2) {
                        c2 = this.getButtonOrder().charAt(this.getButtonOrder().length() - i2 - 1);
                        if (c2 == 'A' || c2 == 'a') {
                            x2 = this.layoutButtonsRightAlign(this._affirmativeButtons, x2, y, alloc, ltr);
                            continue;
                        }
                        if (c2 == 'C' || c2 == 'c') {
                            x2 = this.layoutButtonsRightAlign(this._cancelButtons, x2, y, alloc, ltr);
                            continue;
                        }
                        if (c2 == 'H' || c2 == 'h') {
                            x2 = this.layoutButtonsRightAlign(this._helpButtons, x2, y, alloc, ltr);
                            continue;
                        }
                        if (c2 != 'O' && c2 != 'o') continue;
                        x2 = this.layoutButtonsRightAlign(this._otherButtons, x2, y, alloc, ltr);
                    }
                    x2 = (alloc.width - size.width) / 2;
                    for (i2 = 0; i2 < this.getOppositeButtonOrder().length(); ++i2) {
                        c2 = this.getOppositeButtonOrder().charAt(i2);
                        if (c2 == 'A' || c2 == 'a') {
                            x2 = this.layoutButtonsLeftAlign(this._affirmativeButtons, x2, y, alloc, ltr);
                            continue;
                        }
                        if (c2 == 'C' || c2 == 'c') {
                            x2 = this.layoutButtonsLeftAlign(this._cancelButtons, x2, y, alloc, ltr);
                            continue;
                        }
                        if (c2 == 'H' || c2 == 'h') {
                            x2 = this.layoutButtonsLeftAlign(this._helpButtons, x2, y, alloc, ltr);
                            continue;
                        }
                        if (c2 != 'O' && c2 != 'o') continue;
                        x2 = this.layoutButtonsLeftAlign(this._otherButtons, x2, y, alloc, ltr);
                    }
                } else if (alignment == 4) {
                    char c3;
                    int i3;
                    int x3 = in.left + alloc.width;
                    for (i3 = 0; i3 < this.getButtonOrder().length(); ++i3) {
                        c3 = this.getButtonOrder().charAt(ltr ? this.getButtonOrder().length() - i3 - 1 : i3);
                        if (c3 == 'A' || c3 == 'a') {
                            x3 = this.layoutButtonsRightAlign(this._affirmativeButtons, x3, y, alloc, ltr);
                            continue;
                        }
                        if (c3 == 'C' || c3 == 'c') {
                            x3 = this.layoutButtonsRightAlign(this._cancelButtons, x3, y, alloc, ltr);
                            continue;
                        }
                        if (c3 == 'H' || c3 == 'h') {
                            x3 = this.layoutButtonsRightAlign(this._helpButtons, x3, y, alloc, ltr);
                            continue;
                        }
                        if (c3 != 'O' && c3 != 'o') continue;
                        x3 = this.layoutButtonsRightAlign(this._otherButtons, x3, y, alloc, ltr);
                    }
                    x3 = in.left;
                    for (i3 = 0; i3 < this.getOppositeButtonOrder().length(); ++i3) {
                        c3 = this.getOppositeButtonOrder().charAt(ltr ? i3 : this.getOppositeButtonOrder().length() - i3 - 1);
                        if (c3 == 'A' || c3 == 'a') {
                            x3 = this.layoutButtonsLeftAlign(this._affirmativeButtons, x3, y, alloc, ltr);
                            continue;
                        }
                        if (c3 == 'C' || c3 == 'c') {
                            x3 = this.layoutButtonsLeftAlign(this._cancelButtons, x3, y, alloc, ltr);
                            continue;
                        }
                        if (c3 == 'H' || c3 == 'h') {
                            x3 = this.layoutButtonsLeftAlign(this._helpButtons, x3, y, alloc, ltr);
                            continue;
                        }
                        if (c3 != 'O' && c3 != 'o') continue;
                        x3 = this.layoutButtonsLeftAlign(this._otherButtons, x3, y, alloc, ltr);
                    }
                } else if (alignment == 2) {
                    char c4;
                    int i4;
                    int x4 = in.left;
                    for (i4 = 0; i4 < this.getButtonOrder().length(); ++i4) {
                        c4 = this.getButtonOrder().charAt(ltr ? i4 : this.getButtonOrder().length() - i4 - 1);
                        if (c4 == 'A' || c4 == 'a') {
                            x4 = this.layoutButtonsLeftAlign(this._affirmativeButtons, x4, y, alloc, ltr);
                            continue;
                        }
                        if (c4 == 'C' || c4 == 'c') {
                            x4 = this.layoutButtonsLeftAlign(this._cancelButtons, x4, y, alloc, ltr);
                            continue;
                        }
                        if (c4 == 'H' || c4 == 'h') {
                            x4 = this.layoutButtonsLeftAlign(this._helpButtons, x4, y, alloc, ltr);
                            continue;
                        }
                        if (c4 != 'O' && c4 != 'o') continue;
                        x4 = this.layoutButtonsLeftAlign(this._otherButtons, x4, y, alloc, ltr);
                    }
                    x4 = in.left + alloc.width;
                    for (i4 = 0; i4 < this.getOppositeButtonOrder().length(); ++i4) {
                        c4 = this.getOppositeButtonOrder().charAt(ltr ? this.getOppositeButtonOrder().length() - i4 - 1 : i4);
                        if (c4 == 'A' || c4 == 'a') {
                            x4 = this.layoutButtonsRightAlign(this._affirmativeButtons, x4, y, alloc, ltr);
                            continue;
                        }
                        if (c4 == 'C' || c4 == 'c') {
                            x4 = this.layoutButtonsRightAlign(this._cancelButtons, x4, y, alloc, ltr);
                            continue;
                        }
                        if (c4 == 'H' || c4 == 'h') {
                            x4 = this.layoutButtonsRightAlign(this._helpButtons, x4, y, alloc, ltr);
                            continue;
                        }
                        if (c4 != 'O' && c4 != 'o') continue;
                        x4 = this.layoutButtonsRightAlign(this._otherButtons, x4, y, alloc, ltr);
                    }
                }
            } else {
                int x5 = in.left;
                if (alignment == 1) {
                    char c5;
                    int i5;
                    int y = in.top;
                    for (i5 = 0; i5 < this.getButtonOrder().length(); ++i5) {
                        c5 = this.getButtonOrder().charAt(i5);
                        if (c5 == 'A' || c5 == 'a') {
                            y = this.layoutButtonsTopAlign(this._affirmativeButtons, x5, y, alloc);
                            continue;
                        }
                        if (c5 == 'C' || c5 == 'c') {
                            y = this.layoutButtonsTopAlign(this._cancelButtons, x5, y, alloc);
                            continue;
                        }
                        if (c5 == 'H' || c5 == 'h') {
                            y = this.layoutButtonsTopAlign(this._helpButtons, x5, y, alloc);
                            continue;
                        }
                        if (c5 != 'O' && c5 != 'o') continue;
                        y = this.layoutButtonsTopAlign(this._otherButtons, x5, y, alloc);
                    }
                    y = in.top + alloc.height;
                    for (i5 = 0; i5 < this.getOppositeButtonOrder().length(); ++i5) {
                        c5 = this.getOppositeButtonOrder().charAt(this.getOppositeButtonOrder().length() - i5 - 1);
                        if (c5 == 'A' || c5 == 'a') {
                            y = this.layoutButtonsBottomAlign(this._affirmativeButtons, x5, y, alloc);
                            continue;
                        }
                        if (c5 == 'C' || c5 == 'c') {
                            y = this.layoutButtonsBottomAlign(this._cancelButtons, x5, y, alloc);
                            continue;
                        }
                        if (c5 == 'H' || c5 == 'h') {
                            y = this.layoutButtonsBottomAlign(this._helpButtons, x5, y, alloc);
                            continue;
                        }
                        if (c5 != 'O' && c5 != 'o') continue;
                        y = this.layoutButtonsBottomAlign(this._otherButtons, x5, y, alloc);
                    }
                } else if (alignment == 3) {
                    char c6;
                    int i6;
                    int y = in.top + alloc.height;
                    for (i6 = 0; i6 < this.getButtonOrder().length(); ++i6) {
                        c6 = this.getButtonOrder().charAt(this.getButtonOrder().length() - i6 - 1);
                        if (c6 == 'A' || c6 == 'a') {
                            y = this.layoutButtonsBottomAlign(this._affirmativeButtons, x5, y, alloc);
                            continue;
                        }
                        if (c6 == 'C' || c6 == 'c') {
                            y = this.layoutButtonsBottomAlign(this._cancelButtons, x5, y, alloc);
                            continue;
                        }
                        if (c6 == 'H' || c6 == 'h') {
                            y = this.layoutButtonsBottomAlign(this._helpButtons, x5, y, alloc);
                            continue;
                        }
                        if (c6 != 'O' && c6 != 'o') continue;
                        y = this.layoutButtonsBottomAlign(this._otherButtons, x5, y, alloc);
                    }
                    y = in.top;
                    for (i6 = 0; i6 < this.getOppositeButtonOrder().length(); ++i6) {
                        c6 = this.getOppositeButtonOrder().charAt(i6);
                        if (c6 == 'A' || c6 == 'a') {
                            y = this.layoutButtonsTopAlign(this._affirmativeButtons, x5, y, alloc);
                            continue;
                        }
                        if (c6 == 'C' || c6 == 'c') {
                            y = this.layoutButtonsTopAlign(this._cancelButtons, x5, y, alloc);
                            continue;
                        }
                        if (c6 == 'H' || c6 == 'h') {
                            y = this.layoutButtonsTopAlign(this._helpButtons, x5, y, alloc);
                            continue;
                        }
                        if (c6 != 'O' && c6 != 'o') continue;
                        y = this.layoutButtonsTopAlign(this._otherButtons, x5, y, alloc);
                    }
                }
            }
        }
    }

    private int layoutButtonsRightAlign(List<Component> buttons, int x2, int y, Dimension alloc, boolean ltr) {
        boolean containsVisibleButton = false;
        for (int i2 = this._target.getComponentCount() - 1; i2 >= 0; --i2) {
            Component component = ltr ? this._target.getComponent(i2) : this._target.getComponent(this._target.getComponentCount() - 1 - i2);
            if (!component.isVisible() || !buttons.contains(component)) continue;
            if (containsVisibleButton) {
                x2 -= this._buttonGap;
            }
            containsVisibleButton = true;
            int prefWidth = component.getPreferredSize().width;
            int width = prefWidth > this._minWidth || this.shouldKeepPreferredWidth(component) ? prefWidth : this._minWidth;
            component.setBounds(x2 - width, y, width, alloc.height);
            x2 -= width;
        }
        if (buttons.size() != 0 && containsVisibleButton) {
            x2 -= this._groupGap;
        }
        return x2;
    }

    private int layoutButtonsLeftAlign(List<Component> buttons, int x2, int y, Dimension alloc, boolean ltr) {
        boolean containsVisibleButton = false;
        for (int i2 = 0; i2 < this._target.getComponentCount(); ++i2) {
            Component component = ltr ? this._target.getComponent(i2) : this._target.getComponent(this._target.getComponentCount() - 1 - i2);
            if (!component.isVisible() || !buttons.contains(component)) continue;
            containsVisibleButton = true;
            int prefWidth = component.getPreferredSize().width;
            int width = prefWidth > this._minWidth || this.shouldKeepPreferredWidth(component) ? prefWidth : this._minWidth;
            component.setBounds(x2, y, width, alloc.height);
            x2 += width + this._buttonGap;
        }
        if (containsVisibleButton) {
            x2 -= this._buttonGap;
            x2 += this._groupGap;
        }
        return x2;
    }

    private int layoutButtonsBottomAlign(List<Component> buttons, int x2, int y, Dimension alloc) {
        boolean containsVisibleButton = false;
        for (int i2 = this._target.getComponentCount() - 1; i2 >= 0; --i2) {
            Component component = this._target.getComponent(i2);
            if (!component.isVisible() || !buttons.contains(component)) continue;
            if (containsVisibleButton) {
                y -= this._buttonGap;
            }
            containsVisibleButton = true;
            Dimension preferredSize = component.getPreferredSize();
            int height = preferredSize.height;
            int prefWidth = preferredSize.width;
            component.setBounds(this.shouldKeepPreferredWidth(component) ? alloc.width - prefWidth + x2 : x2, y - height, this.shouldKeepPreferredWidth(component) ? prefWidth : alloc.width, height);
            y -= height;
        }
        if (buttons.size() != 0 && containsVisibleButton) {
            y -= this._groupGap;
        }
        return y;
    }

    private int layoutButtonsTopAlign(List<Component> buttons, int x2, int y, Dimension alloc) {
        boolean containsVisibleButton = false;
        for (int i2 = 0; i2 < this._target.getComponentCount(); ++i2) {
            Component component = this._target.getComponent(i2);
            if (!component.isVisible() || !buttons.contains(component)) continue;
            containsVisibleButton = true;
            Dimension preferredSize = component.getPreferredSize();
            int height = preferredSize.height;
            int prefWidth = preferredSize.width;
            component.setBounds(this.shouldKeepPreferredWidth(component) ? alloc.width - prefWidth + x2 : x2, y, this.shouldKeepPreferredWidth(component) ? prefWidth : alloc.width, height);
            y += height + this._buttonGap;
        }
        if (containsVisibleButton) {
            y -= this._buttonGap;
            y += this._groupGap;
        }
        return y;
    }

    private boolean shouldKeepPreferredWidth(Component component) {
        return component instanceof JComponent && Boolean.TRUE.equals(((JComponent)component).getClientProperty("keepPreferredWidth"));
    }

    void checkContainer(Container target) {
        if (this._target != target) {
            throw new AWTError("BorderPaneLayout can't be shared");
        }
        if (!(target instanceof ButtonPanel)) {
            throw new AWTError("Target is not a ButtonPanel");
        }
    }

    int getButtonCountof(List<Component> buttons) {
        int count = 0;
        for (Component button : buttons) {
            if (!button.isVisible()) continue;
            ++count;
        }
        return count;
    }

    void checkRequests() {
        int totalGroup = (this.getButtonCountof(this._affirmativeButtons) == 0 ? 0 : 1) + (this.getButtonCountof(this._otherButtons) == 0 ? 0 : 1) + (this.getButtonCountof(this._cancelButtons) == 0 ? 0 : 1) + (this.getButtonCountof(this._helpButtons) == 0 ? 0 : 1);
        int totalButtonCount = this.getButtonCountof(this._affirmativeButtons) + this.getButtonCountof(this._otherButtons) + this.getButtonCountof(this._cancelButtons) + this.getButtonCountof(this._helpButtons);
        if (this._xChildren == null || this._yChildren == null) {
            int componentCount;
            int visibleComponentCount = componentCount = this._target.getComponentCount();
            for (int i2 = 0; i2 < componentCount; ++i2) {
                if (this._target.getComponent(i2).isVisible()) continue;
                --visibleComponentCount;
            }
            this._xChildren = new SizeRequirements[visibleComponentCount];
            this._yChildren = new SizeRequirements[visibleComponentCount];
            int index = 0;
            for (int i3 = 0; i3 < componentCount; ++i3) {
                Component c2 = this._target.getComponent(i3);
                if (!c2.isVisible()) continue;
                Dimension min = c2.getMinimumSize();
                Dimension typ = c2.getPreferredSize();
                Dimension max = c2.getMaximumSize();
                this._xChildren[index] = new SizeRequirements(min.width, typ.width, max.width, c2.getAlignmentX());
                this._yChildren[index] = new SizeRequirements(min.height, typ.height, max.height, c2.getAlignmentY());
                if (this.shouldKeepPreferredWidth(this._target.getComponent(i3))) {
                    this._xChildren[index].maximum = 0;
                }
                ++index;
            }
            int absoluteAxis = this.resolveAxis(this._axis, this._target.getComponentOrientation());
            if (absoluteAxis == 0) {
                int width;
                this._xTotal = SizeRequirements.getTiledSizeRequirements(this._xChildren);
                this._yTotal = SizeRequirements.getAlignedSizeRequirements(this._yChildren);
                this._maxWidth = SizeRequirements.getAlignedSizeRequirements((SizeRequirements[])this._xChildren).maximum;
                if (this._sizeConstraint == 0) {
                    width = this.getMinButtonWidth();
                    if (this._maxWidth < width) {
                        this._maxWidth = width;
                    }
                    this._minWidth = this._maxWidth;
                } else {
                    width = this.getMinButtonWidth();
                    this._minWidth = width == 0 ? 75 : width;
                }
                for (SizeRequirements sizeRequirements : this._xChildren) {
                    if (sizeRequirements.preferred >= this._minWidth) continue;
                    sizeRequirements.preferred = this._minWidth;
                }
                this._xTotal = SizeRequirements.getTiledSizeRequirements(this._xChildren);
                this._xTotal.preferred += (totalGroup - 1) * this._groupGap + (totalButtonCount - totalGroup) * this._buttonGap;
                this._xTotal.minimum += (totalGroup - 1) * this._groupGap + (totalButtonCount - totalGroup) * this._buttonGap;
            } else {
                this._xTotal = SizeRequirements.getAlignedSizeRequirements(this._xChildren);
                this._yTotal = SizeRequirements.getTiledSizeRequirements(this._yChildren);
                int width = this.getMinButtonWidth();
                this._maxWidth = width == 0 ? 75 : width;
                this._minWidth = this._maxWidth;
                this._xTotal.preferred = this._maxWidth > this._xTotal.maximum ? this._maxWidth : this._xTotal.preferred;
                this._yTotal.preferred += (totalGroup - 1) * this._groupGap + (totalButtonCount - totalGroup) * this._buttonGap;
                this._yTotal.minimum += (totalGroup - 1) * this._groupGap + (totalButtonCount - totalGroup) * this._buttonGap;
            }
        }
    }

    private int resolveAxis(int axis, ComponentOrientation o2) {
        int absoluteAxis = axis == 2 ? (o2.isHorizontal() ? 0 : 1) : (axis == 3 ? (o2.isHorizontal() ? 1 : 0) : axis);
        return absoluteAxis;
    }

    public int getGroupGap() {
        return this._groupGap;
    }

    public void setGroupGap(int groupGap) {
        this._groupGap = groupGap;
        this.invalidateLayout(this._target);
    }

    public int getButtonGap() {
        return this._buttonGap;
    }

    public void setButtonGap(int buttonGap) {
        this._buttonGap = buttonGap;
        this.invalidateLayout(this._target);
    }

    public int getSizeConstraint() {
        return this._sizeConstraint;
    }

    public void setSizeConstraint(int sizeConstraint) {
        this._sizeConstraint = sizeConstraint;
        this.invalidateLayout(this._target);
    }

    public int getMinButtonWidth() {
        return this._minButtonWidth;
    }

    public void setMinButtonWidth(int minButtonWidth) {
        this._minButtonWidth = minButtonWidth;
        this.invalidateLayout(this._target);
    }

    public String getButtonOrder() {
        if (this._buttonOrder == null) {
            return "";
        }
        return this._buttonOrder;
    }

    public void setButtonOrder(String buttonOrder) {
        this._buttonOrder = buttonOrder;
        this.invalidateLayout(this._target);
    }

    public String getOppositeButtonOrder() {
        if (this._oppositeButtonOrder == null) {
            return "";
        }
        return this._oppositeButtonOrder;
    }

    public void setOppositeButtonOrder(String oppositeButtonOrder) {
        this._oppositeButtonOrder = oppositeButtonOrder;
        this.invalidateLayout(this._target);
    }

    public int getAxis() {
        return this._axis;
    }

    public void setAxis(int axis) {
        this._axis = axis;
        this.invalidateLayout(this._target);
    }

    public int getAlignment() {
        return this._alignment;
    }

    public void setAlignment(int alignment) {
        this._alignment = alignment;
        this.invalidateLayout(this._target);
    }

    void resetBounds() {
        for (Component component : this._affirmativeButtons) {
            component.setBounds(0, 0, 0, 0);
        }
        for (Component component : this._cancelButtons) {
            component.setBounds(0, 0, 0, 0);
        }
        for (Component component : this._otherButtons) {
            component.setBounds(0, 0, 0, 0);
        }
        for (Component component : this._helpButtons) {
            component.setBounds(0, 0, 0, 0);
        }
    }
}

