/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;

public class ByteArrayStopEncoding
implements Encoding<byte[]> {
    public static final EncodingID ID = EncodingID.BYTE_ARRAY_STOP;
    private byte stopByte = 0;
    private int externalId;

    public ByteArrayStopEncoding() {
    }

    @Override
    public EncodingID id() {
        return ID;
    }

    public ByteArrayStopEncoding(byte stopByte, int externalId) {
        this.stopByte = stopByte;
        this.externalId = externalId;
    }

    public static EncodingParams toParam(byte stopByte, int externalId) {
        ByteArrayStopEncoding e = new ByteArrayStopEncoding(stopByte, externalId);
        EncodingParams params = new EncodingParams(ID, e.toByteArray());
        return params;
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer buf = ByteBuffer.allocate(1024);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.put(this.stopByte);
        ByteBufferUtils.writeUnsignedITF8(this.externalId, buf);
        buf.flip();
        byte[] array = new byte[buf.limit()];
        buf.get(array);
        return array;
    }

    @Override
    public void fromByteArray(byte[] data) {
        ByteBuffer buf = ByteBuffer.wrap(data);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        this.stopByte = buf.get();
        this.externalId = ByteBufferUtils.readUnsignedITF8(buf);
    }

    @Override
    public BitCodec<byte[]> buildCodec(Map<Integer, InputStream> inputMap, Map<Integer, ExposedByteArrayOutputStream> outputMap) {
        InputStream is = inputMap == null ? null : inputMap.get(this.externalId);
        ExposedByteArrayOutputStream os = outputMap == null ? null : outputMap.get(this.externalId);
        return new ByteArrayStopCodec(this.stopByte, is, os);
    }

    public static class ByteArrayStopCodec
    extends AbstractBitCodec<byte[]> {
        private int stop;
        private InputStream is;
        private OutputStream os;
        private ByteArrayOutputStream readingBAOS = new ByteArrayOutputStream();
        private int b;

        public ByteArrayStopCodec(byte stopByte, InputStream is, OutputStream os) {
            this.stop = 0xFF & stopByte;
            this.is = is;
            this.os = os;
        }

        @Override
        public byte[] read(BitInputStream bis) throws IOException {
            this.readingBAOS.reset();
            while ((this.b = this.is.read()) != -1 && this.b != this.stop) {
                this.readingBAOS.write(this.b);
            }
            return this.readingBAOS.toByteArray();
        }

        @Override
        public byte[] read(BitInputStream bis, int len) throws IOException {
            throw new RuntimeException("Not implemented.");
        }

        @Override
        public long write(BitOutputStream bos, byte[] object) throws IOException {
            this.os.write(object);
            this.os.write(this.stop);
            return object.length + 1;
        }

        @Override
        public long numberOfBits(byte[] object) {
            return object.length + 1;
        }
    }
}

