/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.BitwiseUtils;
import java.io.IOException;
import java.io.OutputStream;

public class DefaultBitOutputStream
extends OutputStream
implements BitOutputStream {
    private static final byte[] bitMasks = new byte[8];
    private final OutputStream out;
    private int bufferByte = 0;
    private int bufferedNumberOfBits = 0;

    public DefaultBitOutputStream(OutputStream delegate) {
        this.out = delegate;
    }

    @Override
    public void write(byte b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(int value) throws IOException {
        this.out.write(value);
    }

    private static final byte[] toBytes(int value) {
        byte[] bytes = new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)(value >>> 0)};
        return bytes;
    }

    public String toString() {
        return "DefaultBitOutputStream: " + BitwiseUtils.toBitString(new byte[]{(byte)this.bufferByte}).substring(0, this.bufferedNumberOfBits);
    }

    @Override
    public void write(long value, int nofBitsToWrite) throws IOException {
        if (nofBitsToWrite == 0) {
            return;
        }
        if (nofBitsToWrite < 1 || nofBitsToWrite > 64) {
            throw new IOException("Expecting 1 to 64 bits, got: value=" + value + ", nofBits=" + nofBitsToWrite);
        }
        if (nofBitsToWrite <= 8) {
            this.write((byte)value, nofBitsToWrite);
        } else {
            for (int i = nofBitsToWrite - 8; i >= 0; i -= 8) {
                byte v = (byte)(value >>> i);
                this.writeByte(v);
            }
            if (nofBitsToWrite % 8 != 0) {
                byte v = (byte)value;
                this.write(v, nofBitsToWrite % 8);
            }
        }
    }

    void write_int_LSB_0(int value, int nofBitsToWrite) throws IOException {
        if (nofBitsToWrite == 0) {
            return;
        }
        if (nofBitsToWrite < 1 || nofBitsToWrite > 32) {
            throw new IOException("Expecting 1 to 32 bits.");
        }
        if (nofBitsToWrite <= 8) {
            this.write((byte)value, nofBitsToWrite);
        } else {
            for (int i = nofBitsToWrite - 8; i >= 0; i -= 8) {
                byte v = (byte)(value >>> i);
                this.writeByte(v);
            }
            if (nofBitsToWrite % 8 != 0) {
                byte v = (byte)value;
                this.write(v, nofBitsToWrite % 8);
            }
        }
    }

    @Override
    public void write(int value, int nofBitsToWrite) throws IOException {
        this.write_int_LSB_0(value, nofBitsToWrite);
    }

    private void writeByte(int value) throws IOException {
        if (this.bufferedNumberOfBits == 0) {
            this.out.write(value);
        } else {
            this.bufferByte = (value & 0xFF) >>> this.bufferedNumberOfBits | this.bufferByte;
            this.out.write(this.bufferByte);
            this.bufferByte = value << 8 - this.bufferedNumberOfBits & 0xFF;
        }
    }

    @Override
    public void write(byte value, int nofBitsToWrite) throws IOException {
        if (nofBitsToWrite < 0 || nofBitsToWrite > 8) {
            throw new IOException("Expecting 0 to 8 bits.");
        }
        if (nofBitsToWrite == 8) {
            this.writeByte(value);
        } else if (this.bufferedNumberOfBits == 0) {
            this.bufferByte = value << 8 - nofBitsToWrite & 0xFF;
            this.bufferedNumberOfBits = nofBitsToWrite;
        } else {
            value = (byte)(value & ~bitMasks[8 - nofBitsToWrite]);
            int bits = 8 - this.bufferedNumberOfBits - nofBitsToWrite;
            if (bits < 0) {
                bits = -bits;
                this.bufferByte |= value >>> bits;
                this.out.write(this.bufferByte);
                this.bufferByte = value << 8 - bits & 0xFF;
                this.bufferedNumberOfBits = bits;
            } else if (bits == 0) {
                this.bufferByte |= value;
                this.out.write(this.bufferByte);
                this.bufferedNumberOfBits = 0;
            } else {
                this.bufferByte |= value << bits;
                this.bufferedNumberOfBits = 8 - bits;
            }
        }
    }

    @Override
    public void write(boolean bit) throws IOException {
        this.write(bit ? (byte)1 : 0, 1);
    }

    @Override
    public void write(boolean bit, long repeat) throws IOException {
        for (long i = 0L; i < repeat; ++i) {
            this.write(bit);
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        if (this.bufferedNumberOfBits > 0) {
            this.out.write(this.bufferByte);
        }
        this.bufferedNumberOfBits = 0;
        this.out.flush();
    }

    public OutputStream getDelegate() {
        return this.out;
    }

    @Override
    public int alignToByte() throws IOException {
        int bitsFlushed = this.bufferedNumberOfBits;
        if (this.bufferedNumberOfBits > 0) {
            this.out.write(this.bufferByte);
        }
        this.bufferedNumberOfBits = 0;
        this.bufferByte = 0;
        return bitsFlushed;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    static {
        for (int i = 0; i < 8; i = (int)((byte)(i + 1))) {
            DefaultBitOutputStream.bitMasks[i] = (byte)(~(255 >>> i));
        }
    }
}

