/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.StrongConnectivityInspector;
import org.jgrapht.traverse.DepthFirstIterator;

public class CycleDetector<V, E> {
    DirectedGraph<V, E> graph;

    public CycleDetector(DirectedGraph<V, E> directedGraph) {
        this.graph = directedGraph;
    }

    public boolean detectCycles() {
        try {
            this.execute(null, null);
        }
        catch (CycleDetectedException cycleDetectedException) {
            return true;
        }
        return false;
    }

    public boolean detectCyclesContainingVertex(V v2) {
        try {
            this.execute(null, v2);
        }
        catch (CycleDetectedException cycleDetectedException) {
            return true;
        }
        return false;
    }

    public Set<V> findCycles() {
        StrongConnectivityInspector<V, E> strongConnectivityInspector = new StrongConnectivityInspector<V, E>(this.graph);
        List<Set<V>> list = strongConnectivityInspector.stronglyConnectedSets();
        HashSet<V> hashSet = new HashSet<V>();
        for (Set<V> set : list) {
            if (set.size() > 1) {
                hashSet.addAll(set);
                continue;
            }
            V v2 = set.iterator().next();
            if (!this.graph.containsEdge(v2, v2)) continue;
            hashSet.add(v2);
        }
        return hashSet;
    }

    public Set<V> findCyclesContainingVertex(V v2) {
        HashSet hashSet = new HashSet();
        this.execute(hashSet, v2);
        return hashSet;
    }

    private void execute(Set<V> set, V v2) {
        ProbeIterator probeIterator = new ProbeIterator(set, v2);
        while (probeIterator.hasNext()) {
            probeIterator.next();
        }
    }

    private class ProbeIterator
    extends DepthFirstIterator<V, E> {
        private List<V> path;
        private Set<V> cycleSet;
        private V root;

        ProbeIterator(Set<V> set, V v2) {
            super(CycleDetector.this.graph, v2);
            this.root = v2;
            this.cycleSet = set;
            this.path = new ArrayList();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void encounterVertexAgain(V v2, E e2) {
            int n2;
            super.encounterVertexAgain(v2, e2);
            if (this.root != null) {
                if (v2.equals(this.root)) {
                    n2 = 0;
                } else {
                    if (this.cycleSet == null || !this.cycleSet.contains(v2)) return;
                    n2 = 0;
                }
            } else {
                n2 = this.path.indexOf(v2);
            }
            if (n2 <= -1) return;
            if (this.cycleSet == null) {
                throw new CycleDetectedException();
            }
            while (n2 < this.path.size()) {
                this.cycleSet.add(this.path.get(n2));
                ++n2;
            }
        }

        @Override
        protected V provideNextVertex() {
            Object v2 = super.provideNextVertex();
            for (int i2 = this.path.size() - 1; i2 >= 0 && !CycleDetector.this.graph.containsEdge(this.path.get(i2), v2); --i2) {
                this.path.remove(i2);
            }
            this.path.add(v2);
            return v2;
        }
    }

    private static class CycleDetectedException
    extends RuntimeException {
        private static final long serialVersionUID = 3834305137802950712L;

        private CycleDetectedException() {
        }
    }
}

