/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.converters;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.data.seg.Segment;

public class IlluminaToCN {
    static int probeIdCol = 1;
    static int chrCol = 3;
    static int posCol = 4;
    static int preColCount = 10;
    static int sampleColumnCount = 16;
    static int cnvOffset = 5;
    static int logROffset = 7;
    static int afOffset = 8;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void convertFile(String iFile, String oFilePrefix) {
        block28: {
            PrintWriter afWriter;
            PrintWriter logRWriter;
            PrintWriter cnvWriter;
            BufferedReader reader;
            block26: {
                reader = null;
                cnvWriter = null;
                logRWriter = null;
                afWriter = null;
                LinkedHashMap<String, ArrayList<Segment>> cnvSegments = new LinkedHashMap<String, ArrayList<Segment>>();
                reader = new BufferedReader(new FileReader(iFile));
                cnvWriter = new PrintWriter(new BufferedWriter(new FileWriter(oFilePrefix + ".cnv.cn")));
                logRWriter = new PrintWriter(new BufferedWriter(new FileWriter(oFilePrefix + ".logr.cn")));
                afWriter = new PrintWriter(new BufferedWriter(new FileWriter(oFilePrefix + ".af.cn")));
                List<PrintWriter> allWriters = Arrays.asList(logRWriter, afWriter);
                String nextLine = reader.readLine();
                List<String> samples = IlluminaToCN.getSamples(nextLine);
                for (PrintWriter pw : allWriters) {
                    pw.print("Probe\tChr\tPosition");
                    for (String s2 : samples) {
                        pw.print("\t" + s2);
                    }
                    pw.println();
                }
                cnvWriter.println("Sample\tchr\tstart\tend\tnumberOfSnps");
                HashMap<String, Segment> currentSegments = new HashMap<String, Segment>();
                while ((nextLine = reader.readLine()) != null) {
                    String[] tokens = nextLine.split("\t");
                    String probe = tokens[probeIdCol];
                    String chr = "chr" + tokens[chrCol];
                    int position = Integer.parseInt(tokens[posCol]);
                    for (PrintWriter pw : allWriters) {
                        pw.print(probe + "\t" + chr + "\t" + position);
                    }
                    int col = preColCount - 1;
                    for (int i2 = 0; i2 < samples.size(); ++i2) {
                        String sample = samples.get(i2);
                        int cnv = (int)Float.parseFloat(tokens[col + cnvOffset]);
                        Segment segment = (Segment)currentSegments.get(sample);
                        if (segment == null || !chr.equals(segment.getChr()) || cnv == (int)segment.getScore()) {
                            if (segment != null) {
                                ArrayList<Segment> segs = (ArrayList<Segment>)cnvSegments.get(sample);
                                if (segs == null) {
                                    segs = new ArrayList<Segment>();
                                    cnvSegments.put(sample, segs);
                                }
                                segs.add(segment);
                            }
                            segment = new Segment(position, position, cnv);
                            currentSegments.put(sample, segment);
                        } else {
                            segment.setEnd(position);
                        }
                        String logR = tokens[col + logROffset];
                        logRWriter.print("\t" + logR);
                        String af = tokens[col + afOffset];
                        afWriter.print("\t" + af);
                        col += sampleColumnCount;
                    }
                    for (PrintWriter pw : allWriters) {
                        pw.println();
                    }
                }
                for (Map.Entry entry : cnvSegments.entrySet()) {
                    String sample = (String)entry.getKey();
                    for (Segment segment : (List)entry.getValue()) {
                        cnvWriter.println(sample + "\t" + segment.getChr() + "\t" + segment.getStart() + "\t" + segment.getEnd() + "\t" + "" + "\t" + (int)segment.getScore());
                    }
                }
                if (reader == null) break block26;
                try {
                    reader.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
            for (PrintWriter pw : Arrays.asList(cnvWriter, logRWriter, afWriter)) {
                if (pw == null) continue;
                pw.close();
            }
            break block28;
            catch (IOException e3) {
                block27: {
                    e3.printStackTrace();
                    if (reader == null) break block27;
                    try {
                        reader.close();
                    }
                    catch (IOException e4) {
                        // empty catch block
                    }
                }
                for (PrintWriter pw : Arrays.asList(cnvWriter, logRWriter, afWriter)) {
                    if (pw == null) continue;
                    pw.close();
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e5) {
                            // empty catch block
                        }
                    }
                    for (PrintWriter pw : Arrays.asList(cnvWriter, logRWriter, afWriter)) {
                        if (pw == null) continue;
                        pw.close();
                    }
                    throw throwable;
                }
            }
        }
    }

    private static List<String> getSamples(String nextLine) {
        String[] tokens = nextLine.split("\t");
        ArrayList<String> samples = new ArrayList<String>();
        for (int col = preColCount; col < tokens.length - 1; col += sampleColumnCount) {
            samples.add(tokens[col].replace(".GType", ""));
        }
        return samples;
    }

    public static void main(String[] args) {
        String ifile = "/Users/jrobinso/IGV/maggie/FullDataTable2.txt";
        String oFilePre = "/Users/jrobinso/IGV/maggie/smallDataTable";
        IlluminaToCN.convertFile(ifile, oFilePre);
    }
}

