/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERTaggedObject;

public class DERExternal
extends ASN1Primitive {
    private ASN1ObjectIdentifier directReference;
    private ASN1Integer indirectReference;
    private ASN1Primitive dataValueDescriptor;
    private int encoding;
    private ASN1Primitive externalContent;

    public DERExternal(ASN1EncodableVector vector) {
        int offset = 0;
        ASN1Primitive enc = this.getObjFromVector(vector, offset);
        if (enc instanceof ASN1ObjectIdentifier) {
            this.directReference = (ASN1ObjectIdentifier)enc;
            enc = this.getObjFromVector(vector, ++offset);
        }
        if (enc instanceof ASN1Integer) {
            this.indirectReference = (ASN1Integer)enc;
            enc = this.getObjFromVector(vector, ++offset);
        }
        if (!(enc instanceof DERTaggedObject)) {
            this.dataValueDescriptor = enc;
            enc = this.getObjFromVector(vector, ++offset);
        }
        if (vector.size() != offset + 1) {
            throw new IllegalArgumentException("input vector too large");
        }
        if (!(enc instanceof DERTaggedObject)) {
            throw new IllegalArgumentException("No tagged object found in vector. Structure doesn't seem to be of type External");
        }
        DERTaggedObject obj = (DERTaggedObject)enc;
        this.setEncoding(obj.getTagNo());
        this.externalContent = obj.getObject();
    }

    private ASN1Primitive getObjFromVector(ASN1EncodableVector v2, int index) {
        if (v2.size() <= index) {
            throw new IllegalArgumentException("too few objects in input vector");
        }
        return v2.get(index).toASN1Primitive();
    }

    public DERExternal(ASN1ObjectIdentifier directReference, ASN1Integer indirectReference, ASN1Primitive dataValueDescriptor, DERTaggedObject externalData) {
        this(directReference, indirectReference, dataValueDescriptor, externalData.getTagNo(), externalData.toASN1Primitive());
    }

    public DERExternal(ASN1ObjectIdentifier directReference, ASN1Integer indirectReference, ASN1Primitive dataValueDescriptor, int encoding, ASN1Primitive externalData) {
        this.setDirectReference(directReference);
        this.setIndirectReference(indirectReference);
        this.setDataValueDescriptor(dataValueDescriptor);
        this.setEncoding(encoding);
        this.setExternalContent(externalData.toASN1Primitive());
    }

    public int hashCode() {
        int ret = 0;
        if (this.directReference != null) {
            ret = this.directReference.hashCode();
        }
        if (this.indirectReference != null) {
            ret ^= this.indirectReference.hashCode();
        }
        if (this.dataValueDescriptor != null) {
            ret ^= this.dataValueDescriptor.hashCode();
        }
        return ret ^= this.externalContent.hashCode();
    }

    boolean isConstructed() {
        return true;
    }

    int encodedLength() throws IOException {
        return this.getEncoded().length;
    }

    void encode(ASN1OutputStream out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.directReference != null) {
            baos.write(this.directReference.getEncoded("DER"));
        }
        if (this.indirectReference != null) {
            baos.write(this.indirectReference.getEncoded("DER"));
        }
        if (this.dataValueDescriptor != null) {
            baos.write(this.dataValueDescriptor.getEncoded("DER"));
        }
        DERTaggedObject obj = new DERTaggedObject(true, this.encoding, this.externalContent);
        baos.write(obj.getEncoded("DER"));
        out.writeEncoded(32, 8, baos.toByteArray());
    }

    boolean asn1Equals(ASN1Primitive o2) {
        if (!(o2 instanceof DERExternal)) {
            return false;
        }
        if (this == o2) {
            return true;
        }
        DERExternal other = (DERExternal)o2;
        if (!(this.directReference == null || other.directReference != null && other.directReference.equals(this.directReference))) {
            return false;
        }
        if (!(this.indirectReference == null || other.indirectReference != null && other.indirectReference.equals(this.indirectReference))) {
            return false;
        }
        if (!(this.dataValueDescriptor == null || other.dataValueDescriptor != null && other.dataValueDescriptor.equals(this.dataValueDescriptor))) {
            return false;
        }
        return this.externalContent.equals(other.externalContent);
    }

    public ASN1Primitive getDataValueDescriptor() {
        return this.dataValueDescriptor;
    }

    public ASN1ObjectIdentifier getDirectReference() {
        return this.directReference;
    }

    public int getEncoding() {
        return this.encoding;
    }

    public ASN1Primitive getExternalContent() {
        return this.externalContent;
    }

    public ASN1Integer getIndirectReference() {
        return this.indirectReference;
    }

    private void setDataValueDescriptor(ASN1Primitive dataValueDescriptor) {
        this.dataValueDescriptor = dataValueDescriptor;
    }

    private void setDirectReference(ASN1ObjectIdentifier directReferemce) {
        this.directReference = directReferemce;
    }

    private void setEncoding(int encoding) {
        if (encoding < 0 || encoding > 2) {
            throw new IllegalArgumentException("invalid encoding value: " + encoding);
        }
        this.encoding = encoding;
    }

    private void setExternalContent(ASN1Primitive externalContent) {
        this.externalContent = externalContent;
    }

    private void setIndirectReference(ASN1Integer indirectReference) {
        this.indirectReference = indirectReference;
    }
}

