/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;

public class BEROctetString
extends ASN1OctetString {
    private static final int MAX_LENGTH = 1000;
    private ASN1OctetString[] octs;

    private static byte[] toBytes(ASN1OctetString[] octs) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        for (int i2 = 0; i2 != octs.length; ++i2) {
            try {
                DEROctetString o2 = (DEROctetString)octs[i2];
                bOut.write(o2.getOctets());
                continue;
            }
            catch (ClassCastException e2) {
                throw new IllegalArgumentException(octs[i2].getClass().getName() + " found in input should only contain DEROctetString");
            }
            catch (IOException e3) {
                throw new IllegalArgumentException("exception converting octets " + e3.toString());
            }
        }
        return bOut.toByteArray();
    }

    public BEROctetString(byte[] string) {
        super(string);
    }

    public BEROctetString(ASN1OctetString[] octs) {
        super(BEROctetString.toBytes(octs));
        this.octs = octs;
    }

    public byte[] getOctets() {
        return this.string;
    }

    public Enumeration getObjects() {
        if (this.octs == null) {
            return this.generateOcts().elements();
        }
        return new Enumeration(){
            int counter = 0;

            public boolean hasMoreElements() {
                return this.counter < BEROctetString.this.octs.length;
            }

            public Object nextElement() {
                return BEROctetString.this.octs[this.counter++];
            }
        };
    }

    private Vector generateOcts() {
        Vector<DEROctetString> vec = new Vector<DEROctetString>();
        for (int i2 = 0; i2 < this.string.length; i2 += 1000) {
            int end = i2 + 1000 > this.string.length ? this.string.length : i2 + 1000;
            byte[] nStr = new byte[end - i2];
            System.arraycopy(this.string, i2, nStr, 0, nStr.length);
            vec.addElement(new DEROctetString(nStr));
        }
        return vec;
    }

    boolean isConstructed() {
        return true;
    }

    int encodedLength() throws IOException {
        int length = 0;
        Enumeration e2 = this.getObjects();
        while (e2.hasMoreElements()) {
            length += ((ASN1Encodable)e2.nextElement()).toASN1Primitive().encodedLength();
        }
        return 2 + length + 2;
    }

    public void encode(ASN1OutputStream out) throws IOException {
        out.write(36);
        out.write(128);
        Enumeration e2 = this.getObjects();
        while (e2.hasMoreElements()) {
            out.writeObject((ASN1Encodable)e2.nextElement());
        }
        out.write(0);
        out.write(0);
    }

    static BEROctetString fromSequence(ASN1Sequence seq) {
        ASN1OctetString[] v2 = new ASN1OctetString[seq.size()];
        Enumeration e2 = seq.getObjects();
        int index = 0;
        while (e2.hasMoreElements()) {
            v2[index++] = (ASN1OctetString)e2.nextElement();
        }
        return new BEROctetString(v2);
    }
}

