/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import htsjdk.samtools.util.Lazy;
import htsjdk.tribble.TribbleException;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.JEXLMap;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.vcf.VCFCompoundHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlEngine;

public class VariantContextUtils {
    private static Set<String> MISSING_KEYS_WARNED_ABOUT = new HashSet<String>();
    public static final Lazy<JexlEngine> engine = new Lazy<JexlEngine>(new Lazy.LazyInitializer<JexlEngine>(){

        @Override
        public JexlEngine make() {
            JexlEngine jexl = new JexlEngine();
            jexl.setSilent(false);
            jexl.setLenient(false);
            jexl.setDebug(false);
            return jexl;
        }
    });
    private static final boolean ASSUME_MISSING_FIELDS_ARE_STRINGS = false;

    public static double calculateAltAlleleFrequency(VariantContext vc) {
        double totalCount;
        if (!vc.hasAttribute("AN") || !vc.hasAttribute("AC")) {
            throw new AssertionError((Object)String.format("Cannot compute the provided variant's alt allele frequency because it does not have both %s and %s annotations: %s", "AN", "AC", vc));
        }
        double altAlleleCount = vc.getAttributeAsInt("AC", 0);
        double aaf = altAlleleCount / (totalCount = (double)vc.getAttributeAsInt("AN", 0));
        if (aaf > 1.0 || aaf < 0.0) {
            throw new AssertionError((Object)String.format("Expected a minor allele frequency in the range [0, 1], but got %s. vc=%s", aaf, vc));
        }
        return aaf;
    }

    public static Map<String, Object> calculateChromosomeCounts(VariantContext vc, Map<String, Object> attributes, boolean removeStaleValues) {
        return VariantContextUtils.calculateChromosomeCounts(vc, attributes, removeStaleValues, new HashSet<String>(0));
    }

    public static Map<String, Object> calculateChromosomeCounts(VariantContext vc, Map<String, Object> attributes, boolean removeStaleValues, Set<String> founderIds) {
        int AN = vc.getCalledChrCount();
        if (AN == 0 && removeStaleValues) {
            if (attributes.containsKey("AC")) {
                attributes.remove("AC");
            }
            if (attributes.containsKey("AF")) {
                attributes.remove("AF");
            }
            if (attributes.containsKey("AN")) {
                attributes.remove("AN");
            }
            return attributes;
        }
        if (vc.hasGenotypes()) {
            attributes.put("AN", AN);
            if (vc.getAlternateAlleles().size() > 0) {
                ArrayList<Double> alleleFreqs = new ArrayList<Double>();
                ArrayList<Integer> alleleCounts = new ArrayList<Integer>();
                ArrayList<Integer> foundersAlleleCounts = new ArrayList<Integer>();
                double totalFoundersChromosomes = vc.getCalledChrCount(founderIds);
                for (Allele allele : vc.getAlternateAlleles()) {
                    int foundersAltChromosomes = vc.getCalledChrCount(allele, founderIds);
                    alleleCounts.add(vc.getCalledChrCount(allele));
                    foundersAlleleCounts.add(foundersAltChromosomes);
                    if (AN == 0) {
                        alleleFreqs.add(0.0);
                        continue;
                    }
                    Double freq = (double)foundersAltChromosomes / totalFoundersChromosomes;
                    alleleFreqs.add(freq);
                }
                attributes.put("AC", alleleCounts.size() == 1 ? (Serializable)alleleCounts.get(0) : alleleCounts);
                attributes.put("AF", alleleFreqs.size() == 1 ? (Serializable)alleleFreqs.get(0) : alleleFreqs);
            } else {
                attributes.remove("AC");
                attributes.remove("AF");
            }
        }
        return attributes;
    }

    public static void calculateChromosomeCounts(VariantContextBuilder builder, boolean removeStaleValues) {
        VariantContext vc = builder.make();
        builder.attributes(VariantContextUtils.calculateChromosomeCounts(vc, new HashMap<String, Object>(vc.getAttributes()), removeStaleValues, new HashSet<String>(0)));
    }

    public static void calculateChromosomeCounts(VariantContextBuilder builder, boolean removeStaleValues, Set<String> founderIds) {
        VariantContext vc = builder.make();
        builder.attributes(VariantContextUtils.calculateChromosomeCounts(vc, new HashMap<String, Object>(vc.getAttributes()), removeStaleValues, founderIds));
    }

    public static final VCFCompoundHeaderLine getMetaDataForField(VCFHeader header, String field) {
        VCFCompoundHeaderLine metaData = header.getFormatHeaderLine(field);
        if (metaData == null) {
            metaData = header.getInfoHeaderLine(field);
        }
        if (metaData == null) {
            throw new TribbleException("Fully decoding VariantContext requires header line for all fields, but none was found for " + field);
        }
        return metaData;
    }

    public static List<JexlVCMatchExp> initializeMatchExps(String[] names, String[] exps) {
        if (names == null || exps == null) {
            throw new IllegalArgumentException("BUG: neither names nor exps can be null: names " + Arrays.toString(names) + " exps=" + Arrays.toString(exps));
        }
        if (names.length != exps.length) {
            throw new IllegalArgumentException("Inconsistent number of provided filter names and expressions: names=" + Arrays.toString(names) + " exps=" + Arrays.toString(exps));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i2 = 0; i2 < names.length; ++i2) {
            map.put(names[i2], exps[i2]);
        }
        return VariantContextUtils.initializeMatchExps(map);
    }

    public static List<JexlVCMatchExp> initializeMatchExps(ArrayList<String> names, ArrayList<String> exps) {
        String[] nameArray = new String[names.size()];
        String[] expArray = new String[exps.size()];
        return VariantContextUtils.initializeMatchExps(names.toArray(nameArray), exps.toArray(expArray));
    }

    public static List<JexlVCMatchExp> initializeMatchExps(Map<String, String> names_and_exps) {
        ArrayList<JexlVCMatchExp> exps = new ArrayList<JexlVCMatchExp>();
        for (Map.Entry<String, String> elt : names_and_exps.entrySet()) {
            String name = elt.getKey();
            String expStr = elt.getValue();
            if (name == null || expStr == null) {
                throw new IllegalArgumentException("Cannot create null expressions : " + name + " " + expStr);
            }
            try {
                Expression exp = engine.get().createExpression(expStr);
                exps.add(new JexlVCMatchExp(name, exp));
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("Argument " + name + "has a bad value. Invalid expression used (" + expStr + "). Please see the JEXL docs for correct syntax.");
            }
        }
        return exps;
    }

    public static boolean match(VariantContext vc, JexlVCMatchExp exp) {
        return VariantContextUtils.match(vc, Arrays.asList(exp)).get(exp);
    }

    public static Map<JexlVCMatchExp, Boolean> match(VariantContext vc, Collection<JexlVCMatchExp> exps) {
        return new JEXLMap(exps, vc);
    }

    public static boolean match(VariantContext vc, Genotype g2, JexlVCMatchExp exp) {
        return VariantContextUtils.match(vc, g2, Arrays.asList(exp)).get(exp);
    }

    public static Map<JexlVCMatchExp, Boolean> match(VariantContext vc, Genotype g2, Collection<JexlVCMatchExp> exps) {
        return new JEXLMap(exps, vc, g2);
    }

    public static VariantContext sitesOnlyVariantContext(VariantContext vc) {
        return new VariantContextBuilder(vc).noGenotypes().make();
    }

    public static Collection<VariantContext> sitesOnlyVariantContexts(Collection<VariantContext> vcs) {
        ArrayList<VariantContext> r2 = new ArrayList<VariantContext>();
        for (VariantContext vc : vcs) {
            r2.add(VariantContextUtils.sitesOnlyVariantContext(vc));
        }
        return r2;
    }

    public static int getSize(VariantContext vc) {
        return vc.getEnd() - vc.getStart() + 1;
    }

    public static Set<String> genotypeNames(Collection<Genotype> genotypes) {
        HashSet<String> names = new HashSet<String>(genotypes.size());
        for (Genotype g2 : genotypes) {
            names.add(g2.getSampleName());
        }
        return names;
    }

    public static int computeEndFromAlleles(List<Allele> alleles, int start, int endForSymbolicAlleles) {
        Allele ref = alleles.get(0);
        if (ref.isNonReference()) {
            throw new IllegalStateException("computeEndFromAlleles requires first allele to be reference");
        }
        if (VariantContext.hasSymbolicAlleles(alleles)) {
            if (endForSymbolicAlleles == -1) {
                throw new IllegalStateException("computeEndFromAlleles found a symbolic allele but endForSymbolicAlleles was provided");
            }
            return endForSymbolicAlleles;
        }
        return start + Math.max(ref.length() - 1, 0);
    }

    public static class JexlVCMatchExp {
        public String name;
        public Expression exp;

        public JexlVCMatchExp(String name, Expression exp) {
            this.name = name;
            this.exp = exp;
        }
    }
}

