/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.ref;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.reference.FastaSequenceIndex;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SequenceUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ReferenceSource {
    private static Log log = Log.getInstance(ReferenceSource.class);
    private ReferenceSequenceFile rsFile;
    private FastaSequenceIndex fastaSequenceIndex;
    private int downloadTriesBeforeFailing = 2;
    private Map<String, WeakReference<byte[]>> cacheW = new HashMap<String, WeakReference<byte[]>>();
    private static final Pattern chrPattern = Pattern.compile("chr.*", 2);

    public ReferenceSource() {
    }

    public ReferenceSource(File file) {
        if (file != null) {
            this.rsFile = ReferenceSequenceFileFactory.getReferenceSequenceFile(file);
            File indexFile = new File(file.getAbsoluteFile() + ".fai");
            if (indexFile.exists()) {
                this.fastaSequenceIndex = new FastaSequenceIndex(indexFile);
            }
        }
    }

    public ReferenceSource(ReferenceSequenceFile rsFile) {
        this.rsFile = rsFile;
    }

    public void clearCache() {
        this.cacheW.clear();
    }

    private byte[] findInCache(String name) {
        byte[] bytes;
        WeakReference<byte[]> r2 = this.cacheW.get(name);
        if (r2 != null && (bytes = (byte[])r2.get()) != null) {
            return bytes;
        }
        return null;
    }

    public synchronized byte[] getReferenceBases(SAMSequenceRecord record, boolean tryNameVariants) {
        String name = record.getSequenceName();
        byte[] bases = this.findInCache(name);
        if (bases != null) {
            return bases;
        }
        String md5 = record.getAttribute("M5");
        if (md5 != null && (bases = this.findInCache(md5)) != null) {
            return bases;
        }
        bases = this.findBasesByName(record.getSequenceName(), tryNameVariants);
        if (bases != null) {
            SequenceUtil.upperCase(bases);
            this.cacheW.put(record.getSequenceName(), new WeakReference<byte[]>(bases));
            return bases;
        }
        if (md5 != null) {
            try {
                bases = this.findBasesByMD5(md5);
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
        if (bases != null) {
            SequenceUtil.upperCase(bases);
            this.cacheW.put(md5, new WeakReference<byte[]>(bases));
            return bases;
        }
        return null;
    }

    protected byte[] findBasesByName(String name, boolean tryVariants) {
        if (this.rsFile == null || !this.rsFile.isIndexed()) {
            return null;
        }
        ReferenceSequence sequence = null;
        if (this.fastaSequenceIndex != null) {
            sequence = this.fastaSequenceIndex.hasIndexEntry(name) ? this.rsFile.getSequence(name) : null;
        }
        if (sequence != null) {
            return sequence.getBases();
        }
        sequence = this.rsFile.getSequence(name);
        if (sequence != null) {
            return sequence.getBases();
        }
        if (tryVariants) {
            for (String variant : this.getVariants(name)) {
                try {
                    sequence = this.rsFile.getSequence(variant);
                }
                catch (SAMException e2) {
                    log.warn("Sequence not found: " + variant);
                }
                if (sequence == null) continue;
                return sequence.getBases();
            }
        }
        return null;
    }

    protected byte[] findBasesByMD5(String md5) throws MalformedURLException, IOException {
        String url = String.format(Defaults.EBI_REFERENCE_SEVICE_URL_MASK, md5);
        for (int i2 = 0; i2 < this.downloadTriesBeforeFailing; ++i2) {
            InputStream is = new URL(url).openStream();
            if (is == null) {
                return null;
            }
            log.debug("Downloading reference sequence: " + url);
            byte[] data = ByteBufferUtils.readFully(is);
            log.debug("Downloaded " + data.length + " bytes for md5 " + md5);
            is.close();
            try {
                String downloadedMD5 = SequenceUtil.calculateMD5String(data);
                if (md5.equals(downloadedMD5)) {
                    return data;
                }
                String message = String.format("Downloaded sequence is corrupt: requested md5=%s, received md5=%s", md5, downloadedMD5);
                log.error(message);
                continue;
            }
            catch (NoSuchAlgorithmException e2) {
                throw new RuntimeException(e2);
            }
        }
        throw new RuntimeException("Giving up on downloading sequence for md5 " + md5);
    }

    protected List<String> getVariants(String name) {
        boolean chrPatternMatch;
        ArrayList<String> variants = new ArrayList<String>();
        if (name.equals("M")) {
            variants.add("MT");
        }
        if (name.equals("MT")) {
            variants.add("M");
        }
        if (chrPatternMatch = chrPattern.matcher(name).matches()) {
            variants.add(name.substring(3));
        } else {
            variants.add("chr" + name);
        }
        if ("chrM".equals(name)) {
            variants.add("MT");
        }
        return variants;
    }

    public int getDownloadTriesBeforeFailing() {
        return this.downloadTriesBeforeFailing;
    }

    public void setDownloadTriesBeforeFailing(int downloadTriesBeforeFailing) {
        this.downloadTriesBeforeFailing = downloadTriesBeforeFailing;
    }
}

