/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.lossy;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.cram.encoding.read_features.BaseQualityScore;
import htsjdk.samtools.cram.encoding.read_features.ReadFeature;
import htsjdk.samtools.cram.lossy.BaseCategory;
import htsjdk.samtools.cram.lossy.BaseCategoryType;
import htsjdk.samtools.cram.lossy.Binning;
import htsjdk.samtools.cram.lossy.PreservationPolicy;
import htsjdk.samtools.cram.lossy.QualityScoreTreatment;
import htsjdk.samtools.cram.lossy.ReadCategory;
import htsjdk.samtools.cram.ref.ReferenceTracks;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class QualityScorePreservation {
    private String specification;
    private List<PreservationPolicy> policyList;
    private static final Comparator<ReadFeature> readFeaturePositionComparator = new Comparator<ReadFeature>(){

        @Override
        public int compare(ReadFeature o1, ReadFeature o2) {
            return o1.getPosition() - o2.getPosition();
        }
    };

    public QualityScorePreservation(String specification) {
        this.specification = specification;
        this.policyList = QualityScorePreservation.parsePolicies(specification);
    }

    public List<PreservationPolicy> getPreservationPolicies() {
        return this.policyList;
    }

    private static final int readParam(LinkedList<Character> list) {
        int value = 0;
        while (!list.isEmpty() && Character.isDigit(list.getFirst().charValue())) {
            value = value * 10 + (list.removeFirst().charValue() - 48);
        }
        return value;
    }

    private static final QualityScoreTreatment readTreament(LinkedList<Character> list) {
        QualityScoreTreatment t2;
        int param = QualityScorePreservation.readParam(list);
        switch (param) {
            case 0: {
                t2 = QualityScoreTreatment.drop();
                break;
            }
            case 40: {
                t2 = QualityScoreTreatment.preserve();
                break;
            }
            default: {
                t2 = QualityScoreTreatment.bin(param);
            }
        }
        return t2;
    }

    public static final List<PreservationPolicy> parsePolicies(String spec) {
        ArrayList<PreservationPolicy> policyList = new ArrayList<PreservationPolicy>();
        for (String s2 : spec.split("-")) {
            if (s2.length() == 0) continue;
            PreservationPolicy policy = QualityScorePreservation.parseSinglePolicy(s2);
            policyList.add(policy);
        }
        Collections.sort(policyList, new Comparator<PreservationPolicy>(){

            @Override
            public int compare(PreservationPolicy o1, PreservationPolicy o2) {
                QualityScoreTreatment t1 = o1.treatment;
                QualityScoreTreatment t2 = o2.treatment;
                int result = t2.type.ordinal() - t1.type.ordinal();
                if (result != 0) {
                    return result;
                }
                return 0;
            }
        });
        return policyList;
    }

    private static final PreservationPolicy parseSinglePolicy(String spec) {
        PreservationPolicy p2 = new PreservationPolicy();
        LinkedList<Character> list = new LinkedList<Character>();
        for (char b2 : spec.toCharArray()) {
            list.add(Character.valueOf(b2));
        }
        while (!list.isEmpty()) {
            char code = ((Character)list.removeFirst()).charValue();
            switch (code) {
                case 'R': {
                    p2.baseCategories.add(BaseCategory.match());
                    p2.treatment = QualityScorePreservation.readTreament(list);
                    break;
                }
                case 'N': {
                    p2.baseCategories.add(BaseCategory.mismatch());
                    p2.treatment = QualityScorePreservation.readTreament(list);
                    break;
                }
                case 'X': {
                    int coverage = QualityScorePreservation.readParam(list);
                    p2.baseCategories.add(BaseCategory.lower_than_coverage(coverage));
                    break;
                }
                case 'D': {
                    p2.baseCategories.add(BaseCategory.flanking_deletion());
                    p2.treatment = QualityScorePreservation.readTreament(list);
                    break;
                }
                case 'M': {
                    int score = QualityScorePreservation.readParam(list);
                    p2.readCategory = ReadCategory.higher_than_mapping_score(score);
                    break;
                }
                case 'm': {
                    int score = QualityScorePreservation.readParam(list);
                    p2.readCategory = ReadCategory.lower_than_mapping_score(score);
                    break;
                }
                case 'U': {
                    p2.readCategory = ReadCategory.unplaced();
                    p2.treatment = QualityScorePreservation.readTreament(list);
                    break;
                }
                case 'P': {
                    int mismatches = QualityScorePreservation.readParam(list);
                    p2.baseCategories.add(BaseCategory.pileup(mismatches));
                    p2.treatment = QualityScorePreservation.readTreament(list);
                    break;
                }
                case 'I': {
                    p2.baseCategories.add(BaseCategory.insertion());
                    p2.treatment = QualityScorePreservation.readTreament(list);
                    break;
                }
                case '_': {
                    p2.treatment = QualityScorePreservation.readTreament(list);
                    break;
                }
                case '*': {
                    p2.readCategory = ReadCategory.all();
                    p2.treatment = QualityScorePreservation.readTreament(list);
                    break;
                }
                default: {
                    throw new RuntimeException("Uknown read or base category: " + code);
                }
            }
            if (p2.treatment != null) continue;
            p2.treatment = QualityScoreTreatment.preserve();
        }
        return p2;
    }

    public static final void applyBinning(byte[] scores) {
        for (int i2 = 0; i2 < scores.length; ++i2) {
            scores[i2] = Binning.Illumina_binning_matrix[scores[i2]];
        }
    }

    public static final byte applyTreatment(byte score, QualityScoreTreatment t2) {
        switch (t2.type) {
            case BIN: {
                return Binning.Illumina_binning_matrix[score];
            }
            case DROP: {
                return -1;
            }
            case PRESERVE: {
                return score;
            }
        }
        throw new RuntimeException("Unknown quality score treatment type: " + t2.type.name());
    }

    public void addQualityScores(SAMRecord s2, CramCompressionRecord r2, ReferenceTracks t2) {
        if (s2.getBaseQualities() == SAMRecord.NULL_QUALS) {
            r2.qualityScores = SAMRecord.NULL_QUALS;
            r2.setForcePreserveQualityScores(false);
            return;
        }
        byte[] scores = new byte[s2.getReadLength()];
        Arrays.fill(scores, (byte)-1);
        for (PreservationPolicy p2 : this.policyList) {
            QualityScorePreservation.addQS(s2, r2, scores, t2, p2);
        }
        if (!r2.isForcePreserveQualityScores()) {
            for (int i2 = 0; i2 < scores.length; ++i2) {
                if (scores[i2] <= -1) continue;
                if (r2.readFeatures == null) {
                    r2.readFeatures = new LinkedList<ReadFeature>();
                }
                r2.readFeatures.add(new BaseQualityScore(i2 + 1, scores[i2]));
            }
            if (r2.readFeatures != null) {
                Collections.sort(r2.readFeatures, readFeaturePositionComparator);
            }
        }
        r2.qualityScores = scores;
    }

    public boolean areReferenceTracksRequired() {
        if (this.policyList == null || this.policyList.isEmpty()) {
            return false;
        }
        for (PreservationPolicy p2 : this.policyList) {
            if (p2.baseCategories == null || p2.baseCategories.isEmpty()) continue;
            for (BaseCategory c2 : p2.baseCategories) {
                switch (c2.type) {
                    case LOWER_COVERAGE: 
                    case PILEUP: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static final void addQS(SAMRecord s2, CramCompressionRecord r2, byte[] scores, ReferenceTracks t2, PreservationPolicy p2) {
        int alSpan = s2.getAlignmentEnd() - s2.getAlignmentStart();
        byte[] qs = s2.getBaseQualities();
        if (p2.readCategory != null) {
            boolean properRead = false;
            switch (p2.readCategory.type) {
                case ALL: {
                    properRead = true;
                    break;
                }
                case UNPLACED: {
                    properRead = s2.getReadUnmappedFlag();
                    break;
                }
                case LOWER_MAPPING_SCORE: {
                    properRead = s2.getMappingQuality() < p2.readCategory.param;
                    break;
                }
                case HIGHER_MAPPING_SCORE: {
                    properRead = s2.getMappingQuality() > p2.readCategory.param;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown read category: " + p2.readCategory.type.name());
                }
            }
            if (!properRead) {
                return;
            }
        }
        if (p2.baseCategories == null || p2.baseCategories.isEmpty()) {
            switch (p2.treatment.type) {
                case BIN: {
                    if (r2.qualityScores == null) {
                        r2.qualityScores = s2.getBaseQualities();
                    }
                    System.arraycopy(s2.getBaseQualities(), 0, scores, 0, scores.length);
                    QualityScorePreservation.applyBinning(scores);
                    r2.setForcePreserveQualityScores(true);
                    break;
                }
                case PRESERVE: {
                    System.arraycopy(s2.getBaseQualities(), 0, scores, 0, scores.length);
                    r2.setForcePreserveQualityScores(true);
                    break;
                }
                case DROP: {
                    r2.qualityScores = null;
                    r2.setForcePreserveQualityScores(false);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown quality score treatment type: " + p2.treatment.type.name());
                }
            }
            return;
        }
        boolean[] mask = new boolean[qs.length];
        int alStart = s2.getAlignmentStart();
        if (alStart == 0) {
            return;
        }
        t2.ensureRange(alStart, alSpan);
        block24: for (BaseCategory c2 : p2.baseCategories) {
            switch (c2.type) {
                case FLANKING_DELETION: {
                    int pos = 0;
                    for (CigarElement ce : s2.getCigar().getCigarElements()) {
                        if (ce.getOperator() == CigarOperator.D) {
                            mask[pos] = true;
                            if (pos + 1 < mask.length) {
                                mask[pos + 1] = true;
                            }
                        }
                        pos += ce.getOperator().consumesReadBases() ? ce.getLength() : 0;
                    }
                    continue block24;
                }
                case MATCH: 
                case MISMATCH: {
                    int i2;
                    int pos = 0;
                    int refPos = s2.getAlignmentStart();
                    for (CigarElement ce : s2.getCigar().getCigarElements()) {
                        if (ce.getOperator().consumesReadBases()) {
                            for (i2 = 0; i2 < ce.getLength(); ++i2) {
                                boolean match = s2.getReadBases()[pos + i2] == t2.baseAt(refPos + i2);
                                mask[pos + i2] = c2.type == BaseCategoryType.MATCH && match || c2.type == BaseCategoryType.MISMATCH && !match;
                            }
                            pos += ce.getLength();
                        }
                        refPos += ce.getOperator().consumesReferenceBases() ? ce.getLength() : 0;
                    }
                    continue block24;
                }
                case INSERTION: {
                    int i2;
                    int pos = 0;
                    for (CigarElement ce : s2.getCigar().getCigarElements()) {
                        switch (ce.getOperator()) {
                            case I: {
                                for (i2 = 0; i2 < ce.getLength(); ++i2) {
                                    mask[pos + i2] = true;
                                }
                                break;
                            }
                        }
                        pos += ce.getOperator().consumesReadBases() ? ce.getLength() : 0;
                    }
                    continue block24;
                }
                case LOWER_COVERAGE: {
                    int i2;
                    int pos = 1;
                    int refPos = s2.getAlignmentStart();
                    for (CigarElement ce : s2.getCigar().getCigarElements()) {
                        switch (ce.getOperator()) {
                            case M: 
                            case EQ: 
                            case X: {
                                for (i2 = 0; i2 < ce.getLength(); ++i2) {
                                    mask[pos + i2 - 1] = t2.coverageAt(refPos + i2) < c2.param;
                                }
                                break;
                            }
                        }
                        pos += ce.getOperator().consumesReadBases() ? ce.getLength() : 0;
                        refPos += ce.getOperator().consumesReferenceBases() ? ce.getLength() : 0;
                    }
                    continue block24;
                }
                case PILEUP: {
                    for (int i3 = 0; i3 < qs.length; ++i3) {
                        if (t2.mismatchesAt(alStart + i3) <= c2.param) continue;
                        mask[i3] = true;
                    }
                    continue block24;
                }
            }
        }
        int maskedCount = 0;
        for (int i4 = 0; i4 < mask.length; ++i4) {
            if (!mask[i4]) continue;
            scores[i4] = QualityScorePreservation.applyTreatment(qs[i4], p2.treatment);
            ++maskedCount;
        }
        if (maskedCount > s2.getReadLength() / 2) {
            r2.setForcePreserveQualityScores(true);
        }
    }
}

