/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.index;

import htsjdk.samtools.CRAMIndexer;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.io.CountingInputStream;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

class BaiIndexer {
    private static Log log = Log.getInstance(BaiIndexer.class);
    public CountingInputStream is;
    public SAMFileHeader samFileHeader;
    public CRAMIndexer indexer;

    public BaiIndexer(InputStream is, SAMFileHeader samFileHeader, File output) {
        this.is = new CountingInputStream(is);
        this.samFileHeader = samFileHeader;
        this.indexer = new CRAMIndexer(output, samFileHeader);
    }

    public BaiIndexer(InputStream is, File output) throws IOException {
        this.is = new CountingInputStream(is);
        CramHeader cramHeader = CramIO.readCramHeader(this.is);
        this.samFileHeader = cramHeader.getSamFileHeader();
        this.indexer = new CRAMIndexer(output, this.samFileHeader);
    }

    private boolean nextContainer() throws IOException {
        long offset = this.is.getCount();
        Container c2 = CramIO.readContainer(this.is);
        if (c2 == null) {
            return false;
        }
        c2.offset = offset;
        int i2 = 0;
        for (Slice slice : c2.slices) {
            slice.containerOffset = offset;
            slice.index = i2++;
            this.indexer.processAlignment(slice);
        }
        log.info("INDEXED: " + c2.toString());
        return true;
    }

    private void index() throws IOException {
        while (this.nextContainer()) {
        }
    }

    public void run() throws IOException {
        this.index();
        this.indexer.finish();
    }
}

