/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.ExternalLongCodec;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.InputStream;
import java.util.Map;

public class ExternalLongEncoding
implements Encoding<Long> {
    public static final EncodingID encodingId = EncodingID.EXTERNAL;
    public int contentId = -1;

    public static EncodingParams toParam(int contentId) {
        ExternalLongEncoding e2 = new ExternalLongEncoding();
        e2.contentId = contentId;
        return new EncodingParams(encodingId, e2.toByteArray());
    }

    @Override
    public byte[] toByteArray() {
        return ByteBufferUtils.writeUnsignedITF8(this.contentId);
    }

    @Override
    public void fromByteArray(byte[] data) {
        this.contentId = ByteBufferUtils.readUnsignedITF8(data);
    }

    @Override
    public BitCodec<Long> buildCodec(Map<Integer, InputStream> inputMap, Map<Integer, ExposedByteArrayOutputStream> outputMap) {
        InputStream is = inputMap == null ? null : inputMap.get(this.contentId);
        ExposedByteArrayOutputStream os = outputMap == null ? null : outputMap.get(this.contentId);
        return new ExternalLongCodec(os, is);
    }

    @Override
    public EncodingID id() {
        return encodingId;
    }
}

