/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class CanonicalHuffmanByteCodec
extends AbstractBitCodec<Byte> {
    private TreeMap<Byte, HuffmanBitCode> codes;
    private HuffmanBitCode[] bitCodes = new HuffmanBitCode[256];
    private Integer[] codeLentghSorted;
    private Map<Integer, Map<Long, Byte>> codeCache = new HashMap<Integer, Map<Long, Byte>>();
    private Map<Long, Byte>[] codeMaps;

    public CanonicalHuffmanByteCodec(byte[] values, int[] bitLengths) {
        TreeMap codebook = new TreeMap();
        for (int i2 = 0; i2 < values.length; ++i2) {
            if (codebook.containsKey(bitLengths[i2])) {
                ((TreeSet)codebook.get(bitLengths[i2])).add(values[i2]);
                continue;
            }
            TreeSet<Byte> entry = new TreeSet<Byte>();
            entry.add(values[i2]);
            codebook.put(bitLengths[i2], entry);
        }
        this.codeLentghSorted = new Integer[codebook.size()];
        int keys = 0;
        int codeLength = 0;
        int codeValue = -1;
        this.codes = new TreeMap();
        Set keySet = codebook.keySet();
        for (Object key : keySet) {
            int iKey = Integer.parseInt(key.toString());
            this.codeLentghSorted[keys++] = iKey;
            TreeSet get = (TreeSet)codebook.get(key);
            for (Byte entry : get) {
                HuffmanBitCode code = new HuffmanBitCode();
                code.bitLentgh = iKey;
                code.value = entry.byteValue();
                ++codeValue;
                int delta = iKey - codeLength;
                code.bitCode = codeValue <<= delta;
                codeLength += delta;
                if (this.NumberOfSetBits(codeValue) > iKey) {
                    throw new IllegalArgumentException("Symbol out of range");
                }
                this.bitCodes[entry.byteValue() & 0xFF] = code;
                this.codes.put(entry, code);
                Map<Long, Byte> codeMap = this.codeCache.get(code.bitLentgh);
                if (codeMap == null) {
                    codeMap = new HashMap<Long, Byte>();
                    this.codeCache.put(code.bitLentgh, codeMap);
                }
                codeMap.put(new Long(code.bitCode), (byte)(0xFF & code.value));
            }
        }
        this.codeMaps = this.codeLentghSorted.length > 0 ? new Map[this.codeLentghSorted[this.codeLentghSorted.length - 1] + 1] : new Map[1];
        Integer[] arr$ = this.codeLentghSorted;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int len = arr$[i$];
            this.codeMaps[len] = this.codeCache.get(len);
        }
    }

    @Override
    public Byte read(BitInputStream bis) throws IOException {
        long buf = 0L;
        int bitsRead = 0;
        Integer[] arr$ = this.codeLentghSorted;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int len = arr$[i$];
            buf <<= len - bitsRead;
            long readLongBits = bis.readLongBits(len - bitsRead);
            bitsRead = len;
            Map<Long, Byte> codeMap = this.codeMaps[len];
            Byte result = codeMap.get(buf |= readLongBits);
            if (result == null) continue;
            return result;
        }
        throw new RuntimeException("Bit code not found. Current state: " + bitsRead + " bits read, buf=" + buf);
    }

    @Override
    public long write(BitOutputStream bos, Byte object) throws IOException {
        HuffmanBitCode bitCode = this.bitCodes[object];
        if (bitCode == null) {
            throw new RuntimeException("Huffman code not found for value: " + object);
        }
        bos.write(bitCode.bitCode, bitCode.bitLentgh);
        return bitCode.bitLentgh;
    }

    @Override
    public long numberOfBits(Byte object) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private int NumberOfSetBits(int i2) {
        i2 -= i2 >> 1 & 0x55555555;
        i2 = (i2 & 0x33333333) + (i2 >> 2 & 0x33333333);
        return (i2 + (i2 >> 4) & 0xF0F0F0F) * 0x1010101 >> 24;
    }

    @Override
    public Byte read(BitInputStream bis, int len) throws IOException {
        throw new RuntimeException("Not implemented");
    }

    private static class HuffmanBitCode {
        int bitCode;
        int bitLentgh;
        int value;

        private HuffmanBitCode() {
        }
    }
}

