/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSource;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SAMValidationError;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.build.ContainerParser;
import htsjdk.samtools.cram.build.Cram2SamRecordFactory;
import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.build.CramNormalizer;
import htsjdk.samtools.cram.io.CountingInputStream;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.RuntimeEOFException;
import htsjdk.samtools.util.SequenceUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CRAMIterator
implements SAMRecordIterator {
    private static Log log = Log.getInstance(CRAMIterator.class);
    private CountingInputStream is;
    private CramHeader cramHeader;
    private ArrayList<SAMRecord> records;
    private int recordCounter = 0;
    private SAMRecord nextRecord = null;
    private boolean restoreNMTag = true;
    private boolean restoreMDTag = false;
    private CramNormalizer normalizer;
    private byte[] refs;
    private int prevSeqId = -1;
    private Container container;
    private long containerOffset = 0L;
    private SamReader mReader;
    private ContainerParser parser;
    private ReferenceSource referenceSource;
    private ValidationStringency validationStringency = ValidationStringency.SILENT;
    private long samRecordIndex;
    private ArrayList<CramCompressionRecord> cramRecords;

    public ValidationStringency getValidationStringency() {
        return this.validationStringency;
    }

    public void setValidationStringency(ValidationStringency validationStringency) {
        this.validationStringency = validationStringency;
    }

    public CRAMIterator(InputStream is, ReferenceSource referenceSource) throws IOException {
        this.is = new CountingInputStream(is);
        this.referenceSource = referenceSource;
        this.cramHeader = CramIO.readCramHeader(this.is);
        this.records = new ArrayList(10000);
        this.normalizer = new CramNormalizer(this.cramHeader.getSamFileHeader(), referenceSource);
        this.parser = new ContainerParser(this.cramHeader.getSamFileHeader());
    }

    public CramHeader getCramHeader() {
        return this.cramHeader;
    }

    private void nextContainer() throws IOException, IllegalArgumentException, IllegalAccessException {
        this.recordCounter = 0;
        this.containerOffset = this.is.getCount();
        this.container = CramIO.readContainer(this.is);
        if (this.container == null || this.container.isEOF()) {
            this.records.clear();
            this.nextRecord = null;
            this.recordCounter = -1;
            return;
        }
        if (this.records == null) {
            this.records = new ArrayList(this.container.nofRecords);
        } else {
            this.records.clear();
        }
        if (this.cramRecords == null) {
            this.cramRecords = new ArrayList(this.container.nofRecords);
        } else {
            this.cramRecords.clear();
        }
        this.parser.getRecords(this.container, this.cramRecords);
        if (this.container.sequenceId == -1) {
            this.refs = new byte[0];
        } else if (this.container.sequenceId == -2) {
            this.refs = null;
            this.prevSeqId = -2;
        } else if (this.prevSeqId < 0 || this.prevSeqId != this.container.sequenceId) {
            SAMSequenceRecord sequence = this.cramHeader.getSamFileHeader().getSequence(this.container.sequenceId);
            this.refs = this.referenceSource.getReferenceBases(sequence, true);
            this.prevSeqId = this.container.sequenceId;
        }
        try {
            for (int i2 = 0; i2 < this.container.slices.length; ++i2) {
                Slice s2 = this.container.slices[i2];
                if (s2.sequenceId < 0 || s2.validateRefMD5(this.refs)) continue;
                log.error(String.format("Reference sequence MD5 mismatch for slice: seq id %d, start %d, span %d, expected MD5 %s", s2.sequenceId, s2.alignmentStart, s2.alignmentSpan, String.format("%032x", new BigInteger(1, s2.refMD5))));
            }
        }
        catch (NoSuchAlgorithmException e1) {
            throw new RuntimeException(e1);
        }
        this.normalizer.normalize(this.cramRecords, true, this.refs, this.container.alignmentStart, this.container.h.substitutionMatrix, this.container.h.AP_seriesDelta);
        Cram2SamRecordFactory c2sFactory = new Cram2SamRecordFactory(this.cramHeader.getSamFileHeader());
        for (CramCompressionRecord r2 : this.cramRecords) {
            SAMRecord s3 = c2sFactory.create(r2);
            if (!r2.isSegmentUnmapped()) {
                SAMSequenceRecord sequence = this.cramHeader.getSamFileHeader().getSequence(r2.sequenceId);
                this.refs = this.referenceSource.getReferenceBases(sequence, true);
                SequenceUtil.calculateMdAndNmTags(s3, this.refs, this.restoreMDTag, this.restoreNMTag);
            }
            s3.setValidationStringency(this.validationStringency);
            if (this.validationStringency != ValidationStringency.SILENT) {
                List<SAMValidationError> validationErrors = s3.isValid();
                SAMUtils.processValidationErrors(validationErrors, this.samRecordIndex, this.validationStringency);
            }
            if (this.mReader != null) {
                long chunkStart = this.containerOffset << 16 | (long)r2.sliceIndex;
                long chunkEnd = (this.containerOffset << 16 | (long)r2.sliceIndex) + 1L;
                this.nextRecord.setFileSource(new SAMFileSource(this.mReader, new BAMFileSpan(new Chunk(chunkStart, chunkEnd))));
            }
            this.records.add(s3);
        }
        this.cramRecords.clear();
    }

    @Override
    public boolean hasNext() {
        if (this.container != null && this.container.isEOF()) {
            return false;
        }
        if (this.container == null || this.recordCounter >= this.records.size()) {
            try {
                this.nextContainer();
                if (this.records.isEmpty()) {
                    return false;
                }
            }
            catch (Exception e2) {
                throw new RuntimeEOFException(e2);
            }
        }
        this.nextRecord = this.records.get(this.recordCounter++);
        return true;
    }

    @Override
    public SAMRecord next() {
        return this.nextRecord;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Removal of records not implemented.");
    }

    @Override
    public void close() {
        this.records.clear();
        try {
            this.is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public SAMRecordIterator assertSorted(SAMFileHeader.SortOrder sortOrder) {
        throw new RuntimeException("Not implemented.");
    }

    public SamReader getFileSource() {
        return this.mReader;
    }

    public void setFileSource(SamReader mReader) {
        this.mReader = mReader;
    }

    public SAMFileHeader getSAMFileHeader() {
        return this.cramHeader.getSamFileHeader();
    }

    public static class CramFileIterable
    implements Iterable<SAMRecord> {
        private ReferenceSource referenceSource;
        private File cramFile;
        private ValidationStringency validationStringency;

        public CramFileIterable(File cramFile, ReferenceSource referenceSource, ValidationStringency validationStringency) {
            this.referenceSource = referenceSource;
            this.cramFile = cramFile;
            this.validationStringency = validationStringency;
        }

        public CramFileIterable(File cramFile, ReferenceSource referenceSource) {
            this(cramFile, referenceSource, ValidationStringency.DEFAULT_STRINGENCY);
        }

        @Override
        public Iterator<SAMRecord> iterator() {
            try {
                FileInputStream fis = new FileInputStream(this.cramFile);
                BufferedInputStream bis = new BufferedInputStream(fis);
                CRAMIterator iterator = new CRAMIterator(bis, this.referenceSource);
                iterator.setValidationStringency(this.validationStringency);
                return iterator;
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
    }
}

