/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.utils.PortingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultFocusManager;
import javax.swing.JLayeredPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class PopupWindow {
    protected EventListenerList listenerList = new EventListenerList();
    private JWindow _delegate;
    private Container _container;
    private List _grabbed = new Vector();
    private List _excluded = new Vector();
    private WindowListener _windowListener;
    private ComponentListener _componentListener;
    private ContainerListener _containerListener;
    private MouseListener _mouseListener;
    private Component _component;
    private KeyEventDispatcher _keyEventDispatcher;
    private Component _parent;

    public PopupWindow(Container container) {
        this._container = container;
        this.createDelegate();
        this.createListeners();
    }

    private void createDelegate() {
        Window window = this.getWindow();
        if (window != null) {
            this._delegate = new JWindow(window);
        }
    }

    public void add(Component component) {
        this._component = component;
        this._component.addPropertyChangeListener("preferredSize", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (PopupWindow.this._delegate != null) {
                    PopupWindow.this._delegate.pack();
                }
            }
        });
        if (this._delegate != null) {
            this._delegate.getContentPane().add(component);
            this._delegate.pack();
            this._delegate.pack();
        }
    }

    public void show(Component relative, int x2, int y) {
        this._parent = relative;
        if (this._delegate == null) {
            this.createDelegate();
            if (this._delegate == null) {
                return;
            }
            this.add(this._component);
        }
        Point p2 = new Point(x2, y);
        SwingUtilities.convertPointToScreen(p2, relative);
        Rectangle screenSize = PortingUtils.getScreenBounds(relative);
        Dimension size = this._component.getPreferredSize();
        int left = p2.x + size.width;
        int bottom = p2.y + size.height;
        if (p2.x < screenSize.x) {
            p2.x = screenSize.x;
        }
        if (left > screenSize.width) {
            p2.x = screenSize.width - size.width;
        }
        if (p2.y < screenSize.y) {
            p2.y = screenSize.y;
        }
        if (bottom > screenSize.height) {
            p2.y = screenSize.height - size.height;
        }
        this._delegate.setLocation(p2.x, p2.y);
        this._delegate.setSize(this._component.getPreferredSize());
        this.firePopupMenuWillBecomeVisible();
        this._delegate.setVisible(true);
        this.grabContainers();
        this._keyEventDispatcher = new KeyEventDispatcher(){

            public boolean dispatchKeyEvent(KeyEvent e2) {
                if (e2.getKeyCode() == 27) {
                    PopupWindow.this.hide();
                    return true;
                }
                return false;
            }
        };
        DefaultFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this._keyEventDispatcher);
    }

    public void hide() {
        if (this._parent != null) {
            this._parent.requestFocus();
        }
        this.firePopupMenuWillBecomeInvisible();
        if (this._delegate != null) {
            this._delegate.setVisible(false);
        }
        if (this._keyEventDispatcher != null) {
            DefaultFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this._keyEventDispatcher);
            this._keyEventDispatcher = null;
        }
        this.releaseContainers();
        this.disposeDelegate();
    }

    private void createListeners() {
        this._windowListener = new WindowAdapter(){

            public void windowClosing(WindowEvent e2) {
                PopupWindow.this.hide();
            }

            public void windowClosed(WindowEvent e2) {
                PopupWindow.this.hide();
            }

            public void windowIconified(WindowEvent e2) {
                PopupWindow.this.hide();
            }
        };
        this._componentListener = new ComponentListener(){

            public void componentResized(ComponentEvent e2) {
                PopupWindow.this.hide();
            }

            public void componentMoved(ComponentEvent e2) {
                PopupWindow.this.hide();
            }

            public void componentShown(ComponentEvent e2) {
                PopupWindow.this.hide();
            }

            public void componentHidden(ComponentEvent e2) {
                PopupWindow.this.hide();
            }
        };
        this._containerListener = new ContainerListener(){

            public void componentAdded(ContainerEvent e2) {
                PopupWindow.this.hide();
            }

            public void componentRemoved(ContainerEvent e2) {
                PopupWindow.this.hide();
            }
        };
        this._mouseListener = new MouseAdapter(){

            public void mousePressed(MouseEvent e2) {
                PopupWindow.this.hide();
            }
        };
    }

    private void disposeDelegate() {
        if (this._delegate != null) {
            this._delegate.dispose();
            this._delegate = null;
        }
    }

    private Window getWindow() {
        Container c2 = this._container;
        if (c2 == null) {
            return null;
        }
        while (!(c2 instanceof Window) && c2.getParent() != null) {
            c2 = c2.getParent();
        }
        if (c2 instanceof Window) {
            return (Window)c2;
        }
        return null;
    }

    private void grabContainers() {
        Container c2 = this._container;
        while (!(c2 instanceof Window) && c2.getParent() != null) {
            c2 = c2.getParent();
        }
        this.grabContainer(c2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grabContainer(Container c2) {
        if (c2 instanceof Window) {
            ((Window)c2).addWindowListener(this._windowListener);
            c2.addComponentListener(this._componentListener);
            this._grabbed.add(c2);
        }
        Object object = c2.getTreeLock();
        synchronized (object) {
            int ncomponents = c2.getComponentCount();
            Component[] component = c2.getComponents();
            for (int i2 = 0; i2 < ncomponents; ++i2) {
                Component comp = component[i2];
                if (!comp.isVisible() || this.isExcludedComponent(comp)) continue;
                comp.addMouseListener(this._mouseListener);
                this._grabbed.add(comp);
                if (!(comp instanceof Container)) continue;
                Container cont = (Container)comp;
                if (cont instanceof JLayeredPane) {
                    cont.addContainerListener(this._containerListener);
                }
                this.grabContainer(cont);
            }
        }
    }

    void releaseContainers() {
        for (Object o2 : this._grabbed) {
            Component c2 = (Component)o2;
            if (c2 instanceof Window) {
                ((Window)c2).removeWindowListener(this._windowListener);
                c2.removeComponentListener(this._componentListener);
            } else {
                c2.removeMouseListener(this._mouseListener);
            }
            if (!(c2 instanceof Container) || !(c2 instanceof JLayeredPane)) continue;
            ((Container)c2).removeContainerListener(this._containerListener);
        }
        this._grabbed.clear();
    }

    public boolean isVisible() {
        return this._delegate != null ? this._delegate.isVisible() : false;
    }

    public void addPopupMenuListener(PopupMenuListener l2) {
        this.listenerList.add(PopupMenuListener.class, l2);
    }

    public void removePopupMenuListener(PopupMenuListener l2) {
        this.listenerList.remove(PopupMenuListener.class, l2);
    }

    public PopupMenuListener[] getPopupMenuListeners() {
        return (PopupMenuListener[])this.listenerList.getListeners(PopupMenuListener.class);
    }

    public void firePopupMenuWillBecomeVisible() {
        Object[] listeners = this.listenerList.getListenerList();
        PopupMenuEvent e2 = null;
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != PopupMenuListener.class) continue;
            if (e2 == null) {
                e2 = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)listeners[i2 + 1]).popupMenuWillBecomeVisible(e2);
        }
    }

    public void firePopupMenuWillBecomeInvisible() {
        Object[] listeners = this.listenerList.getListenerList();
        PopupMenuEvent e2 = null;
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != PopupMenuListener.class) continue;
            if (e2 == null) {
                e2 = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)listeners[i2 + 1]).popupMenuWillBecomeInvisible(e2);
        }
    }

    public void firePopupMenuCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        PopupMenuEvent e2 = null;
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != PopupMenuListener.class) continue;
            if (e2 == null) {
                e2 = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)listeners[i2 + 1]).popupMenuCanceled(e2);
        }
    }

    public void addAsExcludedComponents(Component comp) {
        if (this._excluded.contains(comp)) {
            return;
        }
        this._excluded.add(comp);
    }

    public void removeFromExcludedComponents(Component comp) {
        if (!this._excluded.contains(comp)) {
            return;
        }
        this._excluded.remove(comp);
    }

    public boolean isExcludedComponent(Component comp) {
        return this._excluded.contains(comp);
    }
}

