/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.io.BitwiseUtils;
import htsjdk.samtools.util.Log;
import java.util.Arrays;
import java.util.Comparator;

public class SubstitutionMatrix {
    public static final byte[] BASES = new byte[]{65, 67, 71, 84, 78};
    public static final byte[] BASES_LC = new byte[]{97, 99, 103, 116, 110};
    public static final byte[] ORDER = new byte[255];
    private static Log log;
    private byte[] bytes = new byte[5];
    private byte[][] codes = new byte[255][255];
    private byte[][] bases = new byte[255][255];
    private static Comparator<SubCode> comparator;

    public SubstitutionMatrix(long[][] freqs) {
        int i;
        for (i = 0; i < BASES.length; ++i) {
            this.bytes[SubstitutionMatrix.ORDER[SubstitutionMatrix.BASES[i]]] = this.rank(BASES[i], freqs[BASES[i]]);
        }
        for (i = 0; i < this.bases.length; ++i) {
            Arrays.fill(this.bases[i], (byte)78);
        }
        for (i = 0; i < BASES.length; ++i) {
            byte r = BASES[i];
            for (byte b : BASES) {
                if (r == b) continue;
                this.bases[r][this.codes[r][b]] = b;
                this.bases[SubstitutionMatrix.BASES_LC[i]][this.codes[r][b]] = b;
            }
        }
        this.dump();
    }

    public void dump() {
        log.debug("Subs matrix: " + Arrays.toString(this.bytes) + ": " + BitwiseUtils.toBitString(this.bytes));
        StringBuffer sb = new StringBuffer("Subs matrix decoded: ");
        for (byte r : "ACGTN".getBytes()) {
            sb.append((char)r);
            sb.append(":");
            for (int i = 0; i < 4; ++i) {
                sb.append((char)this.bases[r][i]);
            }
            sb.append("\t");
        }
        log.debug(sb.toString());
    }

    public SubstitutionMatrix(byte[] matrix) {
        int i;
        this.bytes = matrix;
        for (i = 0; i < this.bases.length; ++i) {
            Arrays.fill(this.bases[i], (byte)78);
        }
        this.bases[65][this.bytes[0] >> 6 & 3] = 67;
        this.bases[65][this.bytes[0] >> 4 & 3] = 71;
        this.bases[65][this.bytes[0] >> 2 & 3] = 84;
        this.bases[65][this.bytes[0] >> 0 & 3] = 78;
        for (i = 0; i < 4; ++i) {
            this.bases[97][i] = this.bases[65][i];
        }
        this.bases[67][this.bytes[1] >> 6 & 3] = 65;
        this.bases[67][this.bytes[1] >> 4 & 3] = 71;
        this.bases[67][this.bytes[1] >> 2 & 3] = 84;
        this.bases[67][this.bytes[1] >> 0 & 3] = 78;
        for (i = 0; i < 4; ++i) {
            this.bases[99][i] = this.bases[67][i];
        }
        this.bases[71][this.bytes[2] >> 6 & 3] = 65;
        this.bases[71][this.bytes[2] >> 4 & 3] = 67;
        this.bases[71][this.bytes[2] >> 2 & 3] = 84;
        this.bases[71][this.bytes[2] >> 0 & 3] = 78;
        for (i = 0; i < 4; ++i) {
            this.bases[103][i] = this.bases[71][i];
        }
        this.bases[84][this.bytes[3] >> 6 & 3] = 65;
        this.bases[84][this.bytes[3] >> 4 & 3] = 67;
        this.bases[84][this.bytes[3] >> 2 & 3] = 71;
        this.bases[84][this.bytes[3] >> 0 & 3] = 78;
        for (i = 0; i < 4; ++i) {
            this.bases[116][i] = this.bases[84][i];
        }
        this.bases[78][this.bytes[4] >> 6 & 3] = 65;
        this.bases[78][this.bytes[4] >> 4 & 3] = 67;
        this.bases[78][this.bytes[4] >> 2 & 3] = 71;
        this.bases[78][this.bytes[4] >> 0 & 3] = 84;
        for (byte refBase : BASES) {
            for (int code = 0; code < 4; code = (int)((byte)(code + 1))) {
                this.codes[refBase][this.bases[refBase][code]] = code;
            }
        }
        this.dump();
    }

    public byte[] getEncodedMatrix() {
        return this.bytes;
    }

    private byte rank(byte refBase, long[] freqs) {
        SubCode[] subCodes = new SubCode[4];
        int i = 0;
        for (byte base : BASES) {
            if (refBase == base) continue;
            subCodes[i++] = new SubCode(refBase, base, freqs[base]);
        }
        Arrays.sort(subCodes, comparator);
        for (i = 0; i < subCodes.length; i = (int)((byte)(i + 1))) {
            subCodes[i].rank = (byte)i;
        }
        for (i = 0; i < subCodes.length; i = (int)((byte)(i + 1))) {
            subCodes[i].freq = 0L;
        }
        Arrays.sort(subCodes, comparator);
        byte rank = 0;
        for (int i2 = 0; i2 < subCodes.length; i2 = (int)((byte)(i2 + 1))) {
            rank = (byte)(rank << 2);
            rank = (byte)(rank | subCodes[i2].rank);
        }
        for (SubCode s : subCodes) {
            this.codes[refBase][s.base] = s.rank;
        }
        return rank;
    }

    public byte code(byte refBase, byte readBase) {
        return this.codes[refBase][readBase];
    }

    public byte base(byte refBase, byte code) {
        byte base = this.bases[refBase][code];
        return base;
    }

    public static void main(String[] args) {
        SubstitutionMatrix m = new SubstitutionMatrix(new byte[]{27, -28, 27, 27, 27});
        for (byte refBase : BASES) {
            for (byte base : BASES) {
                if (refBase == base) continue;
                System.out.printf("Ref=%c, base=%c, code=%d\n", Character.valueOf((char)refBase), Character.valueOf((char)base), m.code(refBase, base));
            }
        }
        System.out.println(Arrays.toString(m.bytes));
        System.out.println("===============================================");
        long[][] freqs = new long[255][255];
        for (int r = 0; r < BASES.length; ++r) {
            for (int b = 0; b < BASES.length; ++b) {
                if (r == b) continue;
                freqs[SubstitutionMatrix.BASES[r]][SubstitutionMatrix.BASES[b]] = b;
            }
        }
        m = new SubstitutionMatrix(freqs);
        for (byte refBase : BASES) {
            for (byte base : BASES) {
                if (refBase == base) continue;
                System.out.printf("Ref=%c, base=%c, code=%d\n", Character.valueOf((char)refBase), Character.valueOf((char)base), m.code(refBase, base));
            }
        }
        System.out.println(Arrays.toString(m.bytes));
    }

    static {
        Arrays.fill(ORDER, (byte)-1);
        SubstitutionMatrix.ORDER[65] = 0;
        SubstitutionMatrix.ORDER[67] = 1;
        SubstitutionMatrix.ORDER[71] = 2;
        SubstitutionMatrix.ORDER[84] = 3;
        SubstitutionMatrix.ORDER[78] = 4;
        log = Log.getInstance(SubstitutionMatrix.class);
        comparator = new Comparator<SubCode>(){

            @Override
            public int compare(SubCode o1, SubCode o2) {
                if (o1.freq != o2.freq) {
                    return (int)(o2.freq - o1.freq);
                }
                return ORDER[o1.base] - ORDER[o2.base];
            }
        };
    }

    private static class SubCode {
        byte ref;
        byte base;
        long freq;
        byte rank;
        byte code;

        public SubCode(byte ref, byte base, long freq) {
            this.ref = ref;
            this.base = base;
            this.freq = freq;
        }
    }
}

