/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ExternalIntegerCodec
extends AbstractBitCodec<Integer> {
    private OutputStream os;
    private InputStream is;
    private OutputStream nullOS = new OutputStream(){

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }
    };

    public ExternalIntegerCodec(OutputStream os, InputStream is) {
        this.os = os;
        this.is = is;
    }

    @Override
    public Integer read(BitInputStream bis) throws IOException {
        return ByteBufferUtils.readUnsignedITF8(this.is);
    }

    @Override
    public long write(BitOutputStream bos, Integer value) throws IOException {
        return ByteBufferUtils.writeUnsignedITF8((int)value, this.os);
    }

    @Override
    public long numberOfBits(Integer value) {
        try {
            return ByteBufferUtils.writeUnsignedITF8((int)value, this.nullOS);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Integer read(BitInputStream bis, int len) throws IOException {
        throw new RuntimeException("Not implemented.");
    }
}

