/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.variant.vcf;

import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.variant.Allele;
import org.broad.igv.variant.Genotype;
import org.broad.igv.variant.Variant;
import org.broad.igv.variant.VariantTrack;
import org.broad.igv.variant.vcf.VCFAllele;
import org.broad.igv.variant.vcf.VCFGenotype;

public class VCFVariant
implements Variant {
    private static Logger log = Logger.getLogger(Variant.class);
    VariantContext variantContext;
    List<Allele> alternateAlleles;
    private ZygosityCount zygosityCount;
    String chr;
    private double[] alleleFreqs;
    private double methylationRate = Double.NaN;
    private double coveredSampleFraction = Double.NaN;
    Map<String, VCFGenotype> genotypeMap;
    private int start = -1;

    public VCFVariant(VariantContext variantContext, String chr) {
        this.variantContext = variantContext;
        this.chr = chr;
        this.init();
    }

    private void init() {
        Object genotype;
        this.genotypeMap = new HashMap<String, VCFGenotype>();
        for (String sample : this.getSampleNames()) {
            genotype = this.variantContext.getGenotype(sample);
            VCFGenotype vcfGenotype = genotype == null ? null : new VCFGenotype((htsjdk.variant.variantcontext.Genotype)genotype);
            this.genotypeMap.put(sample, vcfGenotype);
        }
        this.zygosityCount = new ZygosityCount();
        for (String sample : this.getSampleNames()) {
            genotype = this.getGenotype(sample);
            this.zygosityCount.incrementCount((Genotype)genotype);
        }
        String afString = null;
        String[] alleleFreqKeys = new String[]{"AF", "GMAF"};
        try {
            for (String alleleFreqKey : alleleFreqKeys) {
                afString = this.variantContext.getAttributeAsString(alleleFreqKey, "-1");
                this.alleleFreqs = this.parseAFString(afString);
                if (!(this.alleleFreqs[0] >= 0.0)) {
                    continue;
                }
                break;
            }
        }
        catch (NumberFormatException e2) {
            this.alleleFreqs = new double[]{-1.0};
            log.error("Error parsing allele frequency: " + afString);
        }
    }

    private double[] parseAFString(String afString) {
        afString = afString.replaceAll("[\\[\\]\\(\\)]", "");
        String[] tokens = afString.split(",");
        double[] result = new double[tokens.length];
        for (int ii = 0; ii < tokens.length; ++ii) {
            result[ii] = Double.parseDouble(tokens[ii]);
        }
        return result;
    }

    private void computeMethylationRate() {
        double methTotal = 0.0;
        int samplesWithData = 0;
        int size = this.getSampleNames().size();
        if (size > 0) {
            for (String sample : this.getSampleNames()) {
                Genotype genotype = this.getGenotype(sample);
                double mr = genotype.getAttributeAsDouble("MR");
                double goodBaseCount = genotype.getAttributeAsDouble("MR");
                if (Double.isNaN(mr) || Double.isNaN(goodBaseCount) || !(goodBaseCount > (double)VariantTrack.METHYLATION_MIN_BASE_COUNT)) continue;
                methTotal += mr;
                ++samplesWithData;
            }
            this.methylationRate = samplesWithData == 0 ? 0.0 : methTotal / (double)samplesWithData;
            this.coveredSampleFraction = (double)samplesWithData / (double)size;
        }
    }

    @Override
    public String getID() {
        return this.variantContext.getID();
    }

    @Override
    public boolean isFiltered() {
        return this.variantContext.isFiltered();
    }

    @Override
    public String getAttributeAsString(String key) {
        return this.variantContext.getAttributeAsString(key, null);
    }

    @Override
    public String getReference() {
        return this.variantContext.getReference().toString();
    }

    @Override
    public List<Allele> getAlternateAlleles() {
        if (this.alternateAlleles == null) {
            List<htsjdk.variant.variantcontext.Allele> tmp = this.variantContext.getAlternateAlleles();
            this.alternateAlleles = new ArrayList<Allele>(tmp.size());
            for (htsjdk.variant.variantcontext.Allele a2 : tmp) {
                this.alternateAlleles.add(new VCFAllele(a2.getBases()));
            }
        }
        return this.alternateAlleles;
    }

    @Override
    public double getPhredScaledQual() {
        return this.variantContext.getPhredScaledQual();
    }

    @Override
    public String getType() {
        return this.variantContext.getType().toString();
    }

    @Override
    public double[] getAlleleFreqs() {
        return this.alleleFreqs;
    }

    @Override
    public double getAlleleFraction() {
        int total = this.getHomVarCount() + this.getHetCount() + this.getHomRefCount();
        return total == 0 ? -1.0 : ((double)this.getHomVarCount() + (double)this.getHetCount() / 2.0) / (double)total;
    }

    @Override
    public double getMethlationRate() {
        if (Double.isNaN(this.methylationRate)) {
            this.computeMethylationRate();
        }
        return this.methylationRate;
    }

    @Override
    public double getCoveredSampleFraction() {
        if (Double.isNaN(this.coveredSampleFraction)) {
            this.computeMethylationRate();
        }
        return this.coveredSampleFraction;
    }

    @Override
    public Collection<String> getSampleNames() {
        return this.variantContext.getSampleNames();
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.variantContext.getAttributes();
    }

    @Override
    public Genotype getGenotype(String sample) {
        return this.genotypeMap.get(sample);
    }

    @Override
    public Collection<String> getFilters() {
        return this.variantContext.getFilters();
    }

    @Override
    public int getHomVarCount() {
        return this.zygosityCount.getHomVar();
    }

    @Override
    public int getHetCount() {
        return this.zygosityCount.getHet();
    }

    @Override
    public int getHomRefCount() {
        return this.zygosityCount.getHomRef();
    }

    @Override
    public int getNoCallCount() {
        return this.zygosityCount.getNoCall();
    }

    @Override
    public String getChr() {
        return this.chr;
    }

    @Override
    public String getContig() {
        return this.chr;
    }

    @Override
    public int getStart() {
        if (this.start < 0) {
            this.calcStart();
        }
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.variantContext.getEnd();
    }

    public String toString() {
        return String.format("VCFVariant[%s:%d-%d]", this.getChr(), this.getStart(), this.getEnd());
    }

    @Override
    public String getPositionString() {
        if (this.variantContext.getStart() == this.variantContext.getEnd()) {
            return String.valueOf(this.variantContext.getStart());
        }
        return String.format("%d-%d", this.variantContext.getStart(), this.variantContext.getEnd());
    }

    public String getSource() {
        return this.variantContext.getSource();
    }

    public VariantContext getVariantContext() {
        return this.variantContext;
    }

    public static VariantContext getVariantContext(Variant variant) {
        if (variant instanceof VCFVariant) {
            return ((VCFVariant)variant).getVariantContext();
        }
        ArrayList<htsjdk.variant.variantcontext.Allele> alleleList = new ArrayList<htsjdk.variant.variantcontext.Allele>(variant.getAlternateAlleles().size() + 1);
        alleleList.add(htsjdk.variant.variantcontext.Allele.create(variant.getReference(), true));
        for (Allele all : variant.getAlternateAlleles()) {
            alleleList.add(htsjdk.variant.variantcontext.Allele.create(all.getBases(), false));
        }
        VariantContextBuilder vcb = new VariantContextBuilder(variant.getID(), variant.getChr(), variant.getStart(), variant.getEnd(), alleleList);
        return vcb.make();
    }

    private void calcStart() {
        int prefixLength = 0;
        if (this.variantContext.getType() == VariantContext.Type.INDEL || this.variantContext.getType() == VariantContext.Type.MIXED) {
            prefixLength = this.findCommonPrefixLength();
        }
        this.start = this.variantContext.getStart() - 1 + prefixLength;
    }

    private int findCommonPrefixLength() {
        String ref = this.variantContext.getReference().getDisplayString();
        int prefixLength = 0;
        boolean foundmisMatch = false;
        for (int refPos = 0; refPos < ref.length(); ++refPos) {
            char refChar = ref.charAt(refPos);
            for (Allele var : this.getAlternateAlleles()) {
                byte[] varBases = var.getBases();
                if (refPos < varBases.length && varBases[refPos] == refChar) continue;
                foundmisMatch = true;
                break;
            }
            if (foundmisMatch) break;
            ++prefixLength;
        }
        return prefixLength;
    }

    public static class ZygosityCount {
        private int homVar = 0;
        private int het = 0;
        private int homRef = 0;
        private int noCall = 0;

        public void incrementCount(Genotype genotype) {
            if (genotype != null) {
                if (genotype.isHomVar()) {
                    ++this.homVar;
                } else if (genotype.isHet()) {
                    ++this.het;
                } else if (genotype.isHomRef()) {
                    ++this.homRef;
                } else {
                    ++this.noCall;
                }
            }
        }

        public int getHomVar() {
            return this.homVar;
        }

        public int getHet() {
            return this.het;
        }

        public int getHomRef() {
            return this.homRef;
        }

        public int getNoCall() {
            return this.noCall;
        }
    }
}

