/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.stream;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.broad.igv.util.HttpUtils;

public class IGVSeekableHTTPStream
extends SeekableStream {
    static Logger log = Logger.getLogger(IGVSeekableHTTPStream.class);
    private long position = 0L;
    private URL url;
    long contentLength = -1L;

    public IGVSeekableHTTPStream(URL url) {
        this.url = url;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long length() {
        return this.contentLength;
    }

    @Override
    public long skip(long n2) throws IOException {
        long bytesToSkip = this.contentLength < 0L ? n2 : Math.min(n2, this.contentLength - this.position);
        this.position += bytesToSkip;
        return bytesToSkip;
    }

    @Override
    public boolean eof() throws IOException {
        return this.contentLength > 0L && this.position >= this.contentLength;
    }

    @Override
    public void seek(long position) {
        this.position = position;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        String stats = "Offset=" + offset + ",len=" + len + ",buflen=" + buffer.length;
        if (offset < 0 || len < 0 || offset + len > buffer.length) {
            throw new IndexOutOfBoundsException(stats);
        }
        if (len == 0) {
            return 0;
        }
        InputStream is = null;
        int n2 = 0;
        try {
            if (this.contentLength > 0L && this.position >= this.contentLength) {
                int n3 = -1;
                return n3;
            }
            long endRange = this.position + (long)len - 1L;
            if (this.contentLength > 0L) {
                endRange = Math.min(endRange, this.contentLength);
            }
            if (log.isTraceEnabled()) {
                log.trace("Trying to read range " + this.position + " to " + endRange);
            }
            is = this.openInputStreamForRange(this.position, endRange);
            while (n2 < len) {
                int count = is.read(buffer, offset + n2, len - n2);
                if (count < 0) {
                    if (n2 != 0) break;
                    int n4 = -1;
                    return n4;
                }
                n2 += count;
            }
            this.position += (long)n2;
            int n5 = n2;
            return n5;
        }
        catch (IOException e2) {
            if (e2.getMessage().contains("416") || e2 instanceof EOFException) {
                if (n2 == 0) {
                    this.contentLength = this.position;
                    int n6 = -1;
                    return n6;
                }
                this.position += (long)n2;
                this.contentLength = this.position;
                int n7 = n2;
                return n7;
            }
            throw e2;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read() throws IOException {
        byte[] tmp = new byte[1];
        this.read(tmp, 0, 1);
        return tmp[0] & 0xFF;
    }

    public InputStream openInputStreamForRange(long start, long end) throws IOException {
        String byteRange = "bytes=" + start + "-" + end;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Range", byteRange);
        URL url = IGVSeekableHTTPStream.addStartEndQueryString(this.url, start, end);
        HttpURLConnection conn = HttpUtils.getInstance().openConnection(url, params);
        try {
            int contentLength = conn.getContentLength();
            if (contentLength > 0 && (long)contentLength != end - start + 1L) {
                this.contentLength = this.position + (long)contentLength;
            }
        }
        catch (Exception e2) {
            log.error("Error determining content length", e2);
        }
        try {
            InputStream input = conn.getInputStream();
            return input;
        }
        catch (IOException e3) {
            HttpUtils.getInstance().readErrorStream(conn);
            throw e3;
        }
    }

    static URL addStartEndQueryString(URL url, long start, long end) throws MalformedURLException {
        String queryString = url.getQuery();
        if (queryString == null) {
            return new URL(url.toExternalForm() + "?start=" + start + "&end=" + end);
        }
        String newQueryString = queryString + "&start=" + start + "&end" + end;
        return new URL(url.toExternalForm().replace(queryString, newQueryString));
    }

    @Override
    public String getSource() {
        return this.url.toExternalForm();
    }

    public static void main(String[] args) throws IOException {
        IGVSeekableHTTPStream stream = new IGVSeekableHTTPStream(new URL("http://localhost/igv-web/test/data/misc/BufferedReaderTest.bin"));
        byte[] buffer = new byte[1000];
        stream.read(buffer, 0, 1000);
        System.out.println("Done");
    }
}

