/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.Track;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.variant.VariantTrack;

public class TrackGroup {
    private static Logger log = Logger.getLogger(TrackGroup.class);
    private String name;
    private boolean drawBorder = true;
    private List<Track> tracks;
    private boolean selected;

    public TrackGroup() {
        this("");
    }

    public TrackGroup(String name) {
        this.name = name;
        this.tracks = Collections.synchronizedList(new ArrayList());
    }

    public boolean contains(Track track) {
        return this.tracks.contains(track);
    }

    public List<Track> getTracks() {
        return this.tracks;
    }

    public int indexOf(Track track) {
        return this.tracks.indexOf(track);
    }

    public int size() {
        return this.tracks.size();
    }

    public void add(Track track) {
        if (track == null) {
            log.info("Attempt to add null track");
        } else {
            log.debug("Adding track " + track.getName());
            this.tracks.add(track);
        }
    }

    public void add(int pos, Track track) {
        if (track == null) {
            log.info("Attempt to add null track");
        } else {
            this.tracks.add(pos, track);
        }
    }

    public void addAll(Collection<Track> trackList) {
        this.tracks.addAll(trackList);
    }

    public void addAll(int index, Collection<Track> trackList) {
        this.tracks.addAll(index, trackList);
    }

    public void remove(Track track) {
        this.tracks.remove(track);
    }

    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName) {
        float score = -3.4028235E38f;
        for (Track track : this.tracks) {
            if (!track.isVisible()) continue;
            score = Math.max(score, track.getRegionScore(chr, start, end, zoom, type, frameName));
        }
        return score;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean drawBorder) {
        this.drawBorder = drawBorder;
    }

    public boolean isVisible() {
        for (Track t2 : this.tracks) {
            if (t2 == null || !t2.isVisible()) continue;
            return true;
        }
        return false;
    }

    public int getHeight() {
        int h2 = 0;
        for (Track track : this.tracks) {
            if (track == null || !track.isVisible()) continue;
            h2 += track.getHeight();
        }
        return h2;
    }

    public void renderName(Graphics2D g2D, Rectangle rect, boolean isSelected) {
        int fontSize = PreferenceManager.getInstance().getAsInt("DEFAULT_FONT_SIZE");
        Font font = FontManager.getFont(1, fontSize);
        g2D.setFont(font);
        GraphicUtils.drawWrappedText(this.getName(), rect, g2D, true);
    }

    public void sortByAttributes(String[] attributeNames, boolean[] ascending) {
        if (this.tracks != null && !this.tracks.isEmpty()) {
            ArrayList<Track> allTracks = new ArrayList<Track>(this.tracks);
            try {
                Track t22;
                TrackAttributeComparator comparator = new TrackAttributeComparator(attributeNames, ascending);
                ArrayList<Track> nonsortableTracks = new ArrayList<Track>();
                HashMap<Track, Integer> trackIndices = new HashMap<Track, Integer>();
                for (int i2 = this.tracks.size() - 1; i2 >= 0; --i2) {
                    if (this.tracks.get(i2).isSortable()) continue;
                    t22 = this.tracks.remove(i2);
                    nonsortableTracks.add(t22);
                    trackIndices.put(t22, i2);
                }
                Collections.sort(this.tracks, comparator);
                for (Track t22 : allTracks) {
                    if (!(t22 instanceof VariantTrack)) continue;
                    ((VariantTrack)t22).sortSamples(new SampleAttributeComparator(attributeNames, ascending));
                }
                if (nonsortableTracks.size() > 0) {
                    for (int i3 = nonsortableTracks.size() - 1; i3 >= 0; --i3) {
                        t22 = (Track)nonsortableTracks.get(i3);
                        int index = (Integer)trackIndices.get(t22);
                        this.tracks.add(index, t22);
                    }
                }
            }
            catch (Exception e2) {
                log.error("Error sorting tracks by attribute", e2);
                this.tracks = allTracks;
            }
        }
    }

    public void sortGroup(RegionScoreType type, List<String> sortedSamples) {
        ArrayList<Track> unsortableTracks = new ArrayList<Track>();
        HashMap<Track, Integer> trackIndeces = new HashMap<Track, Integer>();
        for (int i2 = this.tracks.size() - 1; i2 >= 0; --i2) {
            if (this.tracks.get(i2).isSortable()) continue;
            Track t2 = this.tracks.remove(i2);
            unsortableTracks.add(t2);
            trackIndeces.put(t2, i2);
        }
        ArrayList<Track> tracksWithScore = new ArrayList<Track>(this.getTracks().size());
        ArrayList<Track> otherTracks = new ArrayList<Track>(this.getTracks().size());
        for (Track t3 : this.getTracks()) {
            if (t3.isRegionScoreType(type)) {
                tracksWithScore.add(t3);
                continue;
            }
            otherTracks.add(t3);
        }
        this.sortBySampleOrder(tracksWithScore, sortedSamples);
        this.sortBySampleOrder(otherTracks, sortedSamples);
        this.tracks.clear();
        this.tracks.addAll(tracksWithScore);
        this.tracks.addAll(otherTracks);
        if (unsortableTracks.size() > 0) {
            for (int i3 = unsortableTracks.size() - 1; i3 >= 0; --i3) {
                Track t3;
                t3 = (Track)unsortableTracks.get(i3);
                int index = (Integer)trackIndeces.get(t3);
                this.tracks.add(index, t3);
            }
        }
    }

    private void sortBySampleOrder(List<Track> tracks, List<String> sortedSamples) {
        if (tracks != null && sortedSamples != null && !tracks.isEmpty()) {
            final HashMap<String, Integer> rankMap = new HashMap<String, Integer>(sortedSamples.size() * 2);
            for (int i2 = sortedSamples.size() - 1; i2 >= 0; --i2) {
                rankMap.put(sortedSamples.get(i2), i2);
            }
            Comparator<Track> c2 = new Comparator<Track>(){

                @Override
                public int compare(Track t1, Track t2) {
                    Integer r2;
                    String a1 = t1.getSample();
                    String a2 = t2.getSample();
                    Integer r1 = a1 == null ? null : (Integer)rankMap.get(a1);
                    Integer n2 = r2 = a2 == null ? null : (Integer)rankMap.get(a2);
                    if (r1 == null && r2 == null) {
                        return 0;
                    }
                    if (r1 == null) {
                        return 1;
                    }
                    if (r2 == null) {
                        return -1;
                    }
                    return r1 - r2;
                }
            };
            Collections.sort(tracks, c2);
        }
    }

    public void sortByList(List<String> trackIds) {
        final HashMap<String, Integer> trackPositions = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < trackIds.size(); ++i2) {
            trackPositions.put(trackIds.get(i2), i2);
        }
        Comparator<Track> c2 = new Comparator<Track>(){

            @Override
            public int compare(Track t1, Track t2) {
                String id1 = t1.getId();
                int p1 = trackPositions.containsKey(id1) ? (Integer)trackPositions.get(id1) : Integer.MAX_VALUE;
                String id2 = t2.getId();
                int p2 = trackPositions.containsKey(id2) ? (Integer)trackPositions.get(id2) : Integer.MAX_VALUE;
                return p1 - p2;
            }
        };
        Collections.sort(this.tracks, c2);
    }

    public void removeTracks(Collection<? extends Track> tracksToRemove) {
        this.tracks.removeAll(tracksToRemove);
    }

    public boolean moveSelectedTracksTo(Collection<? extends Track> selectedTracks, Track targetTrack, boolean before) {
        int index;
        int n2 = index = targetTrack == null ? this.tracks.size() : this.tracks.indexOf(targetTrack);
        if (index < 0) {
            return false;
        }
        if (!before) {
            ++index;
        }
        ArrayList<Track> beforeList = new ArrayList<Track>(this.tracks.subList(0, index));
        ArrayList<Track> afterList = new ArrayList<Track>(this.tracks.subList(index, this.tracks.size()));
        beforeList.removeAll(selectedTracks);
        afterList.removeAll(selectedTracks);
        this.tracks.clear();
        this.tracks.addAll(beforeList);
        this.tracks.addAll(selectedTracks);
        this.tracks.addAll(afterList);
        return true;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        IGV igv = IGV.getInstance();
        igv.clearSelections();
        igv.setTrackSelections(new HashSet<Track>(this.tracks));
    }

    private static class SampleAttributeComparator
    extends AttributeComparator<String> {
        public SampleAttributeComparator(String[] attributeNames, boolean[] ascending) {
            super(attributeNames, ascending);
        }

        @Override
        protected String getAttributeValue(String sample, String attName) {
            String value = AttributeManager.getInstance().getAttribute(sample, attName);
            if (value == null) {
                value = "";
            }
            return value.toLowerCase();
        }
    }

    private static class TrackAttributeComparator
    extends AttributeComparator<Track> {
        public TrackAttributeComparator(String[] attributeNames, boolean[] ascending) {
            super(attributeNames, ascending);
        }

        @Override
        protected String getAttributeValue(Track track, String attName) {
            String value = track.getAttributeValue(attName);
            if (value == null) {
                value = "";
            }
            return value.toLowerCase();
        }
    }

    private static abstract class AttributeComparator<T>
    implements Comparator<T> {
        private final String[] attributeNames;
        private final boolean[] ascending;

        AttributeComparator(String[] attributeNames, boolean[] ascending) {
            assert (attributeNames.length == ascending.length);
            this.attributeNames = attributeNames;
            this.ascending = ascending;
        }

        protected abstract String getAttributeValue(T var1, String var2);

        @Override
        public int compare(T t1, T t2) {
            for (int i2 = 0; i2 < this.attributeNames.length; ++i2) {
                String attName = this.attributeNames[i2];
                if (attName == null) continue;
                String value1 = this.getAttributeValue(t1, attName);
                String value2 = this.getAttributeValue(t2, attName);
                boolean isNumeric = AttributeManager.getInstance().isNumeric(attName);
                int c2 = 0;
                if (isNumeric) {
                    double d2;
                    double d1;
                    try {
                        d1 = Double.parseDouble(value1);
                    }
                    catch (NumberFormatException e2) {
                        d1 = Double.MIN_VALUE;
                    }
                    try {
                        d2 = Double.parseDouble(value2);
                    }
                    catch (NumberFormatException e3) {
                        d2 = Double.MIN_VALUE;
                    }
                    c2 = Double.compare(d1, d2);
                } else {
                    c2 = value1.compareTo(value2);
                }
                if (c2 == 0) continue;
                return this.ascending[i2] ? c2 : -c2;
            }
            return 0;
        }
    }
}

