/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class PBES2Algorithms
extends AlgorithmIdentifier
implements PKCSObjectIdentifiers {
    private ASN1ObjectIdentifier objectId;
    private KeyDerivationFunc func;
    private EncryptionScheme scheme;

    public PBES2Algorithms(ASN1Sequence obj) {
        super(obj);
        Enumeration e2 = obj.getObjects();
        this.objectId = (ASN1ObjectIdentifier)e2.nextElement();
        ASN1Sequence seq = (ASN1Sequence)e2.nextElement();
        e2 = seq.getObjects();
        ASN1Sequence funcSeq = (ASN1Sequence)e2.nextElement();
        this.func = funcSeq.getObjectAt(0).equals(id_PBKDF2) ? new KeyDerivationFunc(id_PBKDF2, (ASN1Encodable)PBKDF2Params.getInstance(funcSeq.getObjectAt(1))) : new KeyDerivationFunc(funcSeq);
        this.scheme = new EncryptionScheme((ASN1Sequence)e2.nextElement());
    }

    public ASN1ObjectIdentifier getObjectId() {
        return this.objectId;
    }

    public KeyDerivationFunc getKeyDerivationFunc() {
        return this.func;
    }

    public EncryptionScheme getEncryptionScheme() {
        return this.scheme;
    }

    public ASN1Primitive getASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        ASN1EncodableVector subV = new ASN1EncodableVector();
        v2.add(this.objectId);
        subV.add(this.func);
        subV.add(this.scheme);
        v2.add(new DERSequence(subV));
        return new DERSequence(v2);
    }
}

