/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.common.NullOutputStream;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.structure.Container;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ContainerHeaderIO {
    public boolean readContainerHeader(Container c2, InputStream is) throws IOException {
        byte[] peek = new byte[4];
        int ch = is.read();
        if (ch == -1) {
            return false;
        }
        peek[0] = (byte)ch;
        for (int i2 = 1; i2 < peek.length; ++i2) {
            ch = is.read();
            if (ch == -1) {
                throw new RuntimeException("Incomplete or broken stream.");
            }
            peek[i2] = (byte)ch;
        }
        c2.containerByteSize = ByteBufferUtils.int32(peek);
        c2.sequenceId = ByteBufferUtils.readUnsignedITF8(is);
        c2.alignmentStart = ByteBufferUtils.readUnsignedITF8(is);
        c2.alignmentSpan = ByteBufferUtils.readUnsignedITF8(is);
        c2.nofRecords = ByteBufferUtils.readUnsignedITF8(is);
        c2.globalRecordCounter = ByteBufferUtils.readUnsignedLTF8(is);
        c2.bases = ByteBufferUtils.readUnsignedLTF8(is);
        c2.blockCount = ByteBufferUtils.readUnsignedITF8(is);
        c2.landmarks = ByteBufferUtils.array(is);
        return true;
    }

    public int writeContainerHeader(Container c2, OutputStream os) throws IOException {
        int len = ByteBufferUtils.writeInt32(c2.containerByteSize, os);
        len += ByteBufferUtils.writeUnsignedITF8(c2.sequenceId, os);
        len += ByteBufferUtils.writeUnsignedITF8(c2.alignmentStart, os);
        len += ByteBufferUtils.writeUnsignedITF8(c2.alignmentSpan, os);
        len += ByteBufferUtils.writeUnsignedITF8(c2.nofRecords, os);
        len += ByteBufferUtils.writeUnsignedLTF8(c2.globalRecordCounter, os);
        len += ByteBufferUtils.writeUnsignedLTF8(c2.bases, os);
        len += ByteBufferUtils.writeUnsignedITF8(c2.blockCount, os);
        return len += ByteBufferUtils.write(c2.landmarks, os);
    }

    public int sizeOfContainerHeader(Container c2) throws IOException {
        NullOutputStream nos = new NullOutputStream();
        return this.writeContainerHeader(c2, nos);
    }
}

