/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.encoding.NullEncoding;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingKey;
import htsjdk.samtools.cram.structure.EncodingParams;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import htsjdk.samtools.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CompressionHeader {
    private static final String RN_readNamesIncluded = "RN";
    private static final String AP_alignmentPositionIsDelta = "AP";
    private static final String RR_referenceRequired = "RR";
    private static final String TD_tagIdsDictionary = "TD";
    private static final String SM_substitutionMatrix = "SM";
    private static Log log = Log.getInstance(CompressionHeader.class);
    public boolean readNamesIncluded;
    public boolean AP_seriesDelta = true;
    public boolean referenceRequired = true;
    public Map<EncodingKey, EncodingParams> eMap;
    public Map<Integer, EncodingParams> tMap;
    public SubstitutionMatrix substitutionMatrix;
    public List<Integer> externalIds;
    public byte[][][] dictionary;

    public CompressionHeader() {
    }

    public CompressionHeader(InputStream is) throws IOException {
        this.read(is);
    }

    /*
     * WARNING - void declaration
     */
    private byte[][][] parseDictionary(byte[] bytes) {
        void var5_7;
        ArrayList dictionary = new ArrayList();
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            ArrayList<byte[]> list = new ArrayList<byte[]>();
            while (bytes[i2] != 0) {
                list.add(Arrays.copyOfRange(bytes, i2, i2 + 3));
                i2 += 3;
            }
            dictionary.add(list);
        }
        int maxWidth = 0;
        for (List list : dictionary) {
            maxWidth = Math.max(maxWidth, list.size());
        }
        byte[][][] array = new byte[dictionary.size()][][];
        boolean bl = false;
        while (var5_7 < dictionary.size()) {
            List list = (List)dictionary.get((int)var5_7);
            array[var5_7] = (byte[][])list.toArray((T[])new byte[list.size()][]);
            ++var5_7;
        }
        return array;
    }

    private byte[] dictionaryToByteArray() {
        int size = 0;
        for (int i2 = 0; i2 < this.dictionary.length; ++i2) {
            for (int j2 = 0; j2 < this.dictionary[i2].length; ++j2) {
                size += this.dictionary[i2][j2].length;
            }
            ++size;
        }
        byte[] bytes = new byte[size];
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        for (int i3 = 0; i3 < this.dictionary.length; ++i3) {
            for (int j3 = 0; j3 < this.dictionary[i3].length; ++j3) {
                buf.put(this.dictionary[i3][j3]);
            }
            buf.put((byte)0);
        }
        return bytes;
    }

    public byte[][] getTagIds(int id) {
        return this.dictionary[id];
    }

    public void read(byte[] data) {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            this.read(bais);
        }
        catch (IOException e2) {
            throw new RuntimeException("This should have never happened.");
        }
    }

    public void read(InputStream is) throws IOException {
        int i2;
        int byteSize = ByteBufferUtils.readUnsignedITF8(is);
        byte[] bytes = new byte[byteSize];
        ByteBufferUtils.readFully(bytes, is);
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        int mapSize = ByteBufferUtils.readUnsignedITF8(buf);
        for (int i3 = 0; i3 < mapSize; ++i3) {
            String key = new String(new byte[]{buf.get(), buf.get()});
            if (RN_readNamesIncluded.equals(key)) {
                this.readNamesIncluded = buf.get() == 1;
                continue;
            }
            if (AP_alignmentPositionIsDelta.equals(key)) {
                this.AP_seriesDelta = buf.get() == 1;
                continue;
            }
            if (RR_referenceRequired.equals(key)) {
                this.referenceRequired = buf.get() == 1;
                continue;
            }
            if (TD_tagIdsDictionary.equals(key)) {
                int size = ByteBufferUtils.readUnsignedITF8(buf);
                byte[] dictionaryBytes = new byte[size];
                buf.get(dictionaryBytes);
                this.dictionary = this.parseDictionary(dictionaryBytes);
                continue;
            }
            if (SM_substitutionMatrix.equals(key)) {
                byte[] matrixBytes = new byte[5];
                buf.get(matrixBytes);
                this.substitutionMatrix = new SubstitutionMatrix(matrixBytes);
                continue;
            }
            throw new RuntimeException("Unknown preservation map key: " + key);
        }
        byteSize = ByteBufferUtils.readUnsignedITF8(is);
        bytes = new byte[byteSize];
        ByteBufferUtils.readFully(bytes, is);
        buf = ByteBuffer.wrap(bytes);
        mapSize = ByteBufferUtils.readUnsignedITF8(buf);
        this.eMap = new TreeMap<EncodingKey, EncodingParams>();
        for (EncodingKey key : EncodingKey.values()) {
            this.eMap.put(key, NullEncoding.toParam());
        }
        for (i2 = 0; i2 < mapSize; ++i2) {
            String key = new String(new byte[]{buf.get(), buf.get()});
            EncodingKey eKey = EncodingKey.byFirstTwoChars(key);
            if (eKey == null) {
                throw new RuntimeException("Unknown encoding key: " + key);
            }
            EncodingID id = EncodingID.values()[buf.get()];
            int paramLen = ByteBufferUtils.readUnsignedITF8(buf);
            byte[] paramBytes = new byte[paramLen];
            buf.get(paramBytes);
            this.eMap.put(eKey, new EncodingParams(id, paramBytes));
            log.debug(String.format("FOUND ENCODING: %s, %s, %s.", eKey.name(), id.name(), Arrays.toString(Arrays.copyOf(paramBytes, 20))));
        }
        byteSize = ByteBufferUtils.readUnsignedITF8(is);
        bytes = new byte[byteSize];
        ByteBufferUtils.readFully(bytes, is);
        buf = ByteBuffer.wrap(bytes);
        mapSize = ByteBufferUtils.readUnsignedITF8(buf);
        this.tMap = new TreeMap<Integer, EncodingParams>();
        for (i2 = 0; i2 < mapSize; ++i2) {
            int key = ByteBufferUtils.readUnsignedITF8(buf);
            EncodingID id = EncodingID.values()[buf.get()];
            int paramLen = ByteBufferUtils.readUnsignedITF8(buf);
            byte[] paramBytes = new byte[paramLen];
            buf.get(paramBytes);
            this.tMap.put(key, new EncodingParams(id, paramBytes));
        }
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.write(baos);
        return baos.toByteArray();
    }

    public void write(OutputStream os) throws IOException {
        ByteBuffer mapBuf = ByteBuffer.allocate(102400);
        ByteBufferUtils.writeUnsignedITF8(5, mapBuf);
        mapBuf.put(RN_readNamesIncluded.getBytes());
        mapBuf.put((byte)(this.readNamesIncluded ? 1 : 0));
        mapBuf.put(AP_alignmentPositionIsDelta.getBytes());
        mapBuf.put((byte)(this.AP_seriesDelta ? 1 : 0));
        mapBuf.put(RR_referenceRequired.getBytes());
        mapBuf.put((byte)(this.referenceRequired ? 1 : 0));
        mapBuf.put(SM_substitutionMatrix.getBytes());
        mapBuf.put(this.substitutionMatrix.getEncodedMatrix());
        mapBuf.put(TD_tagIdsDictionary.getBytes());
        byte[] dBytes = this.dictionaryToByteArray();
        ByteBufferUtils.writeUnsignedITF8(dBytes.length, mapBuf);
        mapBuf.put(dBytes);
        mapBuf.flip();
        byte[] mapBytes = new byte[mapBuf.limit()];
        mapBuf.get(mapBytes);
        ByteBufferUtils.writeUnsignedITF8(mapBytes.length, os);
        os.write(mapBytes);
        int size = 0;
        for (EncodingKey encodingKey : this.eMap.keySet()) {
            if (this.eMap.get((Object)((Object)encodingKey)).id == EncodingID.NULL) continue;
            ++size;
        }
        ByteBuffer mapBuf2 = ByteBuffer.allocate(102400);
        ByteBufferUtils.writeUnsignedITF8(size, mapBuf2);
        for (EncodingKey eKey : this.eMap.keySet()) {
            if (this.eMap.get((Object)((Object)eKey)).id == EncodingID.NULL) continue;
            mapBuf2.put((byte)eKey.name().charAt(0));
            mapBuf2.put((byte)eKey.name().charAt(1));
            EncodingParams params = this.eMap.get((Object)eKey);
            mapBuf2.put((byte)(0xFF & params.id.ordinal()));
            ByteBufferUtils.writeUnsignedITF8(params.params.length, mapBuf2);
            mapBuf2.put(params.params);
        }
        mapBuf2.flip();
        byte[] byArray = new byte[mapBuf2.limit()];
        mapBuf2.get(byArray);
        ByteBufferUtils.writeUnsignedITF8(byArray.length, os);
        os.write(byArray);
        mapBuf = ByteBuffer.allocate(102400);
        ByteBufferUtils.writeUnsignedITF8(this.tMap.size(), mapBuf);
        for (Integer n2 : this.tMap.keySet()) {
            ByteBufferUtils.writeUnsignedITF8((int)n2, mapBuf);
            EncodingParams params = this.tMap.get(n2);
            mapBuf.put((byte)(0xFF & params.id.ordinal()));
            ByteBufferUtils.writeUnsignedITF8(params.params.length, mapBuf);
            mapBuf.put(params.params);
        }
        mapBuf.flip();
        mapBytes = new byte[mapBuf.limit()];
        mapBuf.get(mapBytes);
        ByteBufferUtils.writeUnsignedITF8(mapBytes.length, os);
        os.write(mapBytes);
    }
}

