/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.index;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.index.CramIndex;
import htsjdk.samtools.cram.io.CountingInputStream;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.util.Log;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPOutputStream;

class CraiIndexer {
    private static Log log = Log.getInstance(CraiIndexer.class);
    private CountingInputStream is;
    private SAMFileHeader samFileHeader;
    private CramIndex index;

    public CraiIndexer(InputStream is, File output) throws FileNotFoundException, IOException {
        this.is = new CountingInputStream(is);
        CramHeader cramHeader = CramIO.readCramHeader(this.is);
        this.samFileHeader = cramHeader.getSamFileHeader();
        this.index = new CramIndex(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(output))));
    }

    private boolean nextContainer() throws IOException {
        long offset = this.is.getCount();
        Container c2 = CramIO.readContainer(this.is);
        if (c2 == null) {
            return false;
        }
        c2.offset = offset;
        this.index.addContainer(c2);
        log.info("INDEXED: " + c2.toString());
        return true;
    }

    private void index() throws IOException {
        while (this.nextContainer()) {
        }
    }

    public void run() throws IOException {
        this.index();
        this.index.close();
    }
}

