/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;

public class GolombLongCodec
extends AbstractBitCodec<Long> {
    private int m;
    private boolean quotientBit = true;
    private long offset = 0L;

    public GolombLongCodec(int m2) {
        this(0L, m2, true);
    }

    public GolombLongCodec(long offset, int m2) {
        this(offset, m2, true);
    }

    public GolombLongCodec(long offset, int m2, boolean quotientBit) {
        if (m2 < 2) {
            throw new IllegalArgumentException("M parameter must be at least 2.");
        }
        this.m = m2;
        this.quotientBit = quotientBit;
        this.offset = offset;
    }

    @Override
    public final Long read(BitInputStream bis) throws IOException {
        long quotient = 0L;
        while (bis.readBit() == this.quotientBit) {
            ++quotient;
        }
        long ceiling = (long)(Math.log(this.m) / Math.log(2.0) + 1.0);
        long reminder = bis.readBits((int)(ceiling - 1L));
        if ((double)reminder >= Math.pow(2.0, ceiling) - (double)this.m) {
            reminder <<= 1;
            reminder |= (long)bis.readBits(1);
            reminder = (long)((double)reminder - (Math.pow(2.0, ceiling) - (double)this.m));
        }
        return quotient * (long)this.m + reminder - this.offset;
    }

    @Override
    public final long write(BitOutputStream bos, Long value) throws IOException {
        long newValue = value + this.offset;
        long quotient = newValue / (long)this.m;
        long reminder = newValue % (long)this.m;
        long ceiling = (long)(Math.log(this.m) / Math.log(2.0) + 1.0);
        long len = quotient + 1L;
        bos.write(this.quotientBit, quotient);
        bos.write(!this.quotientBit);
        if ((double)reminder < Math.pow(2.0, ceiling) - (double)this.m) {
            bos.write(reminder, (int)ceiling - 1);
            len += ceiling - 1L;
        } else {
            bos.write((int)((double)reminder + Math.pow(2.0, ceiling) - (double)this.m), (int)ceiling);
            len += ceiling;
        }
        return len;
    }

    @Override
    public final long numberOfBits(Long value) {
        long newValue = value + this.offset;
        long quotient = newValue / (long)this.m;
        long reminder = newValue % (long)this.m;
        long ceiling = (long)(Math.log(this.m) / Math.log(2.0) + 1.0);
        long l2 = quotient + 1L;
        l2 = (double)reminder < Math.pow(2.0, ceiling) - (double)this.m ? (l2 += ceiling - 1L) : (l2 += ceiling);
        return l2;
    }

    public int getM() {
        return this.m;
    }

    public boolean isQuotientBit() {
        return this.quotientBit;
    }

    public Long getOffset() {
        return this.offset;
    }

    public void setM(int m2) {
        this.m = m2;
    }

    public void setQuotientBit(boolean quotientBit) {
        this.quotientBit = quotientBit;
    }

    public void setOffset(Long offset) {
        this.offset = offset;
    }

    @Override
    public Long read(BitInputStream bis, int len) throws IOException {
        throw new RuntimeException("Multi-value read method not defined.");
    }
}

