/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ExternalLongCodec
extends AbstractBitCodec<Long> {
    private OutputStream os;
    private InputStream is;

    public ExternalLongCodec(OutputStream os, InputStream is) {
        this.os = os;
        this.is = is;
    }

    @Override
    public Long read(BitInputStream bis) throws IOException {
        long result = 0L;
        for (int i2 = 0; i2 < 8; ++i2) {
            result <<= 8;
            result |= (long)this.is.read();
        }
        return result;
    }

    @Override
    public long write(BitOutputStream bos, Long value) throws IOException {
        for (int i2 = 0; i2 < 8; ++i2) {
            this.os.write((int)(value & 0xFFL));
            value = value >>> 8;
        }
        return 64L;
    }

    @Override
    public long numberOfBits(Long object) {
        return 8L;
    }

    @Override
    public Long read(BitInputStream bis, int len) throws IOException {
        throw new RuntimeException("Not implemented.");
    }
}

