/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.common;

public class Version
implements Comparable<Version> {
    public final int major;
    public final int minor;
    public final int build;

    public Version(int major, int minor, int build) {
        this.major = major;
        this.minor = minor;
        this.build = build;
    }

    public Version(String version) {
        String[] numbers = version.split("[\\.\\-b]");
        this.major = Integer.valueOf(numbers[0]);
        this.minor = Integer.valueOf(numbers[1]);
        this.build = numbers.length > 3 ? Integer.valueOf(numbers[3]) : 0;
    }

    public String toString() {
        if (this.build > 0) {
            return String.format("%d.%d-b%d", this.major, this.minor, this.build);
        }
        return String.format("%d.%d", this.major, this.minor);
    }

    @Override
    public int compareTo(Version o2) {
        if (this.major - o2.major != 0) {
            return this.major - o2.major;
        }
        if (this.minor - o2.minor != 0) {
            return this.minor - o2.minor;
        }
        if (this.build < 1 || o2.build < 1) {
            return 0;
        }
        return this.build - o2.build;
    }
}

