/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.io.CountingInputStream;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.Block;
import htsjdk.samtools.cram.structure.BlockCompressionMethod;
import htsjdk.samtools.cram.structure.BlockContentType;
import htsjdk.samtools.cram.structure.CompressionHeaderBLock;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.ContainerHeaderIO;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.cram.structure.SliceIO;
import htsjdk.samtools.seekablestream.SeekableBufferedStream;
import htsjdk.samtools.seekablestream.SeekableFTPStream;
import htsjdk.samtools.seekablestream.SeekableFileStream;
import htsjdk.samtools.seekablestream.SeekableHTTPStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.seekablestream.UserPasswordInput;
import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.Log;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;

public class CramIO {
    public static int DEFINITION_LENGTH = 26;
    private static Log log = Log.getInstance(CramIO.class);
    public static byte[] ZERO_B_EOF_MARKER = ByteBufferUtils.bytesFromHex("0b 00 00 00 ff ff ff ff ff e0 45 4f 46 00 00 00 00 01 00 00 01 00 06 06 01 00 01 00 01 00");

    public static String getFileName(String urlString) {
        URL url = null;
        try {
            url = new URL(urlString);
            return new File(url.getFile()).getName();
        }
        catch (MalformedURLException e2) {
            return new File(urlString).getName();
        }
    }

    public static InputStream openInputStreamFromURL(String source) throws SocketException, IOException, URISyntaxException {
        URL url = null;
        try {
            url = new URL(source);
        }
        catch (MalformedURLException e2) {
            File file = new File(source);
            return new SeekableBufferedStream(new SeekableFileStream(file));
        }
        String protocol = url.getProtocol();
        if ("ftp".equalsIgnoreCase(protocol)) {
            return new SeekableBufferedStream(new NamedSeekableFTPStream(url));
        }
        if ("http".equalsIgnoreCase(protocol)) {
            return new SeekableBufferedStream(new SeekableHTTPStream(url));
        }
        if ("file".equalsIgnoreCase(protocol)) {
            File file = new File(url.toURI());
            return new SeekableBufferedStream(new SeekableFileStream(file));
        }
        throw new RuntimeException("Uknown protocol: " + protocol);
    }

    public static InputStream openCramInputStream(String cramURL, boolean decrypt, String password) throws IOException, URISyntaxException {
        InputStream is = null;
        is = cramURL == null ? new BufferedInputStream(System.in) : CramIO.openInputStreamFromURL(cramURL);
        if (decrypt) {
            throw new SAMException("Encryption not supported in this version.");
        }
        if (is instanceof SeekableStream) {
            CramHeader cramHeader = CramIO.readFormatDefinition(is, new CramHeader());
            SeekableStream s2 = (SeekableStream)is;
            if (!CramIO.hasZeroB_EOF_marker(s2)) {
                CramIO.eofNotFound(cramHeader.getMajorVersion(), cramHeader.getMinorVersion());
            }
            s2.seek(0L);
        } else {
            log.warn("CRAM file/stream completion cannot be verified.");
        }
        return is;
    }

    private static void eofNotFound(byte major, byte minor) {
        if (major >= 2 && minor >= 1) {
            log.error("Incomplete data: EOF marker not found.");
            System.exit(1);
        } else {
            log.warn("EOF marker not found, possibly incomplete file/stream.");
        }
    }

    public static Container readContainer(CramHeader cramHeader, InputStream is) throws IOException {
        Container c2 = CramIO.readContainer(is);
        if (c2 == null) {
            CramIO.eofNotFound(cramHeader.getMajorVersion(), cramHeader.getMinorVersion());
            return CramIO.readContainer(new ByteArrayInputStream(ZERO_B_EOF_MARKER));
        }
        if (c2.isEOF()) {
            log.debug("EOF marker found, file/stream is complete.");
        }
        return c2;
    }

    public static long issueZeroB_EOF_marker(OutputStream os) throws IOException {
        os.write(ZERO_B_EOF_MARKER);
        return ZERO_B_EOF_MARKER.length;
    }

    public static boolean hasZeroB_EOF_marker(SeekableStream s2) throws IOException {
        byte[] tail = new byte[ZERO_B_EOF_MARKER.length];
        s2.seek(s2.length() - (long)ZERO_B_EOF_MARKER.length);
        ByteBufferUtils.readFully(tail, s2);
        tail[8] = (byte)(tail[8] | 0xF0);
        return Arrays.equals(tail, ZERO_B_EOF_MARKER);
    }

    public static boolean hasZeroB_EOF_marker(File file) throws IOException {
        byte[] tail = new byte[ZERO_B_EOF_MARKER.length];
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        try {
            raf.seek(file.length() - (long)ZERO_B_EOF_MARKER.length);
            raf.readFully(tail);
        }
        catch (IOException e2) {
            throw e2;
        }
        finally {
            raf.close();
        }
        tail[8] = (byte)(tail[8] | 0xF0);
        return Arrays.equals(tail, ZERO_B_EOF_MARKER);
    }

    public static long writeCramHeader(CramHeader h2, OutputStream os) throws IOException {
        os.write("CRAM".getBytes("US-ASCII"));
        os.write(h2.getMajorVersion());
        os.write(h2.getMinorVersion());
        os.write(h2.id);
        for (int i2 = h2.id.length; i2 < 20; ++i2) {
            os.write(0);
        }
        long len = CramIO.writeContainerForSamFileHeader(h2.getSamFileHeader(), os);
        return (long)DEFINITION_LENGTH + len;
    }

    private static CramHeader readFormatDefinition(InputStream is, CramHeader header) throws IOException {
        for (byte b2 : CramHeader.magick) {
            if (b2 == is.read()) continue;
            throw new RuntimeException("Unknown file format.");
        }
        header.setMajorVersion((byte)is.read());
        header.setMinorVersion((byte)is.read());
        DataInputStream dis = new DataInputStream(is);
        dis.readFully(header.id);
        return header;
    }

    public static CramHeader readCramHeader(InputStream is) throws IOException {
        CramHeader header = new CramHeader();
        CramIO.readFormatDefinition(is, header);
        header.setSamFileHeader(CramIO.readSAMFileHeader(new String(header.id), is));
        return header;
    }

    public static int writeContainer(Container c2, OutputStream os) throws IOException {
        int i2;
        long time1 = System.nanoTime();
        ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream();
        CompressionHeaderBLock block = new CompressionHeaderBLock(c2.h);
        block.write(baos);
        c2.blockCount = 1;
        ArrayList<Integer> landmarks = new ArrayList<Integer>();
        SliceIO sio = new SliceIO();
        for (i2 = 0; i2 < c2.slices.length; ++i2) {
            Slice s2 = c2.slices[i2];
            landmarks.add(baos.size());
            sio.write(s2, baos);
            ++c2.blockCount;
            ++c2.blockCount;
            if (s2.embeddedRefBlock != null) {
                ++c2.blockCount;
            }
            c2.blockCount += s2.external.size();
        }
        c2.landmarks = new int[landmarks.size()];
        for (i2 = 0; i2 < c2.landmarks.length; ++i2) {
            c2.landmarks[i2] = (Integer)landmarks.get(i2);
        }
        c2.containerByteSize = baos.size();
        CramIO.calculateSliceOffsetsAndSizes(c2);
        ContainerHeaderIO chio = new ContainerHeaderIO();
        int len = chio.writeContainerHeader(c2, os);
        os.write(baos.getBuffer(), 0, baos.size());
        long time2 = System.nanoTime();
        log.debug("CONTAINER WRITTEN: " + c2.toString());
        c2.writeTime = time2 - time1;
        return len += baos.size();
    }

    public static Container readContainer(InputStream is) throws IOException {
        return CramIO.readContainer(is, 0, Integer.MAX_VALUE);
    }

    public static Container readContainerHeader(InputStream is) throws IOException {
        ContainerHeaderIO chio = new ContainerHeaderIO();
        Container c2 = new Container();
        if (!chio.readContainerHeader(c2, is)) {
            return null;
        }
        return c2;
    }

    private static Container readContainer(InputStream is, int fromSlice, int howManySlices) throws IOException {
        long time1 = System.nanoTime();
        Container c2 = CramIO.readContainerHeader(is);
        if (c2 == null) {
            return null;
        }
        CompressionHeaderBLock chb = new CompressionHeaderBLock(is);
        c2.h = chb.getCompressionHeader();
        howManySlices = Math.min(c2.landmarks.length, howManySlices);
        if (fromSlice > 0) {
            is.skip(c2.landmarks[fromSlice]);
        }
        SliceIO sio = new SliceIO();
        ArrayList<Slice> slices = new ArrayList<Slice>();
        int s2 = fromSlice;
        while (s2 < howManySlices - fromSlice) {
            Slice slice = new Slice();
            slice.index = s2++;
            sio.readSliceHeadBlock(slice, is);
            sio.readSliceBlocks(slice, true, is);
            slices.add(slice);
        }
        c2.slices = slices.toArray(new Slice[slices.size()]);
        CramIO.calculateSliceOffsetsAndSizes(c2);
        long time2 = System.nanoTime();
        log.debug("READ CONTAINER: " + c2.toString());
        c2.readTime = time2 - time1;
        return c2;
    }

    private static void calculateSliceOffsetsAndSizes(Container c2) {
        if (c2.slices.length == 0) {
            return;
        }
        for (int i2 = 0; i2 < c2.slices.length - 1; ++i2) {
            Slice s2 = c2.slices[i2];
            s2.offset = c2.landmarks[i2];
            s2.size = c2.landmarks[i2 + 1] - s2.offset;
        }
        Slice lastSlice = c2.slices[c2.slices.length - 1];
        lastSlice.offset = c2.landmarks[c2.landmarks.length - 1];
        lastSlice.size = c2.containerByteSize - lastSlice.offset;
    }

    public static byte[] toByteArray(SAMFileHeader samFileHeader) {
        ExposedByteArrayOutputStream headerBodyOS = new ExposedByteArrayOutputStream();
        OutputStreamWriter w2 = new OutputStreamWriter(headerBodyOS);
        new SAMTextHeaderCodec().encode(w2, samFileHeader);
        try {
            w2.close();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putInt(headerBodyOS.size());
        buf.flip();
        byte[] bytes = new byte[buf.limit()];
        buf.get(bytes);
        ByteArrayOutputStream headerOS = new ByteArrayOutputStream();
        try {
            headerOS.write(bytes);
            headerOS.write(headerBodyOS.getBuffer(), 0, headerBodyOS.size());
        }
        catch (IOException e3) {
            throw new RuntimeException(e3);
        }
        return headerOS.toByteArray();
    }

    private static long writeContainerForSamFileHeader(SAMFileHeader samFileHeader, OutputStream os) throws IOException {
        byte[] data = CramIO.toByteArray(samFileHeader);
        return CramIO.writeContainerForSamFileHeaderData(data, 0, Math.max(1024, data.length + data.length / 2), os);
    }

    private static long writeContainerForSamFileHeaderData(byte[] data, int offset, int len, OutputStream os) throws IOException {
        Block block = new Block();
        byte[] blockContent = new byte[len];
        System.arraycopy(data, 0, blockContent, offset, Math.min(data.length - offset, len));
        block.setRawContent(blockContent);
        block.method = BlockCompressionMethod.RAW;
        block.contentId = 0;
        block.contentType = BlockContentType.FILE_HEADER;
        block.compress();
        Container c2 = new Container();
        c2.blockCount = 1;
        c2.blocks = new Block[]{block};
        c2.landmarks = new int[0];
        c2.slices = new Slice[0];
        c2.alignmentSpan = 0;
        c2.alignmentStart = 0;
        c2.bases = 0L;
        c2.globalRecordCounter = 0L;
        c2.nofRecords = 0;
        c2.sequenceId = 0;
        ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream();
        block.write(baos);
        c2.containerByteSize = baos.size();
        ContainerHeaderIO chio = new ContainerHeaderIO();
        int containerHeaderByteSize = chio.writeContainerHeader(c2, os);
        os.write(baos.getBuffer(), 0, baos.size());
        return containerHeaderByteSize + baos.size();
    }

    public static SAMFileHeader readSAMFileHeader(String id, InputStream is) throws IOException {
        CramIO.readContainerHeader(is);
        Block b2 = new Block(is, true, true);
        is = new ByteArrayInputStream(b2.getRawContent());
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        for (int i2 = 0; i2 < 4; ++i2) {
            buf.put((byte)is.read());
        }
        buf.flip();
        int size = buf.asIntBuffer().get();
        DataInputStream dis = new DataInputStream(is);
        byte[] bytes = new byte[size];
        dis.readFully(bytes);
        BufferedLineReader r2 = new BufferedLineReader(new ByteArrayInputStream(bytes));
        SAMTextHeaderCodec codec = new SAMTextHeaderCodec();
        SAMFileHeader header = codec.decode(r2, id);
        return header;
    }

    public static boolean replaceCramHeader(File file, CramHeader newHeader) throws IOException {
        int MAP_SIZE = (int)Math.min(0x100000L, file.length());
        FileInputStream inputStream = new FileInputStream(file);
        CountingInputStream cis = new CountingInputStream(inputStream);
        CramHeader header = new CramHeader();
        CramIO.readFormatDefinition(cis, header);
        if (header.getMajorVersion() != newHeader.getMajorVersion() && header.getMinorVersion() != newHeader.getMinorVersion()) {
            log.error(String.format("Cannot replace CRAM header because format versions differ: ", header.getMajorVersion(), header.getMinorVersion(), newHeader.getMajorVersion(), header.getMinorVersion(), file.getAbsolutePath()));
            cis.close();
            return false;
        }
        CramIO.readContainerHeader(cis);
        Block b2 = new Block(cis, false, false);
        long dataStart = cis.getCount();
        cis.close();
        byte[] data = CramIO.toByteArray(newHeader.getSamFileHeader());
        if (data.length > b2.getRawContentSize()) {
            log.error("Failed to replace CRAM header because the new header is bigger.");
            return false;
        }
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        FileChannel channelOut = raf.getChannel();
        MappedByteBuffer mapOut = channelOut.map(FileChannel.MapMode.READ_WRITE, dataStart, (long)MAP_SIZE - dataStart);
        mapOut.put(data);
        mapOut.force();
        channelOut.close();
        raf.close();
        return true;
    }

    private static class NamedSeekableFTPStream
    extends SeekableFTPStream {
        private URL source;

        public NamedSeekableFTPStream(URL url) throws IOException {
            super(url);
            this.source = url;
        }

        public NamedSeekableFTPStream(URL url, UserPasswordInput userPasswordInput) throws IOException {
            super(url, userPasswordInput);
            this.source = url;
        }

        @Override
        public String getSource() {
            return this.source.toString();
        }
    }
}

