/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.cram.encoding.read_features.Deletion;
import htsjdk.samtools.cram.encoding.read_features.HardClip;
import htsjdk.samtools.cram.encoding.read_features.Insertion;
import htsjdk.samtools.cram.encoding.read_features.Padding;
import htsjdk.samtools.cram.encoding.read_features.ReadFeature;
import htsjdk.samtools.cram.encoding.read_features.RefSkip;
import htsjdk.samtools.cram.encoding.read_features.SoftClip;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.ReadTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class Cram2SamRecordFactory {
    private SAMFileHeader header;

    public Cram2SamRecordFactory(SAMFileHeader header) {
        this.header = header;
    }

    public SAMRecord create(CramCompressionRecord cramRecord) {
        SAMRecord samRecord = new SAMRecord(this.header);
        samRecord.setReadName(cramRecord.readName);
        Cram2SamRecordFactory.copyFlags(cramRecord, samRecord);
        if (cramRecord.sequenceId == -1) {
            samRecord.setAlignmentStart(0);
            samRecord.setMappingQuality(0);
            samRecord.setReferenceIndex(-1);
        } else {
            samRecord.setReferenceIndex(cramRecord.sequenceId);
            samRecord.setAlignmentStart(cramRecord.alignmentStart);
            samRecord.setMappingQuality(cramRecord.mappingQuality);
        }
        if (cramRecord.isSegmentUnmapped()) {
            samRecord.setCigarString("*");
        } else {
            samRecord.setCigar(Cram2SamRecordFactory.getCigar2(cramRecord.readFeatures, cramRecord.readLength));
        }
        if (samRecord.getReadPairedFlag()) {
            samRecord.setMateReferenceIndex(cramRecord.mateSequenceID);
            samRecord.setMateAlignmentStart(cramRecord.mateAlignmentStart > 0 ? cramRecord.mateAlignmentStart : 0);
            samRecord.setMateNegativeStrandFlag(cramRecord.isMateNegativeStrand());
            samRecord.setMateUnmappedFlag(cramRecord.isMateUmapped());
        } else {
            samRecord.setMateReferenceIndex(-1);
            samRecord.setMateAlignmentStart(0);
        }
        samRecord.setInferredInsertSize(cramRecord.templateSize);
        samRecord.setReadBases(cramRecord.readBases);
        samRecord.setBaseQualities(cramRecord.qualityScores);
        if (cramRecord.tags != null) {
            for (ReadTag tag : cramRecord.tags) {
                samRecord.setAttribute(tag.getKey(), tag.getValue());
            }
        }
        if (cramRecord.readGroupID > -1) {
            SAMReadGroupRecord readGroupRecord = this.header.getReadGroups().get(cramRecord.readGroupID);
            samRecord.setAttribute("RG", (Object)readGroupRecord.getId());
        }
        return samRecord;
    }

    private static final void copyFlags(CramCompressionRecord cr, SAMRecord sr) {
        sr.setReadPairedFlag(cr.isMultiFragment());
        sr.setProperPairFlag(cr.isProperPair());
        sr.setReadUnmappedFlag(cr.isSegmentUnmapped());
        sr.setReadNegativeStrandFlag(cr.isNegativeStrand());
        sr.setFirstOfPairFlag(cr.isFirstSegment());
        sr.setSecondOfPairFlag(cr.isLastSegment());
        sr.setNotPrimaryAlignmentFlag(cr.isSecondaryAlignment());
        sr.setReadFailsVendorQualityCheckFlag(cr.isVendorFiltered());
        sr.setDuplicateReadFlag(cr.isDuplicate());
    }

    private static final Cigar getCigar2(Collection<ReadFeature> features, int readLength) {
        CigarElement ce;
        if (features == null || features.isEmpty()) {
            CigarElement ce2 = new CigarElement(readLength, CigarOperator.M);
            return new Cigar(Arrays.asList(ce2));
        }
        ArrayList<CigarElement> list = new ArrayList<CigarElement>();
        int totalOpLen = 1;
        CigarOperator lastOperator = CigarOperator.MATCH_OR_MISMATCH;
        int lastOpLen = 0;
        int lastOpPos = 1;
        CigarOperator co = null;
        int rfLen = 0;
        block10: for (ReadFeature f2 : features) {
            int gap = f2.getPosition() - (lastOpPos + lastOpLen);
            if (gap > 0) {
                if (lastOperator != CigarOperator.MATCH_OR_MISMATCH) {
                    list.add(new CigarElement(lastOpLen, lastOperator));
                    lastOpPos += lastOpLen;
                    totalOpLen += lastOpLen;
                    lastOpLen = gap;
                } else {
                    lastOpLen += gap;
                }
                lastOperator = CigarOperator.MATCH_OR_MISMATCH;
            }
            switch (f2.getOperator()) {
                case 73: {
                    co = CigarOperator.INSERTION;
                    rfLen = ((Insertion)f2).getSequence().length;
                    break;
                }
                case 83: {
                    co = CigarOperator.SOFT_CLIP;
                    rfLen = ((SoftClip)f2).getSequence().length;
                    break;
                }
                case 72: {
                    co = CigarOperator.HARD_CLIP;
                    rfLen = ((HardClip)f2).getLength();
                    break;
                }
                case 105: {
                    co = CigarOperator.INSERTION;
                    rfLen = 1;
                    break;
                }
                case 68: {
                    co = CigarOperator.DELETION;
                    rfLen = ((Deletion)f2).getLength();
                    break;
                }
                case 78: {
                    co = CigarOperator.SKIPPED_REGION;
                    rfLen = ((RefSkip)f2).getLength();
                    break;
                }
                case 80: {
                    co = CigarOperator.PADDING;
                    rfLen = ((Padding)f2).getLength();
                    break;
                }
                case 66: 
                case 88: {
                    co = CigarOperator.MATCH_OR_MISMATCH;
                    rfLen = 1;
                    break;
                }
                default: {
                    continue block10;
                }
            }
            if (lastOperator != co) {
                if (lastOpLen > 0) {
                    list.add(new CigarElement(lastOpLen, lastOperator));
                    totalOpLen += lastOpLen;
                }
                lastOperator = co;
                lastOpLen = rfLen;
                lastOpPos = f2.getPosition();
            } else {
                lastOpLen += rfLen;
            }
            if (co.consumesReadBases()) continue;
            lastOpPos -= rfLen;
        }
        if (lastOperator != null) {
            if (lastOperator != CigarOperator.M) {
                list.add(new CigarElement(lastOpLen, lastOperator));
                if (readLength >= lastOpPos + lastOpLen) {
                    ce = new CigarElement(readLength - (lastOpLen + lastOpPos) + 1, CigarOperator.M);
                    list.add(ce);
                }
            } else if (readLength > lastOpPos - 1) {
                ce = new CigarElement(readLength - lastOpPos + 1, CigarOperator.M);
                list.add(ce);
            }
        }
        if (list.isEmpty()) {
            ce = new CigarElement(readLength, CigarOperator.M);
            return new Cigar(Arrays.asList(ce));
        }
        return new Cigar(list);
    }
}

