/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.cram.encoding.reader.CramRecordReader;
import htsjdk.samtools.cram.encoding.reader.DataReaderFactory;
import htsjdk.samtools.cram.io.DefaultBitInputStream;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.util.Log;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ContainerParser {
    private static Log log = Log.getInstance(ContainerParser.class);
    private SAMFileHeader samFileHeader;
    private Map<String, Long> nanoMap = new TreeMap<String, Long>();

    public ContainerParser(SAMFileHeader samFileHeader) {
        this.samFileHeader = samFileHeader;
    }

    public List<CramCompressionRecord> getRecords(Container container, ArrayList<CramCompressionRecord> records) throws IllegalArgumentException, IllegalAccessException, IOException {
        long time1 = System.nanoTime();
        if (records == null) {
            records = new ArrayList(container.nofRecords);
        }
        for (Slice s2 : container.slices) {
            records.addAll(this.getRecords(s2, container.h));
        }
        long time2 = System.nanoTime();
        container.parseTime = time2 - time1;
        if (log.isEnabled(Log.LogLevel.DEBUG)) {
            for (String key : this.nanoMap.keySet()) {
                log.debug(String.format("%s: %dms.", key, this.nanoMap.get(key) / 1000000L));
            }
        }
        return records;
    }

    public List<CramCompressionRecord> getRecords(Slice s2, CompressionHeader h2) throws IllegalArgumentException, IllegalAccessException, IOException {
        String seqName = "*";
        switch (s2.sequenceId) {
            case -1: {
                break;
            }
            case -2: {
                break;
            }
            default: {
                SAMSequenceRecord sequence = this.samFileHeader.getSequence(s2.sequenceId);
                seqName = sequence.getSequenceName();
            }
        }
        DataReaderFactory f2 = new DataReaderFactory();
        HashMap<Integer, InputStream> inputMap = new HashMap<Integer, InputStream>();
        for (Integer exId : s2.external.keySet()) {
            inputMap.put(exId, new ByteArrayInputStream(s2.external.get(exId).getRawContent()));
        }
        long time = 0L;
        CramRecordReader reader = new CramRecordReader();
        f2.buildReader(reader, new DefaultBitInputStream(new ByteArrayInputStream(s2.coreBlock.getRawContent())), inputMap, h2, s2.sequenceId);
        ArrayList<CramCompressionRecord> records = new ArrayList<CramCompressionRecord>();
        long readNanos = 0L;
        int prevStart = s2.alignmentStart;
        for (int i2 = 0; i2 < s2.nofRecords; ++i2) {
            String name;
            CramCompressionRecord r2 = new CramCompressionRecord();
            r2.sliceIndex = s2.index;
            r2.index = i2;
            try {
                time = System.nanoTime();
                reader.read(r2);
                readNanos += System.nanoTime() - time;
            }
            catch (EOFException e2) {
                e2.printStackTrace();
                throw e2;
            }
            r2.sequenceName = r2.sequenceId == s2.sequenceId ? seqName : (r2.sequenceId == -1 ? "*" : (name = this.samFileHeader.getSequence(r2.sequenceId).getSequenceName()));
            records.add(r2);
            if (!h2.AP_seriesDelta) continue;
            r2.alignmentStart = prevStart += r2.alignmentDelta;
        }
        log.debug("Slice records read time: " + readNanos / 1000000L);
        Map<String, DataReaderFactory.DataReaderWithStats> statMap = f2.getStats(reader);
        for (String key : statMap.keySet()) {
            long value = 0L;
            if (!this.nanoMap.containsKey(key)) {
                this.nanoMap.put(key, 0L);
                value = 0L;
            } else {
                value = this.nanoMap.get(key);
            }
            this.nanoMap.put(key, value + statMap.get((Object)key).nanos);
        }
        return records;
    }
}

